/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.mixin;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraftforge.common.ForgeConfigSpec;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ForgeConfigSpec.class})
public class MixinForgeConfigSpec {
    @Shadow(remap=false)
    private Map<List<String>, String> levelComments;

    @Inject(method={"correct(Lcom/electronwill/nightconfig/core/UnmodifiableConfig;Lcom/electronwill/nightconfig/core/CommentedConfig;Ljava/util/LinkedList;Ljava/util/List;Lcom/electronwill/nightconfig/core/ConfigSpec$CorrectionListener;Lcom/electronwill/nightconfig/core/ConfigSpec$CorrectionListener;Z)I"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private void correct(UnmodifiableConfig spec, CommentedConfig config, LinkedList<String> parentPath, List<String> parentPathUnmodifiable, ConfigSpec.CorrectionListener listener, ConfigSpec.CorrectionListener commentListener, boolean dryRun, CallbackInfoReturnable<Integer> cir) {
        if (config instanceof FileConfig && ((FileConfig)config).getNioPath().toString().contains("coldsweat")) {
            int count = this.beautifulCorrect(spec, config, parentPath, parentPathUnmodifiable, listener, commentListener, dryRun);
            cir.setReturnValue((Object)count);
        }
    }

    private int beautifulCorrect(UnmodifiableConfig spec, CommentedConfig config, LinkedList<String> parentPath, List<String> parentPathUnmodifiable, ConfigSpec.CorrectionListener listener, ConfigSpec.CorrectionListener commentListener, boolean dryRun) {
        int count = 0;
        Map specMap = spec.valueMap();
        Map configMap = config.valueMap();
        for (Map.Entry specEntry : specMap.entrySet()) {
            String oldComment;
            String key = (String)specEntry.getKey();
            Object specValue = specEntry.getValue();
            Object configValue = configMap.get(key);
            ConfigSpec.CorrectionAction action = configValue == null ? ConfigSpec.CorrectionAction.ADD : ConfigSpec.CorrectionAction.REPLACE;
            parentPath.addLast(key);
            if (specValue instanceof Config) {
                if (configValue instanceof CommentedConfig) {
                    if ((count += this.beautifulCorrect((UnmodifiableConfig)((Config)specValue), (CommentedConfig)configValue, parentPath, parentPathUnmodifiable, listener, commentListener, dryRun)) > 0 && dryRun) {
                        return count;
                    }
                } else {
                    if (dryRun) {
                        return 1;
                    }
                    CommentedConfig newValue = config.createSubConfig();
                    configMap.put(key, newValue);
                    listener.onCorrect(action, parentPathUnmodifiable, configValue, (Object)newValue);
                    if (action != ConfigSpec.CorrectionAction.ADD) {
                        ++count;
                    }
                    count += this.beautifulCorrect((UnmodifiableConfig)((Config)specValue), newValue, parentPath, parentPathUnmodifiable, listener, commentListener, dryRun);
                }
                String newComment = this.levelComments.get(parentPath);
                oldComment = config.getComment(key);
                if (!this.isCommentFormattingChange(oldComment, newComment) && !this.stringsMatchIgnoringNewlines(oldComment, newComment)) {
                    if (commentListener != null) {
                        commentListener.onCorrect(action, parentPathUnmodifiable, (Object)oldComment, (Object)newComment);
                    }
                    if (dryRun) {
                        return 1;
                    }
                    config.setComment(key, newComment);
                }
            } else {
                String expectedComment;
                ForgeConfigSpec.ValueSpec valueSpec = (ForgeConfigSpec.ValueSpec)specValue;
                if (!this.isValueCorrectWithFormatting(valueSpec, configValue)) {
                    if (dryRun) {
                        return 1;
                    }
                    Object newValue = valueSpec.correct(configValue);
                    configMap.put(key, newValue);
                    listener.onCorrect(action, parentPathUnmodifiable, configValue, newValue);
                    if (action != ConfigSpec.CorrectionAction.ADD) {
                        ++count;
                    }
                }
                if (!this.isCommentFormattingChange(oldComment = config.getComment(key), expectedComment = valueSpec.getComment()) && !this.stringsMatchIgnoringNewlines(oldComment, expectedComment)) {
                    if (commentListener != null) {
                        commentListener.onCorrect(action, parentPathUnmodifiable, (Object)oldComment, (Object)expectedComment);
                    }
                    if (dryRun) {
                        return 1;
                    }
                    config.setComment(key, expectedComment);
                }
            }
            parentPath.removeLast();
        }
        Iterator ittr = configMap.entrySet().iterator();
        while (ittr.hasNext()) {
            Map.Entry entry = ittr.next();
            if (specMap.containsKey(entry.getKey())) continue;
            if (dryRun) {
                return 1;
            }
            ittr.remove();
            parentPath.addLast((String)entry.getKey());
            listener.onCorrect(ConfigSpec.CorrectionAction.REMOVE, parentPathUnmodifiable, entry.getValue(), null);
            parentPath.removeLast();
            ++count;
        }
        return count;
    }

    private boolean isCommentFormattingChange(String oldComment, String newComment) {
        boolean newHasDirective;
        boolean oldHasDirective = oldComment != null && oldComment.contains("//v");
        boolean bl = newHasDirective = newComment != null && newComment.contains("//v");
        if (oldHasDirective != newHasDirective) {
            String normalizedOld = this.normalizeCommentForComparison(oldComment);
            String normalizedNew = this.normalizeCommentForComparison(newComment);
            return this.stringsMatchIgnoringNewlines(normalizedOld, normalizedNew);
        }
        return this.stringsMatchIgnoringNewlines(oldComment, newComment);
    }

    private String normalizeCommentForComparison(String comment) {
        if (comment == null) {
            return "";
        }
        String normalized = comment.replace("//v", "").trim();
        if (normalized.equals("#") || normalized.isEmpty()) {
            return "";
        }
        return normalized;
    }

    private boolean isValueCorrectWithFormatting(ForgeConfigSpec.ValueSpec valueSpec, Object configValue) {
        if (valueSpec.test(configValue)) {
            return true;
        }
        return configValue instanceof List && this.isListFormattingEquivalent(valueSpec, (List)configValue);
    }

    private boolean isListFormattingEquivalent(ForgeConfigSpec.ValueSpec valueSpec, List<?> configValue) {
        try {
            Object correctedValue = valueSpec.correct(configValue);
            if (correctedValue instanceof List) {
                List correctedList = (List)correctedValue;
                if (configValue.size() != correctedList.size()) {
                    return false;
                }
                for (int i = 0; i < configValue.size(); ++i) {
                    Object correctedElement;
                    Object configElement = configValue.get(i);
                    if (Objects.equals(configElement, correctedElement = correctedList.get(i))) continue;
                    return false;
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean stringsMatchIgnoringNewlines(String str1, String str2) {
        if (str1 == str2) {
            return true;
        }
        if (str1 == null || str2 == null) {
            return false;
        }
        String normalized1 = str1.replaceAll("\\s+", " ").trim();
        String normalized2 = str2.replaceAll("\\s+", " ").trim();
        return normalized1.equals(normalized2);
    }
}

