/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.entity;

import com.momosoftworks.coldsweat.common.item.SoulspringLampItem;
import com.momosoftworks.coldsweat.util.ClientOnlyHelper;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import com.momosoftworks.coldsweat.util.serialization.ObjectBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameType;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class EntityHelper {
    static final Method GET_VOICE_PITCH = ObfuscationReflectionHelper.findMethod(LivingEntity.class, (String)"func_70647_i", (Class[])new Class[0]);

    private EntityHelper() {
    }

    public static ItemStack getItemInHand(LivingEntity player, HandSide hand) {
        return player.func_184586_b(hand == player.func_184591_cq() ? Hand.MAIN_HAND : Hand.OFF_HAND);
    }

    public static HandSide getArmFromHand(Hand hand, PlayerEntity player) {
        return hand == Hand.MAIN_HAND ? player.func_184591_cq() : (player.func_184591_cq() == HandSide.RIGHT ? HandSide.LEFT : HandSide.RIGHT);
    }

    public static boolean holdingLamp(LivingEntity player, HandSide arm) {
        return EntityHelper.getItemInHand(player, arm).func_77973_b() == ModItems.SOULSPRING_LAMP;
    }

    public static boolean holdingLitLamp(LivingEntity player) {
        return Stream.of(HandSide.LEFT, HandSide.RIGHT).anyMatch(arm -> EntityHelper.holdingLamp(player, arm) && SoulspringLampItem.isLit(EntityHelper.getItemInHand(player, arm)));
    }

    public static Vector3d getCenterOf(Entity entity) {
        return entity.func_213303_ch().func_72441_c(0.0, (double)(entity.func_213302_cg() / 2.0f), 0.0);
    }

    public static HandSide getHandSide(Hand hand, PlayerEntity player) {
        return hand == Hand.MAIN_HAND ? player.func_184591_cq() : (player.func_184591_cq() == HandSide.RIGHT ? HandSide.LEFT : HandSide.RIGHT);
    }

    public static float getVoicePitch(LivingEntity entity) {
        try {
            return ((Float)GET_VOICE_PITCH.invoke((Object)entity, new Object[0])).floatValue();
        }
        catch (Exception e) {
            return 1.0f;
        }
    }

    public static GameType getGameModeForPlayer(PlayerEntity player) {
        return player instanceof ServerPlayerEntity ? ObjectBuilder.build(() -> {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            Field gameMode = ObfuscationReflectionHelper.findField(ServerPlayerEntity.class, (String)"field_71134_c");
            gameMode.setAccessible(true);
            try {
                return (GameType)gameMode.get(serverPlayer);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }) : ClientOnlyHelper.getGameMode();
    }

    public static ServerPlayerEntity getServerPlayer(PlayerEntity player) {
        return ((MinecraftServer)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER)).func_184103_al().func_177451_a(player.func_110124_au());
    }

    @Nullable
    public static EquipmentSlotType getEquipmentSlot(int index) {
        if (index == 100 + EquipmentSlotType.HEAD.func_188454_b()) {
            return EquipmentSlotType.HEAD;
        }
        if (index == 100 + EquipmentSlotType.CHEST.func_188454_b()) {
            return EquipmentSlotType.CHEST;
        }
        if (index == 100 + EquipmentSlotType.LEGS.func_188454_b()) {
            return EquipmentSlotType.LEGS;
        }
        if (index == 100 + EquipmentSlotType.FEET.func_188454_b()) {
            return EquipmentSlotType.FEET;
        }
        if (index == 98) {
            return EquipmentSlotType.MAINHAND;
        }
        return index == 99 ? EquipmentSlotType.OFFHAND : null;
    }

    static {
        GET_VOICE_PITCH.setAccessible(true);
    }
}

