/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.serialization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class ListBuilder<T> {
    ArrayList<T> elements = new ArrayList();

    @SafeVarargs
    private ListBuilder(T ... elements) {
        this.elements.addAll(Arrays.asList(elements));
    }

    private ListBuilder(T element) {
        this.elements.add(element);
    }

    @SafeVarargs
    public static <E> ListBuilder<E> begin(E ... elements) {
        return new ListBuilder<E[]>(elements);
    }

    public static <E> ListBuilder<E> begin(List<E> elements) {
        ListBuilder<Object[]> builder = new ListBuilder<Object[]>(new Object[0]);
        builder.elements.addAll(elements);
        return builder;
    }

    public static <E> ListBuilder<E> begin(E element) {
        return new ListBuilder<E>(element);
    }

    @SafeVarargs
    public final ListBuilder<T> addIf(boolean condition, Supplier<T> ... elements) {
        if (condition) {
            this.elements.addAll(Arrays.stream(elements).map(Supplier::get).collect(Collectors.toList()));
        }
        return this;
    }

    public final ListBuilder<T> addAllIf(boolean condition, List<T> elements) {
        if (condition) {
            this.elements.addAll(elements);
        }
        return this;
    }

    public final ListBuilder<T> addIf(boolean condition, Supplier<T> supplier) {
        T element;
        if (condition && (element = supplier.get()) != null) {
            this.elements.add(element);
        }
        return this;
    }

    @SafeVarargs
    public final ListBuilder<T> add(T ... elements) {
        this.elements.addAll(Arrays.asList(elements));
        return this;
    }

    public final ListBuilder<T> addAll(List<?> elements) {
        this.elements.addAll(elements);
        return this;
    }

    public ListBuilder<T> add(T element) {
        this.elements.add(element);
        return this;
    }

    public ListBuilder<T> fill(int count, Supplier<T> supplier) {
        for (int i = 0; i < count; ++i) {
            this.elements.add(supplier.get());
        }
        return this;
    }

    public ArrayList<T> build() {
        return this.elements;
    }
}

