/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.data;

import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.data.ChunkTeamDataImpl;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkImpl;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class TeamMemberData {
    private int maxClaims;
    private int maxForceLoads;
    private boolean offlineForceLoader;
    private final Set<ChunkDimPos> originalClaims;

    private TeamMemberData(int maxClaims, int maxForceLoads, boolean offlineForceLoader, Set<ChunkDimPos> originalClaims) {
        this.maxClaims = maxClaims;
        this.maxForceLoads = maxForceLoads;
        this.offlineForceLoader = offlineForceLoader;
        this.originalClaims = originalClaims;
    }

    public static TeamMemberData defaultData() {
        return new TeamMemberData((Integer)FTBChunksWorldConfig.MAX_CLAIMED_CHUNKS.get(), (Integer)FTBChunksWorldConfig.MAX_FORCE_LOADED_CHUNKS.get(), false, new HashSet<ChunkDimPos>());
    }

    public static TeamMemberData deserializeNBT(CompoundTag tag) {
        int maxClaims = tag.m_128451_("max_claimed_chunks");
        int maxForced = tag.m_128451_("max_force_loaded_chunks");
        boolean offline = tag.m_128471_("offline_force_loader");
        Set<ChunkDimPos> orig = TeamMemberData.readOriginalClaims(tag.m_128469_("original_claims"));
        return new TeamMemberData(maxClaims, maxForced, offline, orig);
    }

    public static TeamMemberData fromPlayerData(ServerPlayer player, ChunkTeamDataImpl otherTeam) {
        return new TeamMemberData(otherTeam.getMaxClaimChunks() + otherTeam.getExtraClaimChunks(), otherTeam.getMaxForceLoadChunks() + otherTeam.getExtraForceLoadChunks(), FTBChunksWorldConfig.canPlayerOfflineForceload(player), new HashSet<ChunkDimPos>(otherTeam.getClaimedChunks().stream().map(ClaimedChunkImpl::getPos).toList()));
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("max_claimed_chunks", this.maxClaims);
        tag.m_128405_("max_force_loaded_chunks", this.maxForceLoads);
        tag.m_128379_("offline_force_loader", this.offlineForceLoader);
        CompoundTag origTag = this.writeOriginalClaims();
        if (!origTag.m_128456_()) {
            tag.m_128365_("original_claims", (Tag)origTag);
        }
        return tag;
    }

    private CompoundTag writeOriginalClaims() {
        CompoundTag origTag = new CompoundTag();
        HashMap<String, ListTag> perDimensionTags = new HashMap<String, ListTag>();
        this.originalClaims.forEach(cdp -> {
            ListTag l = perDimensionTags.computeIfAbsent(cdp.dimension().m_135782_().toString(), k -> new ListTag());
            SNBTCompoundTag cdpTag = new SNBTCompoundTag();
            cdpTag.singleLine();
            cdpTag.m_128405_("x", cdp.x());
            cdpTag.m_128405_("z", cdp.z());
            l.add((Object)cdpTag);
        });
        perDimensionTags.forEach((arg_0, arg_1) -> ((CompoundTag)origTag).m_128365_(arg_0, arg_1));
        return origTag;
    }

    private static Set<ChunkDimPos> readOriginalClaims(CompoundTag tag) {
        HashSet<ChunkDimPos> res = new HashSet<ChunkDimPos>();
        for (String dimStr : tag.m_128431_()) {
            try {
                ResourceKey dimKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(dimStr));
                HashSet cdpSet = new HashSet();
                tag.m_128437_(dimStr, 10).forEach(el -> {
                    if (el instanceof CompoundTag) {
                        CompoundTag c = (CompoundTag)el;
                        cdpSet.add(new ChunkDimPos(dimKey, c.m_128451_("x"), c.m_128451_("z")));
                    }
                });
                res.addAll(cdpSet);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return res;
    }

    public int getMaxClaims() {
        return this.maxClaims;
    }

    public void setMaxClaims(int maxClaims) {
        this.maxClaims = maxClaims;
    }

    public int getMaxForceLoads() {
        return this.maxForceLoads;
    }

    public void setMaxForceLoads(int maxForceLoads) {
        this.maxForceLoads = maxForceLoads;
    }

    public boolean isOfflineForceLoader() {
        return this.offlineForceLoader;
    }

    public void setOfflineForceLoader(boolean offlineForceLoader) {
        this.offlineForceLoader = offlineForceLoader;
    }

    public Set<ChunkDimPos> getOriginalClaims() {
        return this.originalClaims;
    }
}

