/*
 * Decompiled with CFR 0.152.
 */
package com.pla.pladailyboss.entity;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.pla.pladailyboss.config.PlaDailyBossConfig;
import com.pla.pladailyboss.data.BossLootData;
import com.pla.pladailyboss.data.DailyBossLoader;
import com.pla.pladailyboss.enums.KeyEntityState;
import com.pla.pladailyboss.event.RewardEvent;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class KeyEntity
extends Mob {
    private UUID summonedMobId;
    private String summonedMobRL;
    private KeyEntityState state;
    private long updatedStateTime;
    private boolean multiPhaseBoss = false;
    private final long rechargeCooldown = (Long)PlaDailyBossConfig.COOL_DOWN.get();
    private static final Random RANDOM = new Random();
    private static final Logger LOGGER = LogManager.getLogger();
    private List<String> phaseChain = Collections.emptyList();
    private int phaseIndex = -1;
    private static final String NBT_PHASE_CHAIN = "PhaseChain";
    private static final String NBT_PHASE_INDEX = "PhaseIndex";
    private static final EntityDataAccessor<Integer> DATA_STATE = SynchedEntityData.m_135353_(KeyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Long> UPDATED_STATE_TIME = SynchedEntityData.m_135353_(KeyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_244073_);
    private static final EntityDataAccessor<Long> RECHARGE_COOLDOWN = SynchedEntityData.m_135353_(KeyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_244073_);

    public void setSummonedMobId(UUID summonedMobId) {
        this.summonedMobId = summonedMobId;
    }

    public void setSummonedMobRL(String summonedMobRL) {
        this.summonedMobRL = summonedMobRL;
    }

    public String getSummonedMobRL() {
        return this.summonedMobRL;
    }

    public void setPhaseChain(List<String> phaseChain) {
        this.phaseChain = phaseChain;
    }

    public void setPhaseIndex(int phaseIndex) {
        this.phaseIndex = phaseIndex;
    }

    public void setMultiPhaseBoss(boolean multiPhaseBoss) {
        this.multiPhaseBoss = multiPhaseBoss;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_STATE, (Object)KeyEntityState.NORMAL.ordinal());
        this.f_19804_.m_135372_(UPDATED_STATE_TIME, (Object)0L);
        this.f_19804_.m_135372_(RECHARGE_COOLDOWN, (Object)0L);
    }

    public KeyEntity(EntityType<? extends Mob> type, Level level) {
        super(type, level);
        this.f_19794_ = true;
        this.m_20011_(new AABB(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20185_(), this.m_20186_(), this.m_20189_()));
        this.f_19804_.m_135381_(RECHARGE_COOLDOWN, (Object)this.rechargeCooldown);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (this.summonedMobId != null) {
            pCompound.m_128362_("SummonedMobUUID", this.summonedMobId);
        }
        pCompound.m_128359_("SummonedMobRL", this.summonedMobRL);
        pCompound.m_128359_("KeyState", this.state.name());
        pCompound.m_128356_("UpdatedStateTime", this.updatedStateTime);
        pCompound.m_128379_("MultiPhaseBoss", this.multiPhaseBoss);
        if (this.phaseChain != null && !this.phaseChain.isEmpty()) {
            ListTag list = new ListTag();
            for (String id : this.phaseChain) {
                list.add((Object)StringTag.m_129297_((String)id));
            }
            pCompound.m_128365_(NBT_PHASE_CHAIN, (Tag)list);
        }
        pCompound.m_128405_(NBT_PHASE_INDEX, this.phaseIndex);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("SummonedMobUUID")) {
            try {
                this.summonedMobId = pCompound.m_128342_("SummonedMobUUID");
            }
            catch (Exception e) {
                this.summonedMobId = null;
            }
        } else {
            this.summonedMobId = null;
        }
        String string = this.summonedMobRL = pCompound.m_128441_("SummonedMobRL") ? pCompound.m_128461_("SummonedMobRL") : "";
        if (pCompound.m_128441_("KeyState")) {
            try {
                this.state = KeyEntityState.valueOf(pCompound.m_128461_("KeyState"));
            }
            catch (IllegalArgumentException e) {
                this.state = KeyEntityState.NORMAL;
            }
        } else {
            this.state = KeyEntityState.NORMAL;
        }
        this.updatedStateTime = pCompound.m_128441_("UpdatedStateTime") ? pCompound.m_128454_("UpdatedStateTime") : 0L;
        this.multiPhaseBoss = pCompound.m_128441_("MultiPhaseBoss") && pCompound.m_128471_("MultiPhaseBoss");
        this.f_19804_.m_135381_(DATA_STATE, (Object)this.state.ordinal());
        this.f_19804_.m_135381_(UPDATED_STATE_TIME, (Object)this.updatedStateTime);
        if (pCompound.m_128441_(NBT_PHASE_CHAIN)) {
            ListTag list = pCompound.m_128437_(NBT_PHASE_CHAIN, 8);
            ArrayList<String> loaded = new ArrayList<String>(list.size());
            for (int i = 0; i < list.size(); ++i) {
                loaded.add(list.m_128778_(i));
            }
            this.phaseChain = loaded.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(loaded);
        } else {
            this.phaseChain = Collections.emptyList();
        }
        int n = this.phaseIndex = pCompound.m_128441_(NBT_PHASE_INDEX) ? pCompound.m_128451_(NBT_PHASE_INDEX) : -1;
        if (this.phaseIndex < -1) {
            this.phaseIndex = -1;
        }
        if (!this.phaseChain.isEmpty() && this.phaseIndex >= this.phaseChain.size()) {
            this.phaseIndex = this.phaseChain.size() - 1;
        }
        if (this.phaseChain.isEmpty()) {
            if (this.summonedMobRL != null && !this.summonedMobRL.isEmpty()) {
                this.phaseChain = Collections.singletonList(this.summonedMobRL);
                this.phaseIndex = 0;
            } else {
                this.phaseIndex = -1;
            }
        }
        if (this.multiPhaseBoss && (this.phaseChain.isEmpty() || this.phaseIndex < 0)) {
            this.tryRebuildPhaseChainFromData();
        }
    }

    private void tryRebuildPhaseChainFromData() {
        if (this.summonedMobRL == null || this.summonedMobRL.isEmpty()) {
            return;
        }
        for (Map.Entry<String, BossLootData> e : DailyBossLoader.BOSS_LOOT_TABLES.entrySet()) {
            BossLootData d = e.getValue();
            if (d == null || !d.isMultiPhase() || !d.phases.contains(this.summonedMobRL)) continue;
            this.phaseChain = List.copyOf(d.phases);
            this.phaseIndex = d.phases.indexOf(this.summonedMobRL);
            this.multiPhaseBoss = this.phaseIndex < this.phaseChain.size() - 1;
            return;
        }
        this.phaseChain = Collections.singletonList(this.summonedMobRL);
        this.phaseIndex = 0;
        this.multiPhaseBoss = false;
    }

    public void m_8119_() {
        super.m_8119_();
        Player player = this.m_9236_().m_45930_((Entity)this, 10.0);
        if (player != null) {
            this.m_7618_(EntityAnchorArgument.Anchor.EYES, player.m_20182_());
        }
        if (!this.m_9236_().f_46443_) {
            if (this.state == KeyEntityState.DISAPPEARED && !this.m_20145_()) {
                this.m_6842_(true);
                this.m_20225_(true);
                this.f_19794_ = true;
            }
            if (this.state == KeyEntityState.DISABLED) {
                long now = System.currentTimeMillis();
                if (now - this.updatedStateTime >= this.rechargeCooldown) {
                    this.setState(KeyEntityState.NORMAL);
                }
                return;
            }
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123809_, this.m_20185_(), this.m_20186_() + 3.5, this.m_20189_(), 2, 0.2, 0.2, 0.2, 0.0);
            if (this.summonedMobId != null) {
                Entity entity = ((ServerLevel)this.m_9236_()).m_8791_(this.summonedMobId);
                if (entity instanceof Mob) {
                    long now;
                    Mob mob = (Mob)entity;
                    double distance = this.m_20280_((Entity)mob);
                    if (distance > 900.0) {
                        mob.m_6021_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                    }
                    if ((now = System.currentTimeMillis()) - this.updatedStateTime >= this.rechargeCooldown) {
                        mob.m_146870_();
                        this.summonedMobId = null;
                        this.setState(KeyEntityState.NORMAL);
                    }
                } else if (this.multiPhaseBoss && this.phaseChain != null && !this.phaseChain.isEmpty() && this.phaseIndex >= 0 && this.phaseIndex < this.phaseChain.size() - 1) {
                    this.checkMob();
                } else {
                    List<Object> lootTables;
                    String lastId = this.summonedMobRL;
                    this.summonedMobRL = "";
                    this.summonedMobId = null;
                    this.phaseChain = Collections.emptyList();
                    this.phaseIndex = -1;
                    this.multiPhaseBoss = false;
                    this.setState(KeyEntityState.DISABLED);
                    BossLootData data = DailyBossLoader.BOSS_LOOT_TABLES.get(lastId);
                    List<Object> list = lootTables = data != null ? data.lootTables : Collections.emptyList();
                    if (!lootTables.isEmpty()) {
                        for (int i = 0; i < 5; ++i) {
                            String lootTableId = (String)lootTables.get(RANDOM.nextInt(lootTables.size()));
                            RewardEvent.dropLoot((ServerLevel)this.m_9236_(), new ResourceLocation(lootTableId), this.m_20097_(), 1);
                        }
                    } else {
                        LOGGER.warn("[Daily Boss] No loot tables configured for '{}'; skipping loot drop.", (Object)lastId);
                    }
                    int xpAmount = 1395;
                    this.m_9236_().m_7967_((Entity)new ExperienceOrb(this.m_9236_(), (double)this.m_20097_().m_123341_() + 0.5, (double)(this.m_20097_().m_123342_() + 1), (double)this.m_20097_().m_123343_() + 0.5, xpAmount));
                }
            }
        }
    }

    private ResourceLocation preProcessMob(String selectedMobId) {
        BossLootData data = DailyBossLoader.BOSS_LOOT_TABLES.get(selectedMobId);
        if (data != null && data.isMultiPhase()) {
            this.phaseChain = new ArrayList<String>(data.phases);
            this.phaseIndex = 0;
            this.multiPhaseBoss = true;
            return new ResourceLocation(this.phaseChain.get(0));
        }
        this.phaseChain = Collections.singletonList(selectedMobId);
        this.phaseIndex = 0;
        this.multiPhaseBoss = false;
        return new ResourceLocation(selectedMobId);
    }

    private void processMob(String spawnedMobId, Mob mob, ServerPlayer player) {
    }

    private void checkMob() {
        if (this.phaseChain == null || this.phaseChain.isEmpty()) {
            return;
        }
        if (this.phaseIndex < 0 || this.phaseIndex >= this.phaseChain.size() - 1) {
            return;
        }
        String nextPhaseId = this.phaseChain.get(this.phaseIndex + 1);
        double radius = 64.0;
        AABB area = new AABB(this.m_20183_()).m_82400_(radius);
        List nearby = this.m_9236_().m_6249_((Entity)this, area, e -> Objects.equals(ForgeRegistries.ENTITY_TYPES.getKey((Object)e.m_6095_()), new ResourceLocation(nextPhaseId)));
        if (!nearby.isEmpty()) {
            Entity next = (Entity)nearby.get(0);
            this.summonedMobId = next.m_20148_();
            this.summonedMobRL = nextPhaseId;
            ++this.phaseIndex;
            this.multiPhaseBoss = this.phaseIndex < this.phaseChain.size() - 1;
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean spawnBoss(@NotNull Player player) {
        block7: {
            block8: {
                mobIds = DailyBossLoader.getListBasedOnKilledMob((ServerPlayer)player, player.m_20194_());
                if (mobIds.isEmpty()) {
                    player.m_5661_((Component)Component.m_237113_((String)"You're too weak. Come back after you've defeated at least one boss or mini-boss.").m_130938_((UnaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$spawnBoss$1(net.minecraft.network.chat.Style ), (Lnet/minecraft/network/chat/Style;)Lnet/minecraft/network/chat/Style;)()), true);
                    return false;
                }
                selectedMobId = ((String)PlaDailyBossConfig.FORCE_SPAWN.get()).isEmpty() == false ? (String)PlaDailyBossConfig.FORCE_SPAWN.get() : mobIds.get(KeyEntity.RANDOM.nextInt(mobIds.size()));
                mobRL = this.preProcessMob(selectedMobId);
                if (mobRL == null) {
                    return true;
                }
                type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(mobRL);
                usedCustomNBT = false;
                if (type == null || !((var8_7 = type.m_20615_(this.m_9236_())) instanceof Mob)) break block7;
                mob = (Mob)var8_7;
                lootData = DailyBossLoader.BOSS_LOOT_TABLES.get(selectedMobId);
                if (lootData == null || lootData.nbt == null || lootData.nbt.entrySet().isEmpty() || (tag = CompoundTag.f_128325_.parse((DynamicOps)JsonOps.INSTANCE, (Object)lootData.nbt).resultOrPartial((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$spawnBoss$2(java.lang.String java.lang.String ), (Ljava/lang/String;)V)((String)selectedMobId)).orElse(new CompoundTag())).m_128456_()) break block8;
                tag.m_128359_("id", mobRL.toString());
                loaded = EntityType.m_20645_((CompoundTag)tag, (Level)this.m_9236_(), (Function<Entity, Entity>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$spawnBoss$3(net.minecraft.world.entity.Entity ), (Lnet/minecraft/world/entity/Entity;)Lnet/minecraft/world/entity/Entity;)((KeyEntity)this));
                if (!(loaded instanceof Mob)) ** GOTO lbl-1000
                loadedMob = (Mob)loaded;
                var13_12 = this.m_9236_();
                if (var13_12 instanceof ServerLevel) {
                    serverLevel = (ServerLevel)var13_12;
                    loadedMob.m_21530_();
                    loadedMob.m_6710_((LivingEntity)player);
                    loadedMob.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(this.m_20183_()), MobSpawnType.COMMAND, (SpawnGroupData)null, (CompoundTag)null);
                    serverLevel.m_7967_((Entity)loadedMob);
                    this.summonedMobId = loadedMob.m_20148_();
                    this.summonedMobRL = ForgeRegistries.ENTITY_TYPES.getKey((Object)loadedMob.m_6095_()).toString();
                    usedCustomNBT = true;
                    this.processMob(this.summonedMobRL, loadedMob, (ServerPlayer)player);
                } else if (loaded != null) {
                    KeyEntity.LOGGER.warn("[DailyBoss] Loaded entity from NBT is not a mob: {}", (Object)ForgeRegistries.ENTITY_TYPES.getKey((Object)loaded.m_6095_()));
                } else {
                    KeyEntity.LOGGER.warn("[DailyBoss] No entity was created from NBT for mob {}", (Object)selectedMobId);
                }
            }
            if (!usedCustomNBT && (loaded = this.m_9236_()) instanceof ServerLevel) {
                serverLevel = (ServerLevel)loaded;
                mob.m_6027_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                mob.m_21530_();
                mob.m_6710_((LivingEntity)player);
                spawnedId = ForgeRegistries.ENTITY_TYPES.getKey((Object)type).toString();
                this.processMob(spawnedId, mob, (ServerPlayer)player);
                mob.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(this.m_20183_()), MobSpawnType.COMMAND, (SpawnGroupData)null, (CompoundTag)null);
                serverLevel.m_7967_((Entity)mob);
                this.summonedMobId = mob.m_20148_();
                this.summonedMobRL = spawnedId;
            }
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11859_, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.setState(KeyEntityState.DISAPPEARED);
            return true;
        }
        return false;
    }

    @NotNull
    protected InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (!this.m_9236_().f_46443_ && hand == InteractionHand.MAIN_HAND) {
            if (this.state == KeyEntityState.DISABLED) {
                long remaining = this.rechargeCooldown - (System.currentTimeMillis() - this.updatedStateTime);
                long seconds = remaining / 1000L % 60L;
                long minutes = remaining / 60000L % 60L;
                long hours = remaining / 3600000L;
                player.m_5661_((Component)Component.m_237113_((String)("Come back after " + hours + "h " + minutes + "m " + seconds + "s")).m_130938_(style -> style.m_178520_(0xFFFF00)), true);
                return InteractionResult.PASS;
            }
            if (this.state == KeyEntityState.DISAPPEARED) {
                return InteractionResult.PASS;
            }
            if (this.spawnBoss(player)) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return super.m_6071_(player, hand);
    }

    public KeyEntityState getState() {
        if (this.m_9236_().f_46443_) {
            return KeyEntityState.values()[(Integer)this.f_19804_.m_135370_(DATA_STATE)];
        }
        return this.state;
    }

    public Long getUpdatedStateTime() {
        if (this.m_9236_().f_46443_) {
            return (Long)this.f_19804_.m_135370_(UPDATED_STATE_TIME);
        }
        return this.updatedStateTime;
    }

    public Long getRechargeCooldown() {
        if (this.m_9236_().f_46443_) {
            return (Long)this.f_19804_.m_135370_(RECHARGE_COOLDOWN);
        }
        return this.rechargeCooldown;
    }

    public void setState(KeyEntityState newState) {
        this.state = newState;
        this.f_19804_.m_135381_(DATA_STATE, (Object)newState.ordinal());
        if (newState == KeyEntityState.DISAPPEARED) {
            this.m_6842_(true);
            this.m_20225_(true);
            this.f_19794_ = true;
            this.updatedStateTime = System.currentTimeMillis();
            this.f_19804_.m_135381_(UPDATED_STATE_TIME, (Object)this.updatedStateTime);
            this.m_6210_();
        } else {
            this.m_6842_(false);
            this.m_20225_(false);
            this.f_19794_ = false;
            this.m_6210_();
        }
        if (!this.m_9236_().f_46443_) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123810_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 20, 0.3, 0.3, 0.3, 0.01);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.0);
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        return false;
    }

    public boolean m_6673_(@NotNull DamageSource source) {
        return true;
    }

    public void m_147240_(double strength, double x, double z) {
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_21525_() {
        return true;
    }

    protected void m_7324_(@NotNull Entity other) {
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public void m_142687_(@NotNull Entity.RemovalReason reason) {
        if (reason == Entity.RemovalReason.KILLED || reason == Entity.RemovalReason.DISCARDED) {
            return;
        }
        super.m_142687_(reason);
    }

    public void m_6667_(@NotNull DamageSource cause) {
    }

    public boolean m_5829_() {
        return false;
    }

    @NotNull
    public AABB m_6921_() {
        return new AABB(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    public boolean m_142066_() {
        return false;
    }

    public boolean m_6097_() {
        return false;
    }

    public boolean m_6087_() {
        return this.state != KeyEntityState.DISAPPEARED;
    }

    private /* synthetic */ Entity lambda$spawnBoss$3(Entity e) {
        e.m_6027_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        return e;
    }

    private static /* synthetic */ void lambda$spawnBoss$2(String selectedMobId, String msg) {
        LOGGER.warn("[Daily Boss] Failed to parse NBT for mob {}: {}", (Object)selectedMobId, (Object)msg);
    }

    private static /* synthetic */ Style lambda$spawnBoss$1(Style style) {
        return style.m_178520_(0xFFFF00);
    }
}

