/*
 * Decompiled with CFR 0.152.
 */
package com.pla.pladailyboss.compat;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.compat.Compat;
import com.brutalbosses.entity.BossSpawnHandler;
import com.brutalbosses.entity.BossType;
import com.brutalbosses.entity.BossTypeManager;
import com.brutalbosses.entity.capability.BossCapability;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class BrutalBossesCompat
extends BossSpawnHandler {
    private static ConcurrentLinkedQueue<Tuple<BlockPos, BossType>> spawns = new ConcurrentLinkedQueue();

    @Nullable
    public static Mob spawnBossAndReturn(ServerLevelAccessor world, BlockPos pos, BossType bossType) {
        try {
            Mob boss;
            spawns.add((Tuple<BlockPos, BossType>)new Tuple((Object)pos, (Object)bossType));
            if (spawns.size() > 20) {
                spawns.poll();
            }
            if ((boss = bossType.createBossEntity((Level)world.m_6018_())) == null) {
                return null;
            }
            BlockPos spawnPos = BrutalBossesCompat.findSpawnPosForBoss((ServerLevelAccessor)world, (Entity)boss, (BlockPos)pos);
            if (spawnPos == null) {
                boss.m_142687_(Entity.RemovalReason.DISCARDED);
                return null;
            }
            boss.m_6034_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5);
            boss.getCapability(BossCapability.BOSS_CAP).ifPresent(cap -> cap.setSpawnPos(pos));
            Compat.applyAllCompats((ServerLevelAccessor)world, (BossType)bossType, (BlockPos)pos, (Entity)boss);
            if (!boss.m_213877_()) {
                world.m_7967_((Entity)boss);
            }
            return boss;
        }
        catch (Exception e) {
            BrutalBosses.LOGGER.error("Boss: " + String.valueOf(bossType.getID()) + " failed to spawn! Error:", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static Mob spawnRandomBossAndReturn(ServerLevel world, BlockPos pos) {
        ArrayList list = new ArrayList(BossTypeManager.instance.bosses.values());
        BossType bossType = (BossType)list.get(BrutalBosses.rand.nextInt(list.size()));
        return BrutalBossesCompat.spawnBossAndReturn((ServerLevelAccessor)world, pos, bossType);
    }
}

