/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.client;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.FaceIcon;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.NordButton;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.TextBox;
import dev.ftb.mods.ftblibrary.ui.TextField;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.VerticalSpaceWidget;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.NordColors;
import dev.ftb.mods.ftbteams.client.InvitationSetup;
import dev.ftb.mods.ftbteams.client.InvitedButton;
import dev.ftb.mods.ftbteams.data.ClientTeamManager;
import dev.ftb.mods.ftbteams.data.FTBTUtils;
import dev.ftb.mods.ftbteams.data.KnownClientPlayer;
import dev.ftb.mods.ftbteams.data.TeamBase;
import dev.ftb.mods.ftbteams.net.CreatePartyMessage;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;

public class CreatePartyScreen
extends BaseScreen
implements NordColors,
InvitationSetup {
    public final ClientTeamManager manager;
    public Button closeButton;
    public Button colorButton;
    public Panel invitePanel;
    public Panel settingsPanel;
    public Button createTeamButton;
    public Color4I teamColor;
    public TextBox nameTextBox;
    public TextBox descriptionTextBox;
    private Set<GameProfile> invitedMembers;

    public CreatePartyScreen() {
        this.setSize(300, 200);
        this.manager = Objects.requireNonNull(ClientTeamManager.INSTANCE);
        this.teamColor = this.manager.selfTeam.getProperty(TeamBase.COLOR);
        this.invitedMembers = new HashSet<GameProfile>();
    }

    public void addWidgets() {
        this.closeButton = new SimpleButton((Panel)this, (Component)Component.m_237115_((String)"gui.cancel"), Icons.CANCEL.withTint(SNOW_STORM_2), (simpleButton, mouseButton) -> this.closeGui()){

            public void draw(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
                this.drawIcon(matrixStack, theme, x, y, w, h);
            }
        };
        this.add((Widget)this.closeButton);
        this.colorButton = new SimpleButton((Panel)this, (Component)Component.m_237115_((String)"gui.color"), this.teamColor.withBorder(POLAR_NIGHT_0, false), (simpleButton, mouseButton) -> {
            this.teamColor = FTBTUtils.randomColor();
            simpleButton.setIcon(this.teamColor.withBorder(POLAR_NIGHT_0, false));
        }){

            public void draw(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
                this.icon.draw(matrixStack, x, y, w, h);
            }
        };
        this.add((Widget)this.colorButton);
        this.invitePanel = new InvitePanel();
        this.add((Widget)this.invitePanel);
        this.settingsPanel = new SettingsPanel();
        this.add((Widget)this.settingsPanel);
        this.createTeamButton = new NordButton((Panel)this, (Component)Component.m_237115_((String)"ftbteams.create_party").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)NordColors.GREEN.rgb()))), Icons.ACCEPT){

            public boolean renderTitleInCenter() {
                return true;
            }

            public void onClicked(MouseButton mouseButton) {
                this.closeGui(false);
                new CreatePartyMessage(CreatePartyScreen.this.nameTextBox.getText(), CreatePartyScreen.this.descriptionTextBox.getText(), CreatePartyScreen.this.teamColor.rgb(), CreatePartyScreen.this.invitedMembers).sendToServer();
            }
        };
        this.add((Widget)this.createTeamButton);
        this.closeButton.setPosAndSize(this.width - 18, 5, 12, 12);
        this.colorButton.setPosAndSize(5, 5, 12, 12);
        this.invitePanel.setPosAndSize(1, 22, 89, this.height - 23);
    }

    public void drawBackground(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
        GuiHelper.drawHollowRect((PoseStack)matrixStack, (int)x, (int)y, (int)w, (int)h, (Color4I)POLAR_NIGHT_0, (boolean)true);
        POLAR_NIGHT_1.draw(matrixStack, x + 1, y + 1, w - 2, h - 2);
        POLAR_NIGHT_0.draw(matrixStack, x + 1, y + 21, w - 2, 1);
        POLAR_NIGHT_0.draw(matrixStack, x + this.invitePanel.width + 1, y + this.invitePanel.posY, 1, this.invitePanel.height);
    }

    public void drawForeground(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
        super.drawForeground(matrixStack, theme, x, y, w, h);
        theme.drawString(matrixStack, (Object)Component.m_237115_((String)"ftbteams.create_party"), (float)x + (float)w / 2.0f, (float)(y + 7), SNOW_STORM_1, 4);
    }

    public boolean keyPressed(Key key) {
        return super.keyPressed(key);
    }

    @Override
    public boolean isInvited(GameProfile profile) {
        return this.invitedMembers.contains(profile);
    }

    @Override
    public void setInvited(GameProfile profile, boolean invited) {
        if (invited) {
            this.invitedMembers.add(profile);
        } else {
            this.invitedMembers.remove(profile);
        }
    }

    private class InvitePanel
    extends Panel {
        public InvitePanel() {
            super((Panel)CreatePartyScreen.this);
        }

        public void addWidgets() {
            this.add((Widget)new TextField((Panel)this).addFlags(4).setText((Component)Component.m_237115_((String)"ftbteams.gui.add_members")));
            this.add((Widget)new VerticalSpaceWidget((Panel)this, 2));
            User self = Minecraft.m_91087_().m_91094_();
            this.add((Widget)new NordButton(this, (Component)Component.m_237113_((String)"\u2726 ").m_6881_().m_130940_(ChatFormatting.GOLD).m_130946_(self.m_92546_()), (Icon)FaceIcon.getFace((GameProfile)self.m_92548_())){

                public void onClicked(MouseButton mouseButton) {
                }
            });
            for (KnownClientPlayer player : CreatePartyScreen.this.manager.knownPlayers.values().stream().sorted().toList()) {
                if (!player.isOnlineAndNotInParty() || player == CreatePartyScreen.this.manager.selfKnownPlayer) continue;
                this.add((Widget)new InvitedButton(this, CreatePartyScreen.this, player));
            }
        }

        public void alignWidgets() {
            this.align((WidgetLayout)new WidgetLayout.Vertical(4, 2, 1));
            this.width = 80;
            for (Widget widget : this.widgets) {
                this.width = Math.max(this.width, widget.width);
            }
            for (Widget widget : this.widgets) {
                widget.setX(1);
                widget.setWidth(this.width - 2);
            }
            CreatePartyScreen.this.settingsPanel.setPosAndSize(this.width + 3, 23, CreatePartyScreen.this.width - CreatePartyScreen.this.invitePanel.width - 5, CreatePartyScreen.this.height - 40);
            CreatePartyScreen.this.createTeamButton.setPosAndSize(CreatePartyScreen.this.settingsPanel.posX, CreatePartyScreen.this.height - 15, CreatePartyScreen.this.settingsPanel.width, 13);
        }
    }

    private class SettingsPanel
    extends Panel {
        public SettingsPanel() {
            super((Panel)CreatePartyScreen.this);
        }

        public void addWidgets() {
            this.add((Widget)new TextField((Panel)this).setMaxWidth(this.width - 6).setText((Component)Component.m_237115_((String)"ftbteams.gui.party_name")));
            CreatePartyScreen.this.nameTextBox = new TextBox(this){

                public void drawTextBox(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
                    NordColors.POLAR_NIGHT_0.draw(matrixStack, x, y, w, h);
                }
            };
            this.add((Widget)CreatePartyScreen.this.nameTextBox);
            this.add((Widget)new VerticalSpaceWidget((Panel)this, 4));
            this.add((Widget)new TextField((Panel)this).setMaxWidth(this.width - 6).setText((Component)Component.m_237115_((String)"ftbteams.gui.party_description")));
            CreatePartyScreen.this.descriptionTextBox = new TextBox(this){

                public void drawTextBox(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
                    NordColors.POLAR_NIGHT_0.draw(matrixStack, x, y, w, h);
                }
            };
            this.add((Widget)CreatePartyScreen.this.descriptionTextBox);
            this.add((Widget)new VerticalSpaceWidget((Panel)this, 4));
            CreatePartyScreen.this.nameTextBox.setHeight(14);
            CreatePartyScreen.this.nameTextBox.ghostText = Minecraft.m_91087_().m_91094_().m_92546_() + "'s Team";
            CreatePartyScreen.this.descriptionTextBox.setHeight(14);
            CreatePartyScreen.this.descriptionTextBox.ghostText = "<None>";
        }

        public void alignWidgets() {
            for (Widget w : this.widgets) {
                w.setX(3);
                w.setWidth(this.width - 6);
            }
            this.align((WidgetLayout)new WidgetLayout.Vertical(3, 3, 10));
        }

        public void drawBackground(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
            NordColors.POLAR_NIGHT_2.draw(matrixStack, x, y, w, h);
        }
    }
}

