/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.data.ClaimedChunk;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SendChunkPacket
extends BaseS2CMessage {
    public final ResourceKey<Level> dimension;
    public final UUID teamId;
    public final SingleChunk chunk;

    public SendChunkPacket(ResourceKey<Level> dimension, UUID teamId, SingleChunk chunk) {
        this.dimension = dimension;
        this.teamId = teamId;
        this.chunk = chunk;
    }

    public MessageType getType() {
        return FTBChunksNet.SEND_CHUNK;
    }

    SendChunkPacket(FriendlyByteBuf buf) {
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)buf.m_130281_());
        this.teamId = buf.m_130259_();
        this.chunk = new SingleChunk(buf, this.teamId);
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130085_(this.dimension.m_135782_());
        buf.m_130077_(this.teamId);
        this.chunk.write(buf, this.teamId);
    }

    public void handle(NetworkManager.PacketContext context) {
        FTBChunks.PROXY.updateChunk(this);
    }

    public static class SingleChunk {
        public final int x;
        public final int z;
        public final long relativeTimeClaimed;
        public final boolean forceLoaded;
        public final long relativeTimeForceLoaded;
        public final boolean expires;
        public final long relativeForceLoadExpiryTime;

        public SingleChunk(long now, int x, int z, @Nullable ClaimedChunk claimedChunk) {
            this.x = x;
            this.z = z;
            if (claimedChunk != null) {
                this.relativeTimeClaimed = now - claimedChunk.getTimeClaimed();
                this.forceLoaded = claimedChunk.isForceLoaded();
                this.expires = claimedChunk.getForceLoadExpiryTime() > 0L;
                this.relativeTimeForceLoaded = this.forceLoaded ? now - claimedChunk.getForceLoadedTime() : 0L;
                this.relativeForceLoadExpiryTime = this.expires ? claimedChunk.getForceLoadExpiryTime() - now : 0L;
            } else {
                this.relativeForceLoadExpiryTime = 0L;
                this.relativeTimeForceLoaded = 0L;
                this.relativeTimeClaimed = 0L;
                this.expires = false;
                this.forceLoaded = false;
            }
        }

        public SingleChunk(FriendlyByteBuf buf, UUID teamId) {
            this.x = buf.m_130242_();
            this.z = buf.m_130242_();
            if (!teamId.equals(Util.f_137441_)) {
                this.relativeTimeClaimed = buf.m_130258_();
                this.forceLoaded = buf.readBoolean();
                this.expires = buf.readBoolean();
                this.relativeTimeForceLoaded = this.forceLoaded ? buf.m_130258_() : 0L;
                this.relativeForceLoadExpiryTime = this.expires ? buf.m_130258_() : 0L;
            } else {
                this.relativeForceLoadExpiryTime = 0L;
                this.relativeTimeForceLoaded = 0L;
                this.relativeTimeClaimed = 0L;
                this.expires = false;
                this.forceLoaded = false;
            }
        }

        public void write(FriendlyByteBuf buf, UUID teamId) {
            buf.m_130130_(this.x);
            buf.m_130130_(this.z);
            if (!teamId.equals(Util.f_137441_)) {
                buf.m_130103_(this.relativeTimeClaimed);
                buf.writeBoolean(this.forceLoaded);
                buf.writeBoolean(this.expires);
                if (this.forceLoaded) {
                    buf.m_130103_(this.relativeTimeForceLoaded);
                }
                if (this.expires) {
                    buf.m_130103_(this.relativeForceLoadExpiryTime);
                }
            }
        }
    }
}

