/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import dev.ftb.mods.ftbchunks.net.SendChunkPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class SendManyChunksPacket
extends BaseS2CMessage {
    public final ResourceKey<Level> dimension;
    public final UUID teamId;
    public final List<SendChunkPacket.SingleChunk> chunks;

    public SendManyChunksPacket(ResourceKey<Level> dimension, UUID teamId, List<SendChunkPacket.SingleChunk> chunks) {
        this.dimension = dimension;
        this.teamId = teamId;
        this.chunks = chunks;
    }

    public MessageType getType() {
        return FTBChunksNet.SEND_ALL_CHUNKS;
    }

    SendManyChunksPacket(FriendlyByteBuf buf) {
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)buf.m_130281_());
        this.teamId = buf.m_130259_();
        int s = buf.m_130242_();
        this.chunks = new ArrayList<SendChunkPacket.SingleChunk>(s);
        for (int i = 0; i < s; ++i) {
            this.chunks.add(new SendChunkPacket.SingleChunk(buf, this.teamId));
        }
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130085_(this.dimension.m_135782_());
        buf.m_130077_(this.teamId);
        buf.m_130130_(this.chunks.size());
        for (SendChunkPacket.SingleChunk chunk : this.chunks) {
            chunk.write(buf, this.teamId);
        }
    }

    public void handle(NetworkManager.PacketContext context) {
        FTBChunks.PROXY.updateAllChunks(this);
    }
}

