/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.net;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbteams.FTBTeams;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.KnownClientPlayer;
import dev.ftb.mods.ftbteams.data.PartyTeam;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamRank;
import dev.ftb.mods.ftbteams.net.FTBTeamsNet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class PlayerGUIOperationMessage
extends BaseC2SMessage {
    private final Operation op;
    private final List<UUID> targets;

    public PlayerGUIOperationMessage(Operation op, UUID target) {
        this.op = op;
        this.targets = List.of(target);
    }

    public PlayerGUIOperationMessage(Operation op, Collection<GameProfile> targets) {
        this.op = op;
        this.targets = targets.stream().map(GameProfile::getId).toList();
    }

    public PlayerGUIOperationMessage(FriendlyByteBuf buf) {
        this.op = (Operation)buf.m_130066_(Operation.class);
        this.targets = new ArrayList<UUID>();
        int n = buf.m_130242_();
        for (int i = 0; i < n; ++i) {
            this.targets.add(buf.m_130259_());
        }
    }

    public MessageType getType() {
        return FTBTeamsNet.PLAYER_GUI_OPERATION;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.op);
        buf.m_130130_(this.targets.size());
        this.targets.forEach(arg_0 -> ((FriendlyByteBuf)buf).m_130077_(arg_0));
    }

    public void handle(NetworkManager.PacketContext context) {
        Player player = context.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        UUID senderId = context.getPlayer().m_142081_();
        Team team = FTBTeamsAPI.getManager().getPlayerTeam(senderId);
        if (team instanceof PartyTeam) {
            PartyTeam partyTeam = (PartyTeam)team;
            TeamRank senderRank = partyTeam.getHighestRank(serverPlayer.m_142081_());
            this.targets.forEach(target -> this.processTarget(serverPlayer, senderRank, partyTeam, (UUID)target));
        }
    }

    private void processTarget(ServerPlayer sourcePlayer, TeamRank senderRank, PartyTeam partyTeam, UUID targetId) {
        if (this.op.requireSameTeam() && !FTBTeamsAPI.arePlayersInSameTeam(sourcePlayer.m_142081_(), targetId)) {
            return;
        }
        TeamRank targetRank = partyTeam.getHighestRank(targetId);
        FTBTeams.LOGGER.debug("received teams operation msg {} from {} (rank {}), team {}, target {} (rank {})", (Object)this.op, (Object)sourcePlayer.m_142081_(), (Object)senderRank, (Object)partyTeam.getName().getString(), (Object)targetId, (Object)targetRank);
        try {
            List<GameProfile> targetProfile = List.of(new GameProfile(targetId, null));
            switch (this.op) {
                case KICK: {
                    if (senderRank.getPower() <= targetRank.getPower()) break;
                    partyTeam.kick(sourcePlayer, targetProfile);
                    break;
                }
                case PROMOTE: {
                    if (!senderRank.is(TeamRank.OWNER) || !targetRank.is(TeamRank.MEMBER)) break;
                    partyTeam.promote(sourcePlayer, targetProfile);
                    break;
                }
                case DEMOTE: {
                    if (!senderRank.is(TeamRank.OWNER) || !targetRank.is(TeamRank.OFFICER)) break;
                    partyTeam.demote(sourcePlayer, targetProfile);
                    break;
                }
                case TRANSFER_OWNER: {
                    if (!senderRank.is(TeamRank.OWNER)) break;
                    ServerPlayer p = partyTeam.manager.server.m_6846_().m_11259_(targetId);
                    if (p != null) {
                        partyTeam.transferOwnership(sourcePlayer, p);
                    }
                    break;
                }
                case LEAVE: {
                    partyTeam.leave(sourcePlayer);
                    break;
                }
                case INVITE: {
                    if (!senderRank.is(TeamRank.OFFICER)) break;
                    ServerPlayer p = partyTeam.manager.server.m_6846_().m_11259_(targetId);
                    if (p != null) {
                        partyTeam.invite(sourcePlayer, List.of(p.m_36316_()));
                    }
                    break;
                }
                case ADD_ALLY: {
                    if (!senderRank.is(TeamRank.OFFICER) || !targetRank.is(TeamRank.NONE)) break;
                    partyTeam.addAlly(sourcePlayer.m_20203_(), targetProfile);
                    break;
                }
                case REMOVE_ALLY: {
                    if (!senderRank.is(TeamRank.OFFICER) || !targetRank.is(TeamRank.ALLY)) break;
                    partyTeam.removeAlly(sourcePlayer.m_20203_(), targetProfile);
                }
            }
        }
        catch (CommandSyntaxException e) {
            sourcePlayer.m_5661_((Component)new TextComponent(e.getMessage()).m_130940_(ChatFormatting.RED), false);
        }
    }

    public static enum Operation {
        PROMOTE(true),
        DEMOTE(true),
        LEAVE(true),
        KICK(true),
        TRANSFER_OWNER(true),
        INVITE(false),
        ADD_ALLY(false),
        REMOVE_ALLY(false);

        private final boolean requireSameTeam;

        private Operation(boolean requireSameTeam) {
            this.requireSameTeam = requireSameTeam;
        }

        boolean requireSameTeam() {
            return this.requireSameTeam;
        }

        public void sendMessage(KnownClientPlayer target) {
            new PlayerGUIOperationMessage(this, target.uuid).sendToServer();
        }
    }
}

