/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.client.handler;

import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.Action;
import com.mrcrayfish.controllable.client.gui.navigation.BasicNavigationPoint;
import com.mrcrayfish.controllable.client.input.Controller;
import com.mrcrayfish.controllable.event.ControllerEvents;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.network.message.IMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import ttv.migami.jeg.Config;
import ttv.migami.jeg.client.GunButtonBindings;
import ttv.migami.jeg.client.handler.AimingHandler;
import ttv.migami.jeg.client.handler.ReloadHandler;
import ttv.migami.jeg.client.handler.ShootingHandler;
import ttv.migami.jeg.client.screen.GunmetalWorkbenchScreen;
import ttv.migami.jeg.client.screen.GunniteWorkbenchScreen;
import ttv.migami.jeg.client.screen.ScrapWorkbenchScreen;
import ttv.migami.jeg.common.FireMode;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.init.ModSyncedDataKeys;
import ttv.migami.jeg.item.GunItem;
import ttv.migami.jeg.item.attachment.impl.Scope;
import ttv.migami.jeg.network.PacketHandler;
import ttv.migami.jeg.network.message.C2SMessageAttachments;
import ttv.migami.jeg.network.message.C2SMessageMelee;
import ttv.migami.jeg.network.message.C2SMessageUnload;
import ttv.migami.jeg.util.GunModifierHelper;

public class ControllerHandler {
    private static int reloadCounter = -1;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new ControllerHandler());
        ControllerEvents.INPUT.register((IFrameworkEvent)((ControllerEvents.Input)(controller, newButton, originalButton, state) -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            boolean shouldCancel = false;
            if (player != null && world != null && Minecraft.m_91087_().f_91080_ == null) {
                ItemStack heldItem = player.m_21205_();
                if (originalButton == GunButtonBindings.SHOOT.getButton()) {
                    if (heldItem.m_41720_() instanceof GunItem) {
                        shouldCancel = true;
                        if (state) {
                            ShootingHandler.get().fire((Player)player, heldItem);
                        }
                    }
                } else if (originalButton == GunButtonBindings.AIM.getButton()) {
                    if (heldItem.m_41720_() instanceof GunItem) {
                        shouldCancel = true;
                    }
                } else if (originalButton == GunButtonBindings.STEADY_AIM.getButton()) {
                    if (heldItem.m_41720_() instanceof GunItem) {
                        shouldCancel = true;
                        if (state && !ControllerHandler.isAiming()) {
                            PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageMelee());
                        }
                    }
                } else if (originalButton == GunButtonBindings.RELOAD.getButton()) {
                    if (heldItem.m_41720_() instanceof GunItem) {
                        shouldCancel = true;
                        if (state) {
                            reloadCounter = 0;
                        }
                    }
                } else if (originalButton == GunButtonBindings.OPEN_ATTACHMENTS.getButton() && heldItem.m_41720_() instanceof GunItem && Minecraft.m_91087_().f_91080_ == null) {
                    shouldCancel = true;
                    if (state) {
                        PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageAttachments());
                    }
                }
            }
            return shouldCancel;
        }));
        ControllerEvents.UPDATE_CAMERA.register((IFrameworkEvent)((ControllerEvents.UpdateCamera)(yawSpeed, pitchSpeed) -> {
            ItemStack heldItem;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null && (heldItem = player.m_21205_()).m_41720_() instanceof GunItem && AimingHandler.get().isAiming()) {
                double adsSensitivity = (Double)Config.CLIENT.controls.aimDownSightSensitivity.get();
                yawSpeed.set((Object)Float.valueOf(10.0f * (float)adsSensitivity));
                pitchSpeed.set((Object)Float.valueOf(7.5f * (float)adsSensitivity));
                Scope scope = Gun.getScope(heldItem);
                Controller controller = Controllable.getController();
                if (scope != null && controller != null && controller.isButtonPressed(GunButtonBindings.STEADY_AIM.getButton())) {
                    yawSpeed.set((Object)Float.valueOf(((Float)yawSpeed.get()).floatValue() / 2.0f));
                    pitchSpeed.set((Object)Float.valueOf(((Float)pitchSpeed.get()).floatValue() / 2.0f));
                }
            }
            return false;
        }));
        ControllerEvents.GATHER_ACTIONS.register((IFrameworkEvent)((ControllerEvents.GatherActions)(actions, visibility) -> {
            ItemStack heldItem;
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91080_ != null) {
                return;
            }
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null && (heldItem = player.m_21205_()).m_41720_() instanceof GunItem) {
                Scope scope;
                actions.put(GunButtonBindings.AIM, new Action((Component)Component.m_237115_((String)"jeg.action.aim"), Action.Side.RIGHT));
                actions.put(GunButtonBindings.SHOOT, new Action((Component)Component.m_237115_((String)"jeg.action.shoot"), Action.Side.RIGHT));
                GunItem gunItem = (GunItem)heldItem.m_41720_();
                Gun modifiedGun = gunItem.getModifiedGun(heldItem);
                CompoundTag tag = heldItem.m_41783_();
                if (tag != null && tag.m_128451_("AmmoCount") < GunModifierHelper.getModifiedAmmoCapacity(heldItem, modifiedGun)) {
                    actions.put(GunButtonBindings.RELOAD, new Action((Component)Component.m_237115_((String)"jeg.action.reload"), Action.Side.LEFT));
                }
                if ((scope = Gun.getScope(heldItem)) != null && AimingHandler.get().isAiming()) {
                    actions.put(GunButtonBindings.STEADY_AIM, new Action((Component)Component.m_237115_((String)"jeg.action.steady_aim"), Action.Side.RIGHT));
                }
            }
        }));
        ControllerEvents.GATHER_NAVIGATION_POINTS.register((IFrameworkEvent)((ControllerEvents.GatherNavigationPoints)points -> {
            int itemY;
            int itemX;
            int tabY;
            int tabX;
            int i;
            int startY;
            int startX;
            AbstractContainerScreen workbench;
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91080_ instanceof ScrapWorkbenchScreen) {
                workbench = (ScrapWorkbenchScreen)mc.f_91080_;
                startX = workbench.getGuiLeft();
                startY = workbench.getGuiTop();
                for (i = 0; i < workbench.getTabs().size(); ++i) {
                    tabX = startX + 28 * i + 14;
                    tabY = startY - 14;
                    points.add(new BasicNavigationPoint((double)tabX, (double)tabY));
                }
                for (i = 0; i < 6; ++i) {
                    itemX = startX + 172 + 40;
                    itemY = startY + i * 19 + 63 + 9;
                    points.add(new BasicNavigationPoint((double)itemX, (double)itemY));
                }
            }
            if (mc.f_91080_ instanceof GunmetalWorkbenchScreen) {
                workbench = (GunmetalWorkbenchScreen)mc.f_91080_;
                startX = workbench.getGuiLeft();
                startY = workbench.getGuiTop();
                for (i = 0; i < workbench.getTabs().size(); ++i) {
                    tabX = startX + 28 * i + 14;
                    tabY = startY - 14;
                    points.add(new BasicNavigationPoint((double)tabX, (double)tabY));
                }
                for (i = 0; i < 6; ++i) {
                    itemX = startX + 172 + 40;
                    itemY = startY + i * 19 + 63 + 9;
                    points.add(new BasicNavigationPoint((double)itemX, (double)itemY));
                }
            }
            if (mc.f_91080_ instanceof GunniteWorkbenchScreen) {
                workbench = (GunniteWorkbenchScreen)mc.f_91080_;
                startX = workbench.getGuiLeft();
                startY = workbench.getGuiTop();
                for (i = 0; i < workbench.getTabs().size(); ++i) {
                    tabX = startX + 28 * i + 14;
                    tabY = startY - 14;
                    points.add(new BasicNavigationPoint((double)tabX, (double)tabY));
                }
                for (i = 0; i < 6; ++i) {
                    itemX = startX + 172 + 40;
                    itemY = startY + i * 19 + 63 + 9;
                    points.add(new BasicNavigationPoint((double)itemX, (double)itemY));
                }
            }
        }));
    }

    @SubscribeEvent
    public void onRender(TickEvent.RenderTickEvent event) {
        Gun gun;
        ItemStack heldItem;
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        if (controller.isButtonPressed(GunButtonBindings.SHOOT.getButton()) && Minecraft.m_91087_().f_91080_ == null && (heldItem = player.m_21205_()).m_41720_() instanceof GunItem && (gun = ((GunItem)heldItem.m_41720_()).getModifiedGun(heldItem)).getGeneral().getFireMode() == FireMode.AUTOMATIC) {
            ShootingHandler.get().fire((Player)player, heldItem);
        }
        if (mc.f_91080_ == null && reloadCounter != -1 && controller.isButtonPressed(GunButtonBindings.RELOAD.getButton())) {
            ++reloadCounter;
        }
        if (reloadCounter > 40) {
            ReloadHandler.get().setReloading(false);
            PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageUnload());
            reloadCounter = -1;
        } else if (reloadCounter > 0 && !controller.isButtonPressed(GunButtonBindings.RELOAD.getButton())) {
            ReloadHandler.get().setReloading((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player) == false);
            reloadCounter = -1;
        }
    }

    public static boolean isAiming() {
        Controller controller = Controllable.getController();
        return controller != null && controller.isButtonPressed(GunButtonBindings.AIM.getButton());
    }

    public static boolean isShooting() {
        Controller controller = Controllable.getController();
        return controller != null && controller.isButtonPressed(GunButtonBindings.SHOOT.getButton());
    }
}

