/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.client.handler;

import java.lang.reflect.Field;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import ttv.migami.jeg.Config;
import ttv.migami.jeg.client.audio.StunRingingSound;
import ttv.migami.jeg.entity.monster.phantom.gunner.PhantomGunner;
import ttv.migami.jeg.entity.monster.phantom.gunner.PhantomGunnerDiveSoundInstance;
import ttv.migami.jeg.entity.monster.phantom.gunner.PhantomGunnerFlySoundInstance;
import ttv.migami.jeg.entity.monster.phantom.terror.TerrorPhantom;
import ttv.migami.jeg.entity.monster.phantom.terror.TerrorPhantomBoostSoundInstance;
import ttv.migami.jeg.entity.monster.phantom.terror.TerrorPhantomDiveSoundInstance;
import ttv.migami.jeg.entity.monster.phantom.terror.TerrorPhantomFlySoundInstance;
import ttv.migami.jeg.init.ModEffects;

public class SoundHandler {
    private static SoundHandler instance;
    private final Map<SoundInstance, Float> soundVolumes = new ConcurrentHashMap<SoundInstance, Float>();
    private boolean isDeafened;
    private Field playingSounds;
    private SoundEngine soundEngine;
    private StunRingingSound ringing;

    public static SoundHandler get() {
        if (instance == null) {
            instance = new SoundHandler();
        }
        return instance;
    }

    private SoundHandler() {
        this.initReflection();
    }

    private void initReflection() {
        this.playingSounds = ObfuscationReflectionHelper.findField(SoundEngine.class, (String)"f_120226_");
    }

    @SubscribeEvent
    public void deafenPlayer(TickEvent.ClientTickEvent event) {
        Map playingSounds;
        if (event.phase == TickEvent.Phase.START || Minecraft.m_91087_().f_91074_ == null || this.soundEngine == null) {
            return;
        }
        MobEffectInstance effect = Minecraft.m_91087_().f_91074_.m_21124_((MobEffect)ModEffects.DEAFENED.get());
        if (effect == null && !this.isDeafened) {
            return;
        }
        if ((Double)Config.SERVER.ringVolume.get() > 0.0 && (this.ringing == null || !Minecraft.m_91087_().m_91106_().m_120403_((SoundInstance)this.ringing))) {
            this.ringing = new StunRingingSound();
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)this.ringing);
            return;
        }
        try {
            playingSounds = (Map)this.playingSounds.get(this.soundEngine);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            return;
        }
        if (effect != null) {
            try {
                playingSounds.forEach((sound, entry) -> {
                    if (sound == null || sound instanceof TickableSoundInstance || this.isStunGrenade(sound.m_5891_().m_119787_())) {
                        return;
                    }
                    float volume = sound instanceof SoundMuted ? ((SoundMuted)sound).getVolumeInitial() : sound.m_7769_();
                    this.soundVolumes.put((SoundInstance)sound, Float.valueOf(volume));
                    entry.m_120154_(soundSource -> soundSource.m_83666_(this.getMutedVolume(effect.m_19557_(), volume)));
                });
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
            this.isDeafened = true;
        } else if (this.isDeafened) {
            this.isDeafened = false;
            for (Map.Entry<SoundInstance, Float> entry2 : this.soundVolumes.entrySet()) {
                ChannelAccess.ChannelHandle entry1 = (ChannelAccess.ChannelHandle)playingSounds.get(entry2.getKey());
                if (entry1 == null) continue;
                entry1.m_120154_(soundSource -> soundSource.m_83666_(((Float)entry2.getValue()).floatValue()));
            }
            this.soundVolumes.clear();
        }
    }

    @SubscribeEvent
    public void lowerInitialVolume(PlaySoundEvent event) {
        if (this.soundEngine == null) {
            this.soundEngine = event.getEngine();
        }
        if (!this.isDeafened || Minecraft.m_91087_().f_91074_ == null || event.getSound() instanceof TickableSoundInstance) {
            return;
        }
        ResourceLocation loc = event.getSound().m_7904_();
        MobEffectInstance effect = Minecraft.m_91087_().f_91074_.m_21124_((MobEffect)ModEffects.DEAFENED.get());
        int duration = effect != null ? effect.m_19557_() : 0;
        boolean isStunGrenade = this.isStunGrenade(loc);
        if (duration == 0 && isStunGrenade) {
            return;
        }
        event.getSound().m_6775_(Minecraft.m_91087_().m_91106_());
        event.setSound((SoundInstance)new SoundMuted(event.getSound(), duration, isStunGrenade));
    }

    private boolean isStunGrenade(ResourceLocation loc) {
        return loc.toString().equals("jeg:grenade_stun_explosion");
    }

    private float getMutedVolume(float duration, float volumeBase) {
        float volumeMin = (float)((double)volumeBase * (Double)Config.SERVER.soundPercentage.get());
        float percent = Math.min(duration / (float)((Integer)Config.SERVER.soundFadeThreshold.get()).intValue(), 1.0f);
        return volumeMin + (1.0f - percent) * (volumeBase - volumeMin);
    }

    private static void playTerrorPhantomSound(AbstractTickableSoundInstance soundInstance) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)soundInstance);
    }

    public static void playTerrorPhantomFlySound(TerrorPhantom entity) {
        SoundHandler.playTerrorPhantomSound(new TerrorPhantomFlySoundInstance(entity, SoundSource.PLAYERS));
    }

    public static void playTerrorPhantomBoostSound(TerrorPhantom entity) {
        SoundHandler.playTerrorPhantomSound(new TerrorPhantomBoostSoundInstance(entity, SoundSource.PLAYERS));
    }

    public static void playTerrorPhantomDiveSound(TerrorPhantom entity) {
        SoundHandler.playTerrorPhantomSound(new TerrorPhantomDiveSoundInstance(entity, SoundSource.PLAYERS));
    }

    private static void playPhantomGunnerSound(AbstractTickableSoundInstance soundInstance) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)soundInstance);
    }

    public static void playPhantomGunnerFlySound(PhantomGunner entity) {
        SoundHandler.playPhantomGunnerSound(new PhantomGunnerFlySoundInstance(entity, SoundSource.PLAYERS));
    }

    public static void playPhantomGunnerDiveSound(PhantomGunner entity) {
        SoundHandler.playPhantomGunnerSound(new PhantomGunnerDiveSoundInstance(entity, SoundSource.PLAYERS));
    }

    public static class SoundMuted
    implements SoundInstance {
        private final SoundInstance parent;
        private final float volume;
        private float volumeInitial;

        public SoundMuted(SoundInstance parent, int duration, boolean isStunGrenade) {
            this.parent = parent;
            this.volumeInitial = Mth.m_14036_((float)parent.m_7769_(), (float)0.0f, (float)1.0f);
            this.volume = SoundHandler.get().getMutedVolume(duration, this.volumeInitial);
            if (isStunGrenade) {
                this.volumeInitial = this.volume;
            }
        }

        public float m_7769_() {
            return this.volume;
        }

        public float getVolumeInitial() {
            return this.volumeInitial;
        }

        public ResourceLocation m_7904_() {
            return this.parent.m_7904_();
        }

        @Nullable
        public WeighedSoundEvents m_6775_(SoundManager handler) {
            return this.parent.m_6775_(handler);
        }

        public Sound m_5891_() {
            return this.parent.m_5891_();
        }

        public SoundSource m_8070_() {
            return this.parent.m_8070_();
        }

        public boolean m_7775_() {
            return this.parent.m_7775_();
        }

        public boolean m_7796_() {
            return false;
        }

        public int m_7766_() {
            return this.parent.m_7766_();
        }

        public float m_7783_() {
            return this.parent.m_7783_();
        }

        public double m_7772_() {
            return this.parent.m_7772_();
        }

        public double m_7780_() {
            return this.parent.m_7780_();
        }

        public double m_7778_() {
            return this.parent.m_7778_();
        }

        public SoundInstance.Attenuation m_7438_() {
            return this.parent.m_7438_();
        }
    }
}

