/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FlareSmokeParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private final boolean isThrowable;

    protected FlareSmokeParticle(ClientLevel level, double xCoord, double yCoord, double zCoord, SpriteSet spriteSet, double xd, double yd, double zd, boolean isFlare) {
        super(level, xCoord, yCoord, zCoord, xd, yd, zd);
        this.f_172258_ = 0.8f;
        this.f_107215_ = xd;
        this.f_107216_ = yd;
        this.f_107217_ = zd;
        this.f_107663_ *= 21.0f;
        this.sprites = spriteSet;
        this.isThrowable = isFlare;
        this.m_108339_(spriteSet);
        this.f_107225_ = this.isThrowable ? 400 + this.f_107223_.m_188503_(401) : 1500 + this.f_107223_.m_188503_(1500);
        this.f_107227_ = 1.0f;
        this.f_107228_ = 1.0f;
        this.f_107229_ = 1.0f;
    }

    public void m_5989_() {
        float normalizedAge;
        super.m_5989_();
        this.updateAlpha();
        this.f_107216_ = this.isThrowable ? ((normalizedAge = (float)this.f_107224_ / (float)this.f_107225_) < 0.7f ? (this.f_107216_ += 0.05) : (this.f_107216_ += (double)0.03f)) : (this.f_107216_ += (double)0.002f);
        this.f_107215_ += 0.003;
        this.f_107217_ += 0.003;
        normalizedAge = (float)this.f_107224_ / (float)this.f_107225_;
        if (normalizedAge > 0.2f) {
            this.f_107215_ += (double)((this.f_107223_.m_188501_() - 0.5f) * 0.01f);
            this.f_107217_ += (double)((this.f_107223_.m_188501_() - 0.5f) * 0.01f);
            this.f_107216_ += (double)(this.f_107223_.m_188501_() * 0.005f);
        }
        this.f_107215_ *= (double)0.98f;
        this.f_107217_ *= (double)0.98f;
        this.f_107216_ *= (double)0.98f;
    }

    private void applyWindEffect() {
        if (this.f_107224_ > 10) {
            this.f_107215_ += (this.f_107223_.m_188500_() - 0.5) * 0.01;
            this.f_107217_ += (this.f_107223_.m_188500_() - 0.5) * 0.01;
        }
    }

    private void updateAlpha() {
        float normalizedAge = (float)this.f_107224_ / (float)this.f_107225_;
        this.f_107230_ = normalizedAge < 0.2f ? 5.0f : 1.0f - (normalizedAge - 0.2f) / 0.8f;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public int m_6355_(float pPartialTick) {
        int lightValue;
        float normalizedAge = ((float)this.f_107224_ + pPartialTick) / (float)this.f_107225_;
        normalizedAge = Mth.m_14036_((float)normalizedAge, (float)0.0f, (float)1.0f);
        int maxLight = 240;
        int minLight = 10;
        int finalLight = 200;
        int transitionTicks1 = 30;
        int transitionTicks2 = 10;
        if (this.isThrowable) {
            transitionTicks2 = 60;
        }
        if (this.f_107224_ < transitionTicks1) {
            transitionFactor = (float)this.f_107224_ / (float)transitionTicks1;
            lightValue = (int)((float)maxLight - transitionFactor * (float)(maxLight - minLight));
        } else if (this.f_107224_ >= 80 && this.f_107224_ < 80 + transitionTicks2) {
            transitionFactor = (float)(this.f_107224_ - 80) / (float)transitionTicks2;
            lightValue = (int)((float)minLight + transitionFactor * (float)(finalLight - minLight));
        } else {
            lightValue = this.f_107224_ >= 80 + transitionTicks2 ? finalLight : minLight;
        }
        if (lightValue < minLight) {
            lightValue = minLight;
        }
        int packedLight = super.m_6355_(pPartialTick);
        int blockLight = packedLight & 0xFF;
        int skyLight = packedLight >> 16 & 0xFF;
        return lightValue | skyLight << 16;
    }

    public float m_5902_(float scaleFactor) {
        float normalizedAge = ((float)this.f_107224_ + scaleFactor) / (float)this.f_107225_;
        if (normalizedAge < 0.2f) {
            return this.f_107663_ * (0.5f + normalizedAge * 5.0f);
        }
        float slowGrowth = 1.5f + (normalizedAge - 0.2f) * 0.8f;
        return this.f_107663_ * slowGrowth;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class SmokeProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public SmokeProvider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(SimpleParticleType particleType, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            FlareSmokeParticle flareSmokeParticle = new FlareSmokeParticle(level, x, y, z, this.sprites, dx, dy, dz, false);
            flareSmokeParticle.m_108335_(this.sprites);
            flareSmokeParticle.m_107253_(1.0f, 0.2f, 0.2f);
            return flareSmokeParticle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class BlueProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public BlueProvider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(SimpleParticleType particleType, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            FlareSmokeParticle flareSmokeParticle = new FlareSmokeParticle(level, x, y, z, this.sprites, dx, dy, dz, true);
            flareSmokeParticle.m_108335_(this.sprites);
            flareSmokeParticle.m_107253_(0.0f, 0.6f, 0.8f);
            return flareSmokeParticle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class RedProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public RedProvider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(SimpleParticleType particleType, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            FlareSmokeParticle flareSmokeParticle = new FlareSmokeParticle(level, x, y, z, this.sprites, dx, dy, dz, true);
            flareSmokeParticle.m_108335_(this.sprites);
            flareSmokeParticle.m_107253_(1.0f, 0.2f, 0.2f);
            return flareSmokeParticle;
        }
    }
}

