/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mrcrayfish.framework.api.data.login.ILoginData;
import com.mrcrayfish.framework.network.message.IMessage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.Validate;
import ttv.migami.jeg.JustEnoughGuns;
import ttv.migami.jeg.annotation.Validator;
import ttv.migami.jeg.client.util.Easings;
import ttv.migami.jeg.common.FireMode;
import ttv.migami.jeg.common.GripType;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.common.JsonDeserializers;
import ttv.migami.jeg.common.ReloadType;
import ttv.migami.jeg.init.ModItems;
import ttv.migami.jeg.item.GunItem;
import ttv.migami.jeg.network.PacketHandler;
import ttv.migami.jeg.network.message.S2CMessageUpdateGuns;

@Mod.EventBusSubscriber(modid="jeg")
public class NetworkGunManager
extends SimplePreparableReloadListener<Map<ResourceLocation, Gun>> {
    public static final Path CONFIG_PACK_DIR = FMLPaths.CONFIGDIR.get().resolve("jeg");
    public static final Path CONFIG_GUN_DIR = FMLPaths.CONFIGDIR.get().resolve("jeg").resolve("data").resolve("guns");
    public static final String CONFIG_NAMESPACE = "jeg_cfg";
    private static final int FILE_TYPE_LENGTH_VALUE = ".json".length();
    private static final Gson GSON_INSTANCE = (Gson)Util.m_137537_(() -> {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(ResourceLocation.class, JsonDeserializers.RESOURCE_LOCATION);
        builder.registerTypeAdapter(FireMode.class, JsonDeserializers.FIRE_MODE);
        builder.registerTypeAdapter(ReloadType.class, JsonDeserializers.RELOAD_TYPE);
        builder.registerTypeAdapter(GripType.class, JsonDeserializers.GRIP_TYPE);
        builder.registerTypeAdapter(Easings.class, JsonDeserializers.EASING);
        builder.excludeFieldsWithModifiers(new int[]{128});
        return builder.create();
    });
    private static final List<GunItem> clientRegisteredGuns = new ArrayList<GunItem>();
    private static NetworkGunManager instance;
    private Map<ResourceLocation, Gun> registeredGuns = new HashMap<ResourceLocation, Gun>();
    private static final Map<ResourceLocation, Gun> clientConfigGuns;
    public static final Map<ResourceLocation, Gun> clientConfigGunIDs;

    public static Gun getClientGun(ResourceLocation id) {
        return clientConfigGuns.get(id);
    }

    protected Map<ResourceLocation, Gun> prepare(ResourceManager rm, ProfilerFiller profiler) {
        HashMap<ResourceLocation, Gun> map = new HashMap<ResourceLocation, Gun>();
        ForgeRegistries.ITEMS.getValues().stream().filter(it -> it instanceof GunItem).forEach(item -> {
            ResourceLocation id = ForgeRegistries.ITEMS.getKey(item);
            if (id == null) {
                return;
            }
            rm.m_214159_("guns", path -> path.m_135815_().endsWith(id.m_135815_() + ".json")).keySet().stream().sorted((r1, r2) -> Boolean.compare(r2.m_135827_().equals("jeg"), r1.m_135827_().equals("jeg"))).forEach(resLoc -> this.readJson(resLoc.m_135827_(), resLoc.m_135815_(), () -> ((Resource)rm.m_213713_(resLoc).get()).m_215507_(), map, id));
        });
        try {
            Files.createDirectories(CONFIG_GUN_DIR, new FileAttribute[0]);
            try (Stream<Path> files = Files.walk(CONFIG_GUN_DIR, new FileVisitOption[0]);){
                files.filter(p -> p.toString().endsWith(".json")).forEach(p -> {
                    this.readJson(CONFIG_NAMESPACE, p.getFileName().toString(), () -> Files.newInputStream(p, new OpenOption[0]), map, null);
                    String base = p.getFileName().toString().replace(".json", "");
                    ResourceLocation id = new ResourceLocation(CONFIG_NAMESPACE, base);
                    clientConfigGunIDs.put(id, (Gun)map.get(id));
                });
            }
        }
        catch (IOException e) {
            JustEnoughGuns.LOGGER.error("Couldn't scan {}", (Object)CONFIG_GUN_DIR, (Object)e);
        }
        return map;
    }

    protected void apply(Map<ResourceLocation, Gun> parsedGuns, ResourceManager rm, ProfilerFiller profiler) {
        this.registeredGuns = ImmutableMap.copyOf(parsedGuns);
        parsedGuns.forEach((id, gun) -> {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
            if (item instanceof GunItem) {
                GunItem gunItem = (GunItem)item;
                gunItem.setGun(new Supplier((Gun)gun));
            }
        });
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ArrayList<ItemStack> samples = new ArrayList<ItemStack>();
            for (ResourceLocation id2 : parsedGuns.keySet()) {
                ItemStack stack;
                Item item = (Item)ForgeRegistries.ITEMS.getValue(id2);
                if (item instanceof GunItem) {
                    stack = new ItemStack((ItemLike)item);
                    continue;
                }
                stack = GunItem.makeGunStack(id2);
                samples.add(stack);
            }
        }
    }

    public void writeRegisteredGuns(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.registeredGuns.size());
        this.registeredGuns.forEach((id, gun) -> {
            buffer.m_130085_(id);
            buffer.m_130079_(gun.serializeNBT());
        });
    }

    public static ImmutableMap<ResourceLocation, Gun> readRegisteredGuns(FriendlyByteBuf buffer) {
        int size = buffer.m_130242_();
        if (size > 0) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < size; ++i) {
                ResourceLocation id = buffer.m_130281_();
                Gun gun = Gun.create(buffer.m_130260_());
                builder.put((Object)id, (Object)gun);
            }
            return builder.build();
        }
        return ImmutableMap.of();
    }

    public static boolean updateRegisteredGuns(S2CMessageUpdateGuns message) {
        return NetworkGunManager.updateRegisteredGuns(message.getRegisteredGuns());
    }

    private static boolean updateRegisteredGuns(Map<ResourceLocation, Gun> guns) {
        clientRegisteredGuns.clear();
        guns.forEach((id, gun) -> {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
            if (item instanceof GunItem) {
                GunItem gi;
                GunItem targetItem = gi = (GunItem)item;
                targetItem.setGun(new Supplier((Gun)gun));
                clientRegisteredGuns.add(targetItem);
            } else {
                GunItem targetItem = (GunItem)ModItems.ABSTRACT_GUN.get();
                clientConfigGuns.put((ResourceLocation)id, (Gun)gun);
            }
        });
        return true;
    }

    public Map<ResourceLocation, Gun> getRegisteredGuns() {
        return this.registeredGuns;
    }

    public static List<GunItem> getClientRegisteredGuns() {
        return ImmutableList.copyOf(clientRegisteredGuns);
    }

    @SubscribeEvent
    public static void onServerStopped(ServerStoppedEvent event) {
        instance = null;
    }

    @SubscribeEvent
    public static void addReloadListenerEvent(AddReloadListenerEvent event) {
        NetworkGunManager networkGunManager = new NetworkGunManager();
        event.addListener((PreparableReloadListener)networkGunManager);
        instance = networkGunManager;
    }

    @SubscribeEvent
    public static void onDatapackSync(OnDatapackSyncEvent event) {
        if (event.getPlayer() == null) {
            PacketHandler.getPlayChannel().sendToAll((IMessage)new S2CMessageUpdateGuns());
        }
    }

    @Nullable
    public static NetworkGunManager get() {
        return instance;
    }

    private void readJson(String namespace, String filePath, IOSupplier<InputStream> opener, Map<ResourceLocation, Gun> sink, @Nullable ResourceLocation forcedId) {
        try (BufferedReader r = new BufferedReader(new InputStreamReader(opener.get(), StandardCharsets.UTF_8));){
            ResourceLocation id;
            Gun gun = (Gun)GsonHelper.m_13776_((Gson)GSON_INSTANCE, (Reader)r, Gun.class);
            if (gun == null || !Validator.isValidObject(gun)) {
                JustEnoughGuns.LOGGER.error("Malformed gun file {}", (Object)filePath);
                return;
            }
            if (forcedId != null) {
                id = forcedId;
            } else {
                String base = filePath.substring(0, filePath.length() - 5);
                if (base.contains("/")) {
                    base = base.substring(base.lastIndexOf(47) + 1);
                }
                Object uniqueBase = base;
                int counter = 1;
                ResourceLocation testId = new ResourceLocation(namespace, (String)uniqueBase);
                while (sink.containsKey(testId)) {
                    uniqueBase = base + "_" + counter++;
                    testId = new ResourceLocation(namespace, (String)uniqueBase);
                }
                id = testId;
            }
            sink.put(id, gun);
            JustEnoughGuns.LOGGER.info("Registered gun '{}'", (Object)id);
        }
        catch (Exception ex) {
            JustEnoughGuns.LOGGER.error("Couldn't read {}", (Object)filePath, (Object)ex);
        }
    }

    static {
        clientConfigGuns = new HashMap<ResourceLocation, Gun>();
        clientConfigGunIDs = new HashMap<ResourceLocation, Gun>();
    }

    @FunctionalInterface
    private static interface IOSupplier<T> {
        public T get() throws IOException;
    }

    public static class Supplier {
        private final Gun gun;

        private Supplier(Gun gun) {
            this.gun = gun;
        }

        public Gun getGun() {
            return this.gun;
        }
    }

    public static class LoginData
    implements ILoginData {
        public void writeData(FriendlyByteBuf buffer) {
            Validate.notNull((Object)((Object)NetworkGunManager.get()));
            NetworkGunManager.get().writeRegisteredGuns(buffer);
        }

        public Optional<String> readData(FriendlyByteBuf buffer) {
            ImmutableMap<ResourceLocation, Gun> registeredGuns = NetworkGunManager.readRegisteredGuns(buffer);
            NetworkGunManager.updateRegisteredGuns(registeredGuns);
            return Optional.empty();
        }
    }
}

