/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.common;

import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import ttv.migami.jeg.common.AmmoContext;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.common.ReloadType;
import ttv.migami.jeg.init.ModEnchantments;
import ttv.migami.jeg.init.ModItems;
import ttv.migami.jeg.init.ModSyncedDataKeys;
import ttv.migami.jeg.item.GunItem;
import ttv.migami.jeg.util.GunEnchantmentHelper;
import ttv.migami.jeg.util.GunModifierHelper;

@Mod.EventBusSubscriber(modid="jeg")
public class ReloadTracker {
    private static final Map<Player, ReloadTracker> RELOAD_TRACKER_MAP = new WeakHashMap<Player, ReloadTracker>();
    private final int startTick;
    private final int slot;
    private final ItemStack stack;
    private final Gun gun;
    private boolean firstReload;

    private ReloadTracker(Player player) {
        this.startTick = player.f_19797_;
        this.slot = player.m_150109_().f_35977_;
        this.stack = player.m_150109_().m_36056_();
        this.gun = ((GunItem)this.stack.m_41720_()).getModifiedGun(this.stack);
        this.firstReload = true;
    }

    private boolean isSameWeapon(Player player) {
        return !this.stack.m_41619_() && player.m_150109_().f_35977_ == this.slot && player.m_150109_().m_36056_() == this.stack;
    }

    private boolean isWeaponFull() {
        CompoundTag tag = this.stack.m_41784_();
        return tag.m_128451_("AmmoCount") >= GunModifierHelper.getModifiedAmmoCapacity(this.stack, this.gun);
    }

    private boolean isWeaponEmpty() {
        CompoundTag tag = this.stack.m_41784_();
        return tag.m_128451_("AmmoCount") == 0;
    }

    private boolean hasNoAmmo(Player player) {
        if (this.gun.getReloads().getReloadType() == ReloadType.SINGLE_ITEM) {
            return Gun.findAmmo(player, this.gun.getReloads().getReloadItem()).stack().m_41619_();
        }
        return Gun.findAmmo(player, this.gun.getProjectile().getItem()).stack().m_41619_();
    }

    private boolean canReload(Player player) {
        GunItem gunItem = (GunItem)this.stack.m_41720_();
        int deltaTicks = player.f_19797_ - this.startTick;
        if (deltaTicks == 4) {
            ResourceLocation reloadSound = this.gun.getSounds().getReloadStart();
            ReloadTracker.playReloadSound(reloadSound, player);
        }
        int interval = this.isWeaponEmpty() ? GunEnchantmentHelper.getReloadInterval(this.stack, this.gun.getReloads().getReloadTimer() + this.gun.getReloads().getAdditionalReloadTimer()) : GunEnchantmentHelper.getReloadInterval(this.stack, this.gun.getReloads().getReloadTimer());
        if (this.gun.getReloads().getReloadType() == ReloadType.MAG_FED || this.gun.getReloads().getReloadType() == ReloadType.INVENTORY_FED || this.gun.getReloads().getReloadType() == ReloadType.SINGLE_ITEM) {
            int quickHandsLevel = player.m_21205_().getEnchantmentLevel((Enchantment)ModEnchantments.QUICK_HANDS.get());
            if (quickHandsLevel == 1) {
                interval = Math.max(1, Math.round((float)interval * 0.75f));
            } else if (quickHandsLevel >= 2) {
                interval = Math.max(1, Math.round((float)interval * 0.5f));
            }
            if (this.gun.getReloads().getReloadType() != ReloadType.INVENTORY_FED) {
                ResourceLocation reloadSound;
                if (deltaTicks == interval / 2) {
                    reloadSound = this.gun.getSounds().getReloadLoad();
                    ReloadTracker.playReloadSound(reloadSound, player);
                }
                if (deltaTicks == interval - 5) {
                    reloadSound = this.gun.getSounds().getEjectorPull();
                    ReloadTracker.playReloadSound(reloadSound, player);
                }
            }
            return deltaTicks > interval;
        }
        if (this.firstReload) {
            interval += this.gun.getReloads().getAdditionalReloadTimer();
        }
        return deltaTicks > 0 && deltaTicks % interval == 0;
    }

    public static int ammoInInventory(ItemStack[] ammoStack) {
        int result = 0;
        for (ItemStack x : ammoStack) {
            result += x.m_41613_();
        }
        return result;
    }

    private void shrinkFromAmmoPool(ItemStack[] ammoStack, Player player, int shrinkAmount) {
        if (player.m_21205_().getEnchantmentLevel((Enchantment)ModEnchantments.INFINITY.get()) != 0) {
            return;
        }
        int shrinkAmt = shrinkAmount;
        ArrayList stacks = new ArrayList();
        for (ItemStack x : ammoStack) {
            if (!x.m_41619_()) {
                int max = Math.min(shrinkAmt, x.m_41613_());
                x.m_41774_(max);
                shrinkAmt -= max;
            }
            if (shrinkAmt != 0) continue;
            return;
        }
    }

    private void increaseMagAmmo(Player player) {
        ItemStack[] ammoStack = Gun.findAmmoStack(player, this.gun.getProjectile().getItem());
        if (ammoStack.length > 0) {
            CompoundTag tag = this.stack.m_41783_();
            int ammoAmount = Math.min(ReloadTracker.ammoInInventory(ammoStack), GunModifierHelper.getModifiedAmmoCapacity(this.stack, this.gun));
            int currentAmmo = tag.m_128451_("AmmoCount");
            int maxAmmo = GunModifierHelper.getModifiedAmmoCapacity(this.stack, this.gun);
            int amount = maxAmmo - currentAmmo;
            if (tag != null) {
                if (ammoAmount < amount) {
                    tag.m_128405_("AmmoCount", currentAmmo + ammoAmount);
                    this.shrinkFromAmmoPool(ammoStack, player, ammoAmount);
                } else {
                    tag.m_128405_("AmmoCount", maxAmmo);
                    this.shrinkFromAmmoPool(ammoStack, player, amount);
                }
            }
        }
        ResourceLocation reloadSound = this.gun.getSounds().getEjectorRelease();
        ReloadTracker.playReloadSound(reloadSound, player);
    }

    private void reloadItem(Player player) {
        Item bucket;
        ResourceLocation bucketLocation;
        Item item;
        AmmoContext context = Gun.findAmmo(player, this.gun.getReloads().getReloadItem());
        ItemStack ammo = context.stack();
        if (!ammo.m_41619_()) {
            Container container;
            CompoundTag tag = this.stack.m_41783_();
            if (tag != null) {
                int maxAmmo = GunModifierHelper.getModifiedAmmoCapacity(this.stack, this.gun);
                tag.m_128405_("AmmoCount", maxAmmo);
                ammo.m_41774_(1);
            }
            if ((container = context.container()) != null) {
                container.m_6596_();
            }
        }
        Item waterBucket = Items.f_42447_;
        Item lavaBucket = Items.f_42448_;
        ResourceLocation waterBucketLocation = ForgeRegistries.ITEMS.getKey((Object)waterBucket);
        ResourceLocation lavaBucketLocation = ForgeRegistries.ITEMS.getKey((Object)lavaBucket);
        if ((this.gun.getReloads().getReloadItem().equals((Object)waterBucketLocation) || this.gun.getReloads().getReloadItem().equals((Object)lavaBucketLocation)) && (item = (Item)ForgeRegistries.ITEMS.getValue(bucketLocation = ForgeRegistries.ITEMS.getKey((Object)(bucket = Items.f_42446_)))) != null && this.stack.getEnchantmentLevel((Enchantment)ModEnchantments.INFINITY.get()) == 0) {
            ItemStack itemStack = new ItemStack((ItemLike)item);
            player.m_9236_().m_7967_((Entity)new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), itemStack.m_41777_()));
        }
        ResourceLocation reloadSound = this.gun.getSounds().getReloadLoad();
        ReloadTracker.playReloadSound(reloadSound, player);
    }

    public static void inventoryFeed(Player player, Gun gun) {
        AmmoContext context = Gun.findAmmo(player, gun.getProjectile().getItem());
        ItemStack ammo = context.stack();
        CompoundTag tag = player.m_21205_().m_41783_();
        if (tag != null && !ammo.m_41619_()) {
            tag.m_128405_("AmmoCount", tag.m_128451_("AmmoCount") + 1);
            ammo.m_41774_(1);
        }
    }

    private void increaseAmmo(Player player) {
        AmmoContext context = Gun.findAmmo(player, this.gun.getProjectile().getItem());
        ItemStack ammo = context.stack();
        if (!ammo.m_41619_()) {
            int amount = Math.min(ammo.m_41613_(), this.gun.getReloads().getReloadAmount());
            CompoundTag tag = this.stack.m_41783_();
            if (tag != null) {
                int maxAmmo = GunModifierHelper.getModifiedAmmoCapacity(this.stack, this.gun);
                amount = Math.min(amount, maxAmmo - tag.m_128451_("AmmoCount"));
                tag.m_128405_("AmmoCount", tag.m_128451_("AmmoCount") + amount);
                if (ammo.m_150930_((Item)ModItems.TERROR_ARMADA_FLARE.get())) {
                    player.m_5661_((Component)Component.m_237115_((String)"chat.jeg.raid_flare_loaded").m_130940_(ChatFormatting.RED), true);
                    tag.m_128379_("HasTerrorRaid", true);
                }
                if (ammo.m_41783_() != null && ammo.m_41783_().m_128471_("HasRaid")) {
                    if (ammo.m_41783_().m_128441_("Raid")) {
                        tag.m_128359_("Raid", ammo.m_41783_().m_128461_("Raid"));
                    }
                    player.m_5661_((Component)Component.m_237115_((String)"chat.jeg.raid_flare_loaded").m_130940_(ChatFormatting.RED), true);
                    tag.m_128379_("HasRaid", true);
                }
            }
            ammo.m_41774_(amount);
            ResourceLocation reloadSound = this.gun.getSounds().getReloadLoad();
            ReloadTracker.playReloadSound(reloadSound, player);
            Container container = context.container();
            if (container != null) {
                container.m_6596_();
            }
        }
        ResourceLocation reloadSound = this.gun.getSounds().getReloadLoad();
        ReloadTracker.playReloadSound(reloadSound, player);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !event.player.m_9236_().f_46443_) {
            Player player = event.player;
            CompoundTag tag = player.m_21205_().m_41783_();
            if (((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player)).booleanValue()) {
                ReloadTracker tracker;
                if (!RELOAD_TRACKER_MAP.containsKey(player)) {
                    if (!(player.m_150109_().m_36056_().m_41720_() instanceof GunItem)) {
                        ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)false);
                        return;
                    }
                    RELOAD_TRACKER_MAP.put(player, new ReloadTracker(player));
                }
                if (!(tracker = RELOAD_TRACKER_MAP.get(player)).isSameWeapon(player) || tracker.isWeaponFull() || tracker.hasNoAmmo(player)) {
                    RELOAD_TRACKER_MAP.remove(player);
                    ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)false);
                    return;
                }
                if (tracker.canReload(player)) {
                    Player finalPlayer = player;
                    Gun gun = tracker.gun;
                    if (gun.getReloads().getReloadType() == ReloadType.MAG_FED) {
                        tracker.increaseMagAmmo(player);
                    } else if (gun.getReloads().getReloadType() == ReloadType.SINGLE_ITEM) {
                        tracker.reloadItem(player);
                    } else if (gun.getReloads().getReloadType() == ReloadType.MANUAL) {
                        tracker.increaseAmmo(player);
                        tracker.firstReload = false;
                    } else if (gun.getReloads().getReloadType() == ReloadType.INVENTORY_FED) {
                        tracker.increaseAmmo(player);
                    }
                    if (tracker.isWeaponFull() || tracker.hasNoAmmo(player)) {
                        RELOAD_TRACKER_MAP.remove(player);
                        ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)false);
                    }
                }
            } else if (RELOAD_TRACKER_MAP.containsKey(player)) {
                RELOAD_TRACKER_MAP.remove(player);
            }
        }
    }

    private static void playReloadSound(ResourceLocation location, Player player) {
        if (location == null) {
            return;
        }
        ItemStack heldItem = player.m_21205_();
        Item item = heldItem.m_41720_();
        if (!(item instanceof GunItem)) {
            return;
        }
        GunItem gunItem = (GunItem)item;
        Gun gun = gunItem.getModifiedGun(player.m_21205_());
        SoundEvent sound = (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(location);
        if (sound == null) {
            return;
        }
        CompoundTag nbt = heldItem.m_41783_();
        boolean isFirstPerson = nbt != null && nbt.m_128471_("IsFirstPersonReload");
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (isFirstPerson) {
                serverLevel.m_5594_(player, player.m_20097_(), sound, SoundSource.PLAYERS, 1.0f, 1.0f);
            } else {
                serverLevel.m_5594_(null, player.m_20097_(), sound, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerEvent.PlayerLoggedOutEvent event) {
        MinecraftServer server = event.getEntity().m_20194_();
        if (server != null) {
            server.execute(() -> RELOAD_TRACKER_MAP.remove(event.getEntity()));
        }
    }
}

