/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.crafting.workbench;

import com.google.common.collect.ImmutableList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import ttv.migami.jeg.crafting.workbench.WorkbenchIngredient;
import ttv.migami.jeg.util.InventoryUtil;

public abstract class AbstractWorkbenchRecipe<T extends BlockEntity>
implements Recipe<T> {
    private final ResourceLocation id;
    private final ItemStack item;
    private final ImmutableList<WorkbenchIngredient> materials;

    public AbstractWorkbenchRecipe(ResourceLocation id, ItemStack item, ImmutableList<WorkbenchIngredient> materials) {
        this.id = id;
        this.item = item;
        this.materials = materials;
    }

    public ItemStack getItem() {
        return this.item.m_41777_();
    }

    public ImmutableList<WorkbenchIngredient> getMaterials() {
        return this.materials;
    }

    public boolean matches(T inv, Level worldIn) {
        return false;
    }

    public ItemStack assemble(T entity, RegistryAccess access) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return this.item.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public abstract RecipeSerializer<?> m_7707_();

    public abstract RecipeType<?> m_6671_();

    public boolean hasMaterials(Player player) {
        for (WorkbenchIngredient ingredient : this.getMaterials()) {
            if (InventoryUtil.hasWorkstationIngredient(player, ingredient)) continue;
            return false;
        }
        return true;
    }

    public void consumeMaterials(Player player) {
        for (WorkbenchIngredient ingredient : this.getMaterials()) {
            InventoryUtil.removeWorkstationIngredient(player, ingredient);
        }
    }

    public boolean m_5598_() {
        return true;
    }
}

