/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.datagen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import ttv.migami.jeg.modifier.Modifier;
import ttv.migami.jeg.modifier.type.ExplosiveAmmoModifier;
import ttv.migami.jeg.modifier.type.IModifierEffect;
import ttv.migami.jeg.modifier.type.PotionEffectModifier;
import ttv.migami.jeg.modifier.type.StatModifier;

public abstract class ModifierProvider
implements DataProvider {
    protected final PackOutput.PathProvider pathProvider;
    private final CompletableFuture<HolderLookup.Provider> registries;
    private final Map<ResourceLocation, Modifier> groupMap = new HashMap<ResourceLocation, Modifier>();

    protected ModifierProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        this.pathProvider = output.m_245269_(PackOutput.Target.DATA_PACK, "modifiers");
        this.registries = registries;
    }

    protected abstract void registerGroups();

    protected final void addGroup(ResourceLocation id, Modifier group) {
        this.groupMap.put(id, group);
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        return this.registries.thenCompose(provider -> {
            this.groupMap.clear();
            this.registerGroups();
            return CompletableFuture.allOf((CompletableFuture[])this.groupMap.entrySet().stream().map(entry -> {
                ResourceLocation key = (ResourceLocation)entry.getKey();
                Modifier group = (Modifier)entry.getValue();
                Path path = this.pathProvider.m_245731_(key);
                JsonObject object = this.toJson(group);
                return DataProvider.m_253162_((CachedOutput)cache, (JsonElement)object, (Path)path);
            }).toArray(CompletableFuture[]::new));
        });
    }

    public String m_6055_() {
        return "Modifier Groups: jeg";
    }

    private JsonObject toJson(Modifier group) {
        JsonObject json = new JsonObject();
        json.addProperty("name", group.getName());
        json.addProperty("rarity", group.getRarity().name().toLowerCase());
        json.addProperty("chance", (Number)Float.valueOf(group.getChance()));
        json.addProperty("color", (Number)group.getColor());
        JsonArray mods = new JsonArray();
        for (IModifierEffect effect : group.getModifiers()) {
            JsonObject modJson = new JsonObject();
            if (effect instanceof StatModifier) {
                StatModifier statMod = (StatModifier)effect;
                modJson.addProperty("type", "stat");
                modJson.addProperty("attribute", statMod.getStatType().name().toLowerCase());
                modJson.addProperty("amount", (Number)statMod.getValue());
            } else if (effect instanceof PotionEffectModifier) {
                PotionEffectModifier potionMod = (PotionEffectModifier)effect;
                modJson.addProperty("type", "potion");
                modJson.addProperty("effect", BuiltInRegistries.f_256974_.m_7981_((Object)potionMod.getEffect()).toString());
                modJson.addProperty("duration", (Number)potionMod.getDuration());
                modJson.addProperty("amplifier", (Number)potionMod.getAmplifier());
            } else if (effect instanceof ExplosiveAmmoModifier) {
                modJson.addProperty("type", "explosive");
                modJson.addProperty("value", Boolean.valueOf(true));
            }
            mods.add((JsonElement)modJson);
        }
        json.add("modifiers", (JsonElement)mods);
        return json;
    }
}

