/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import ttv.migami.jeg.init.ModEffects;

public class SmokeCloud
extends AreaEffectCloud {
    private static final int fireCheckInterval = 5;
    private int checkTimer = 0;

    public SmokeCloud(Level world, double x, double y, double z, SimpleParticleType particle, float radius, int duration) {
        super(world, x, y, z);
        this.m_19724_((ParticleOptions)particle);
        this.m_19712_(radius);
        this.m_19734_(duration);
        this.m_19716_(new MobEffectInstance((MobEffect)ModEffects.SMOKED.get(), 30, 0, false, false, true));
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            ++this.checkTimer;
            if (this.checkTimer >= 5) {
                this.checkTimer = 0;
                if (this.extinguishNearbyFire()) {
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
        }
    }

    private boolean extinguishNearbyFire() {
        double distSq;
        double dz;
        double dy;
        double dx;
        boolean extinguishedAny = false;
        float radius = this.m_19743_() * 2.0f;
        int radiusCeil = Mth.m_14167_((float)radius);
        int centerX = Mth.m_14107_((double)this.m_20185_());
        int centerY = Mth.m_14107_((double)this.m_20186_());
        int centerZ = Mth.m_14107_((double)this.m_20189_());
        double radiusSq = radius * radius;
        BlockPos minPos = new BlockPos(centerX - radiusCeil, centerY - 1, centerZ - radiusCeil);
        BlockPos maxPos = new BlockPos(centerX + radiusCeil, centerY + 2, centerZ + radiusCeil);
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)minPos, (BlockPos)maxPos)) {
            dx = pos.m_123341_() - centerX;
            distSq = dx * dx + (dy = (double)(pos.m_123342_() - centerY)) * dy + (dz = (double)(pos.m_123343_() - centerZ)) * dz;
            if (!(distSq <= radiusSq) || !this.m_9236_().m_8055_(pos).m_60713_(Blocks.f_50083_)) continue;
            this.m_9236_().m_7471_(pos, false);
            extinguishedAny = true;
        }
        for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_((double)radius))) {
            dx = entity.m_20185_() - this.m_20185_();
            distSq = dx * dx + (dy = entity.m_20186_() - this.m_20186_()) * dy + (dz = entity.m_20189_() - this.m_20189_()) * dz;
            if (!(distSq <= radiusSq) || entity.m_20094_() <= 0) continue;
            entity.m_7311_(0);
            extinguishedAny = true;
        }
        return extinguishedAny;
    }
}

