/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.entity.throwable;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.common.network.ServerPlayHandler;
import ttv.migami.jeg.entity.projectile.ProjectileEntity;
import ttv.migami.jeg.init.ModParticleTypes;
import ttv.migami.jeg.item.GunItem;

public class GrenadeEntity
extends ProjectileEntity {
    public GrenadeEntity(EntityType<? extends ProjectileEntity> entityType, Level world) {
        super(entityType, world);
    }

    public GrenadeEntity(EntityType<? extends ProjectileEntity> entityType, Level world, LivingEntity shooter, ItemStack weapon, GunItem item, Gun modifiedGun) {
        super(entityType, world, shooter, weapon, item, modifiedGun);
    }

    @Override
    protected void impactEffect() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ServerPlayHandler.sendParticlesToAll(serverLevel, (SimpleParticleType)ModParticleTypes.BIG_EXPLOSION.get(), true, this.m_20185_() - this.m_20184_().m_7096_(), this.m_20186_() - this.m_20184_().m_7098_(), this.m_20189_() - this.m_20184_().m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (this.m_9236_().f_46443_) {
            double posX = this.m_20185_() - this.m_20184_().m_7096_();
            double posY = this.m_20186_() - this.m_20184_().m_7098_();
            double posZ = this.m_20189_() - this.m_20184_().m_7094_();
            for (int i = 0; i < 10; ++i) {
                double xSpeed = (this.f_19796_.m_188500_() - 0.5) * 0.5 * 10.0;
                double ySpeed = (this.f_19796_.m_188500_() - 0.5) * 0.5 * 10.0;
                double zSpeed = (this.f_19796_.m_188500_() - 0.5) * 0.5 * 10.0;
                this.m_9236_().m_6493_((ParticleOptions)ModParticleTypes.SMOKE.get(), true, posX, posY + 2.0, posZ, xSpeed, ySpeed, zSpeed);
                this.m_9236_().m_6493_((ParticleOptions)ModParticleTypes.FIRE.get(), true, posX, posY + 2.0, posZ, xSpeed, ySpeed, zSpeed);
            }
        }
    }

    @Override
    protected void onHitEntity(Entity entity, Vec3 hitVec, Vec3 startVec, Vec3 endVec, boolean headshot) {
        GrenadeEntity.createExplosion(this, this.getDamage() / 5.0f, true);
    }

    @Override
    protected void onHitBlock(BlockState state, BlockPos pos, Direction face, double x, double y, double z) {
        GrenadeEntity.createExplosion(this, this.getDamage() / 5.0f, true);
    }

    @Override
    public void onExpired() {
        GrenadeEntity.createExplosion(this, this.getDamage() / 5.0f, true);
    }
}

