/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.entity.throwable;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.common.Mod;
import org.joml.Vector3f;
import ttv.migami.jeg.entity.monster.phantom.terror.TerrorPhantom;
import ttv.migami.jeg.entity.throwable.ThrowableGrenadeEntity;
import ttv.migami.jeg.entity.throwable.ThrowableItemEntity;
import ttv.migami.jeg.init.ModEntities;
import ttv.migami.jeg.init.ModItems;
import ttv.migami.jeg.init.ModParticleTypes;

@Mod.EventBusSubscriber
public class ThrowableAirStrikeFlareEntity
extends ThrowableGrenadeEntity {
    private Player player;
    private boolean hasSummoned;
    private Vec3 lookAngle;
    private static final EntityDataAccessor<Vector3f> ANGLE = SynchedEntityData.m_135353_(ThrowableAirStrikeFlareEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);

    public ThrowableAirStrikeFlareEntity(EntityType<? extends ThrowableGrenadeEntity> entityType, Level world) {
        super(entityType, world);
        this.setMaxLife(200);
    }

    public ThrowableAirStrikeFlareEntity(Level world, LivingEntity player, Vec3 lookAngle) {
        super((EntityType<? extends ThrowableItemEntity>)((EntityType)ModEntities.THROWABLE_TERROR_PHANTOM_FLARE.get()), world, player);
        this.setItem(new ItemStack((ItemLike)ModItems.AIR_STRIKE_FLARE.get()));
        this.setMaxLife(200);
        if (player instanceof Player) {
            this.player = (Player)player;
        }
        this.hasSummoned = false;
        this.lookAngle = lookAngle;
    }

    @Override
    public void particleTick() {
        Vec3 lookDirection;
        Vec3 pos;
        if (!this.m_9236_().f_46443_ && this.f_19797_ > 100 && !this.hasSummoned) {
            pos = this.m_20182_();
            this.lookAngle = new Vec3((double)this.getAngle().x(), (double)this.getAngle().y(), (double)this.getAngle().z());
            lookDirection = this.lookAngle.m_82541_();
            Vec3 horizontalLook = new Vec3(lookDirection.f_82479_, 0.0, lookDirection.f_82481_).m_82541_();
            Vec3 spawnPos = pos.m_82546_(horizontalLook.m_82490_(75.0)).m_82520_(0.0, 32.0, 0.0);
            TerrorPhantom gunner = new TerrorPhantom((EntityType<? extends Phantom>)((EntityType)ModEntities.TERROR_PHANMTOM.get()), this.player.m_9236_());
            gunner.m_7678_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, 0.0f, 0.0f);
            this.m_9236_().m_7967_((Entity)gunner);
            gunner.m_20049_("PlayerOwned");
            gunner.setPlayer(this.player);
            gunner.m_21391_((Entity)this, 255.0f, 255.0f);
            this.hasSummoned = true;
            this.f_19794_ = true;
        }
        if (this.m_9236_().f_46443_ && this.f_19797_ > 20) {
            pos = this.m_20182_();
            this.lookAngle = new Vec3((double)this.getAngle().x(), (double)this.getAngle().y(), (double)this.getAngle().z());
            lookDirection = this.lookAngle.m_82541_();
            Vec3 rightOffset = lookDirection.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_().m_82490_(8.0);
            Vec3 startPos = pos.m_82549_(lookDirection.m_82490_(10.0));
            Vec3 endPos = pos.m_82549_(lookDirection.m_82490_(40.0));
            int numSteps = 50;
            double fixedY = pos.f_82480_ + 0.2;
            for (int i = 0; i <= numSteps; ++i) {
                double factor = (double)i / (double)numSteps;
                Vec3 horizontalLook = new Vec3(lookDirection.f_82479_, 0.0, lookDirection.f_82481_).m_82541_();
                Vec3 stepPos = startPos.m_82549_(horizontalLook.m_82490_(factor * 90.0));
                Vec3 line1 = new Vec3(stepPos.f_82479_, fixedY, stepPos.f_82481_).m_82549_(rightOffset);
                Vec3 line2 = new Vec3(stepPos.f_82479_, fixedY, stepPos.f_82481_).m_82546_(rightOffset);
                Vec3 centerPos = new Vec3(stepPos.f_82479_, fixedY, stepPos.f_82481_);
                this.m_9236_().m_6493_((ParticleOptions)ModParticleTypes.ENTITY_LASER.get(), true, line1.f_82479_, fixedY, line1.f_82481_, 0.0, 0.0, 0.0);
                this.m_9236_().m_6493_((ParticleOptions)ModParticleTypes.ENTITY_LASER.get(), true, line2.f_82479_, fixedY, line2.f_82481_, 0.0, 0.0, 0.0);
                if (i % 2 != 0) continue;
                for (double j = 0.0; j <= 1.0; j += 0.2) {
                    Vec3 midPoint = centerPos.m_82549_(horizontalLook.m_82490_(j));
                    Vec3 midLeft = midPoint.m_82549_(rightOffset.m_82490_(-0.5));
                    Vec3 midRight = midPoint.m_82549_(rightOffset.m_82490_(0.5));
                    this.m_9236_().m_6493_((ParticleOptions)ModParticleTypes.ENTITY_LASER.get(), true, midPoint.f_82479_, fixedY, midPoint.f_82481_, 0.0, 0.0, 0.0);
                    this.m_9236_().m_6493_((ParticleOptions)ModParticleTypes.ENTITY_LASER.get(), true, midLeft.f_82479_, fixedY, midLeft.f_82481_, 0.0, 0.0, 0.0);
                    this.m_9236_().m_6493_((ParticleOptions)ModParticleTypes.ENTITY_LASER.get(), true, midRight.f_82479_, fixedY, midRight.f_82481_, 0.0, 0.0, 0.0);
                    Vec3 outerLeft = midPoint.m_82549_(rightOffset.m_82490_(-1.05));
                    Vec3 vec3 = midPoint.m_82549_(rightOffset.m_82490_(1.05));
                }
            }
        }
        if (this.m_9236_().f_46443_ && this.f_19797_ > 20) {
            for (int i = 0; i < 2; ++i) {
                this.m_9236_().m_6493_((ParticleOptions)ModParticleTypes.BLUE_FLARE.get(), true, this.m_20185_() - this.m_20184_().m_7096_() / (double)i, this.m_20186_() - this.m_20184_().m_7098_() / (double)i, this.m_20189_() - this.m_20184_().m_7094_() / (double)i, 0.0, 0.0, 0.0);
                this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123756_, true, this.m_20185_() - this.m_20184_().m_7096_() / (double)i, this.m_20186_() - this.m_20184_().m_7098_() / (double)i, this.m_20189_() - this.m_20184_().m_7094_() / (double)i, 0.0, 0.0, 0.0);
                this.m_9236_().m_6493_((ParticleOptions)ModParticleTypes.FIRE.get(), true, this.m_20185_() - this.m_20184_().m_7096_() / (double)i, this.m_20186_() - this.m_20184_().m_7098_() / (double)i, this.m_20189_() - this.m_20184_().m_7094_() / (double)i, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void onDeath() {
    }

    public Vector3f getAngle() {
        return (Vector3f)this.f_19804_.m_135370_(ANGLE);
    }

    public void setAngle(Vector3f angle) {
        this.f_19804_.m_135381_(ANGLE, (Object)angle);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANGLE, (Object)Vec3.f_82478_.m_252839_());
    }
}

