/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.entity.throwable;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.common.Mod;
import ttv.migami.jeg.entity.throwable.ThrowableGrenadeEntity;
import ttv.migami.jeg.entity.throwable.ThrowableItemEntity;
import ttv.migami.jeg.faction.Faction;
import ttv.migami.jeg.faction.GunnerManager;
import ttv.migami.jeg.init.ModCommands;
import ttv.migami.jeg.init.ModEntities;
import ttv.migami.jeg.init.ModItems;
import ttv.migami.jeg.init.ModParticleTypes;

@Mod.EventBusSubscriber
public class ThrowableFlareEntity
extends ThrowableGrenadeEntity {
    private boolean hasRaid = false;
    private String raidName = null;
    private boolean terrorRaid = false;

    public ThrowableFlareEntity(EntityType<? extends ThrowableGrenadeEntity> entityType, Level world) {
        super(entityType, world);
        this.setMaxLife(this.hasRaid ? 3200 : 620);
    }

    public ThrowableFlareEntity(EntityType<? extends ThrowableGrenadeEntity> entityType, Level world, LivingEntity livingEntity) {
        super(entityType, world, livingEntity);
        this.setItem(new ItemStack((ItemLike)ModItems.FLARE.get()));
        this.setMaxLife(this.hasRaid ? 3200 : 620);
    }

    public ThrowableFlareEntity(Level world, LivingEntity livingEntity) {
        super((EntityType<? extends ThrowableItemEntity>)((EntityType)ModEntities.THROWABLE_FLARE.get()), world, livingEntity);
        this.setItem(new ItemStack((ItemLike)ModItems.FLARE.get()));
        this.setMaxLife(this.hasRaid ? 3200 : 620);
    }

    public ThrowableFlareEntity(Level world, LivingEntity livingEntity, boolean hasRaid) {
        super((EntityType<? extends ThrowableItemEntity>)((EntityType)ModEntities.THROWABLE_FLARE.get()), world, livingEntity);
        this.setItem(new ItemStack((ItemLike)ModItems.FLARE.get()));
        this.hasRaid = hasRaid;
        this.setMaxLife(3200);
    }

    public ThrowableFlareEntity(Level world, LivingEntity livingEntity, boolean hasRaid, boolean terrorRaid) {
        super((EntityType<? extends ThrowableItemEntity>)((EntityType)ModEntities.THROWABLE_FLARE.get()), world, livingEntity);
        this.setItem(new ItemStack((ItemLike)ModItems.TERROR_ARMADA_FLARE.get()));
        this.terrorRaid = terrorRaid;
        this.setMaxLife(3200);
    }

    public ThrowableFlareEntity(Level world, LivingEntity livingEntity, boolean hasRaid, String raid) {
        super((EntityType<? extends ThrowableItemEntity>)((EntityType)ModEntities.THROWABLE_FLARE.get()), world, livingEntity);
        this.setItem(new ItemStack((ItemLike)ModItems.FLARE.get()));
        this.hasRaid = hasRaid;
        this.raidName = raid;
        this.setMaxLife(3200);
    }

    @Override
    public void particleTick() {
        block8: {
            if (!this.m_9236_().f_46443_ && this.f_19797_ > 100) {
                if (this.hasRaid) {
                    GunnerManager gunnerManager = GunnerManager.getInstance();
                    Faction faction = gunnerManager.getFactionByName(gunnerManager.getRandomFactionName());
                    if (this.raidName != null) {
                        faction = gunnerManager.getFactionByName(this.raidName);
                    }
                    ModCommands.startRaid((ServerLevel)this.m_9236_(), faction, this.m_20182_(), true);
                    this.hasRaid = false;
                }
                if (this.terrorRaid) {
                    ModCommands.startTerrorRaid((ServerLevel)this.m_9236_(), this.m_20182_(), true, false);
                    this.terrorRaid = false;
                }
            }
            if (!this.m_9236_().f_46443_ || this.f_19797_ <= 20) break block8;
            if (this.terrorRaid) {
                for (int i = 0; i < 2; ++i) {
                    this.m_9236_().m_6493_((ParticleOptions)ModParticleTypes.BLUE_FLARE.get(), true, this.m_20185_() - this.m_20184_().m_7096_() / (double)i, this.m_20186_() - this.m_20184_().m_7098_() / (double)i, this.m_20189_() - this.m_20184_().m_7094_() / (double)i, 0.0, 0.0, 0.0);
                    this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123756_, true, this.m_20185_() - this.m_20184_().m_7096_() / (double)i, this.m_20186_() - this.m_20184_().m_7098_() / (double)i, this.m_20189_() - this.m_20184_().m_7094_() / (double)i, 0.0, 0.0, 0.0);
                    this.m_9236_().m_6493_((ParticleOptions)ModParticleTypes.FIRE.get(), true, this.m_20185_() - this.m_20184_().m_7096_() / (double)i, this.m_20186_() - this.m_20184_().m_7098_() / (double)i, this.m_20189_() - this.m_20184_().m_7094_() / (double)i, 0.0, 0.0, 0.0);
                }
            } else {
                for (int i = 0; i < 2; ++i) {
                    this.m_9236_().m_6493_((ParticleOptions)ModParticleTypes.FLARE.get(), true, this.m_20185_() - this.m_20184_().m_7096_() / (double)i, this.m_20186_() - this.m_20184_().m_7098_() / (double)i, this.m_20189_() - this.m_20184_().m_7094_() / (double)i, 0.0, 0.0, 0.0);
                    this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123756_, true, this.m_20185_() - this.m_20184_().m_7096_() / (double)i, this.m_20186_() - this.m_20184_().m_7098_() / (double)i, this.m_20189_() - this.m_20184_().m_7094_() / (double)i, 0.0, 0.0, 0.0);
                    this.m_9236_().m_6493_((ParticleOptions)ModParticleTypes.FIRE.get(), true, this.m_20185_() - this.m_20184_().m_7096_() / (double)i, this.m_20186_() - this.m_20184_().m_7098_() / (double)i, this.m_20189_() - this.m_20184_().m_7094_() / (double)i, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public void onDeath() {
    }
}

