/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.event;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.resource.PathPackResources;
import ttv.migami.jeg.JustEnoughGuns;
import ttv.migami.jeg.common.NetworkGunManager;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ConfigPackLoader {
    private static final String PACK_ID = "jeg_cfg_config_resources";
    private static final Path ROOT = NetworkGunManager.CONFIG_PACK_DIR;
    private static final Pack.ResourcesSupplier CONFIG_RESOURCES = id -> new PathPackResources(id, false, ROOT);

    @SubscribeEvent
    public static void onAddPackFinders(AddPackFindersEvent e) {
        if (e.getPackType() != PackType.CLIENT_RESOURCES) {
            return;
        }
        JustEnoughGuns.LOGGER.error("Trying to register a pack with the ID {} in the Root {}", (Object)PACK_ID, (Object)ROOT);
        ConfigPackLoader.ensurePackMcmeta();
        Pack pack = Pack.m_245429_((String)PACK_ID, (Component)Component.m_237113_((String)"JEG: Data-Driven Guns!"), (boolean)true, (Pack.ResourcesSupplier)CONFIG_RESOURCES, (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
        if (pack != null) {
            e.addRepositorySource(finder -> finder.accept(pack));
            JustEnoughGuns.LOGGER.error("Registered a Resource Pack for {}", (Object)PACK_ID);
        } else {
            JustEnoughGuns.LOGGER.error("Could not register the Resource Pack for {}", (Object)PACK_ID);
        }
    }

    private static void ensurePackMcmeta() {
        Path mcmeta = ROOT.resolve("pack.mcmeta");
        if (Files.notExists(mcmeta, new LinkOption[0])) {
            try {
                Files.createDirectories(ROOT, new FileAttribute[0]);
                String json = "{\n  \"pack\": {\n    \"pack_format\": 15,\n    \"description\": \"Assets for the new Data-Driven Guns!\"\n  }\n}\n";
                Files.writeString(mcmeta, (CharSequence)json, new OpenOption[0]);
                JustEnoughGuns.LOGGER.info("Generated default pack.mcmeta for {}", (Object)PACK_ID);
            }
            catch (IOException e) {
                JustEnoughGuns.LOGGER.error("Failed to create pack.mcmeta for {}", (Object)PACK_ID, (Object)e);
            }
        }
    }

    public static void exportSampleResourcesIfMissing() {
        Path exportRoot = NetworkGunManager.CONFIG_PACK_DIR;
        Map<String, String> filesToCopy = Map.of("assets/jeg/geo/vindicator_smg.geo.json", "assets/jeg/samples/geo/vindicator_smg.geo.json", "assets/jeg/textures/vindicator_smg.png", "assets/jeg/samples/textures/vindicator_smg.png", "assets/jeg/animations/vindicator_smg.animation.json", "assets/jeg/samples/animations/vindicator_smg.animation.json", "assets/jeg/geo/primitive_blowpipe.geo.json", "assets/jeg/samples/geo/primitive_blowpipe.geo.json", "assets/jeg/textures/primitive_blowpipe.png", "assets/jeg/samples/textures/primitive_blowpipe.png", "assets/jeg/animations/primitive_blowpipe.animation.json", "assets/jeg/samples/animations/primitive_blowpipe.animation.json", "assets/jeg/geo/fire_sweeper.geo.json", "assets/jeg/samples/geo/fire_sweeper.geo.json", "assets/jeg/textures/fire_sweeper.png", "assets/jeg/samples/textures/fire_sweeper.png", "assets/jeg/animations/fire_sweeper.animation.json", "assets/jeg/samples/animations/fire_sweeper.animation.json", "assets/jeg/lang/en_us.json", "assets/jeg/samples/lang/en_us.json");
        for (Map.Entry<String, String> entry : filesToCopy.entrySet()) {
            Path destPath = exportRoot.resolve(entry.getKey());
            String internalPath = entry.getValue();
            if (Files.exists(destPath, new LinkOption[0])) continue;
            try {
                Files.createDirectories(destPath.getParent(), new FileAttribute[0]);
                InputStream in = ConfigPackLoader.class.getClassLoader().getResourceAsStream(internalPath);
                try {
                    if (in == null) {
                        JustEnoughGuns.LOGGER.error("Missing resource in JAR: {}", (Object)internalPath);
                        continue;
                    }
                    Files.copy(in, destPath, new CopyOption[0]);
                    JustEnoughGuns.LOGGER.info("Exported sample file to {}", (Object)destPath);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            catch (IOException e) {
                JustEnoughGuns.LOGGER.error("Failed to export sample file to {}", (Object)destPath, (Object)e);
            }
        }
        Map<String, String> filesToCopy2 = Map.of("assets/jeg/textures/fire_sweeper.png.mcmeta", "assets/jeg/samples/textures/fire_sweeper.png.mcmeta");
        for (Map.Entry<String, String> entry : filesToCopy2.entrySet()) {
            Path destPath = exportRoot.resolve(entry.getKey());
            String internalPath = entry.getValue();
            if (Files.exists(destPath, new LinkOption[0])) continue;
            try {
                Files.createDirectories(destPath.getParent(), new FileAttribute[0]);
                InputStream in = ConfigPackLoader.class.getClassLoader().getResourceAsStream(internalPath);
                try {
                    if (in == null) {
                        JustEnoughGuns.LOGGER.error("Missing resource in JAR: {}", (Object)internalPath);
                        continue;
                    }
                    Files.copy(in, destPath, new CopyOption[0]);
                    JustEnoughGuns.LOGGER.info("Exported sample file to {}", (Object)destPath);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            catch (IOException e) {
                JustEnoughGuns.LOGGER.error("Failed to export sample file to {}", (Object)destPath, (Object)e);
            }
        }
    }

    public static void exportSampleDataIfMissing() {
        Path exportRoot = NetworkGunManager.CONFIG_GUN_DIR.getParent().getParent();
        Map<String, String> filesToCopy = Map.of("data/guns/vindicator_smg.json", "assets/jeg/samples/vindicator_smg.json", "data/guns/primitive_blowpipe.json", "assets/jeg/samples/primitive_blowpipe.json", "data/guns/fire_sweeper.json", "assets/jeg/samples/fire_sweeper.json");
        for (Map.Entry<String, String> entry : filesToCopy.entrySet()) {
            Path destPath = exportRoot.resolve(entry.getKey());
            String internalPath = entry.getValue();
            if (Files.exists(destPath, new LinkOption[0])) continue;
            try {
                Files.createDirectories(destPath.getParent(), new FileAttribute[0]);
                InputStream in = ConfigPackLoader.class.getClassLoader().getResourceAsStream(internalPath);
                try {
                    if (in == null) {
                        JustEnoughGuns.LOGGER.error("Missing resource in JAR: {}", (Object)internalPath);
                        continue;
                    }
                    Files.copy(in, destPath, new CopyOption[0]);
                    JustEnoughGuns.LOGGER.info("Exported sample file to {}", (Object)destPath);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            catch (IOException e) {
                JustEnoughGuns.LOGGER.error("Failed to export sample file to {}", (Object)destPath, (Object)e);
            }
        }
    }
}

