/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.faction.raid;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.SkeletonHorse;
import net.minecraft.world.entity.animal.horse.ZombieHorse;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import ttv.migami.jeg.Config;
import ttv.migami.jeg.common.network.ServerPlayHandler;
import ttv.migami.jeg.entity.throwable.ThrowableExplosiveChargeEntity;
import ttv.migami.jeg.entity.throwable.ThrowableGrenadeEntity;
import ttv.migami.jeg.faction.Faction;
import ttv.migami.jeg.faction.GunnerManager;
import ttv.migami.jeg.init.ModCommands;
import ttv.migami.jeg.init.ModEntities;
import ttv.migami.jeg.init.ModParticleTypes;
import ttv.migami.jeg.init.ModTags;

public class RaidEntity
extends Entity {
    private final ServerBossEvent bossBar;
    private final HashSet<LivingEntity> activeMobs = new HashSet();
    private final HashSet<LivingEntity> spawnedMobs = new HashSet();
    private final HashSet<Player> activePlayers = new HashSet();
    private Faction faction;
    private boolean forceGuns = true;
    private int totalWaves = 3;
    private int maxCooldown = 200;
    private int maxBreakTime = 100;
    private boolean inWave = false;
    private boolean justFinishedWave = false;
    private boolean spawningWave = false;
    private boolean isSpawningMobs = false;
    private int currentWave = 0;
    private boolean isFinished = false;
    private int cooldown = this.maxCooldown;
    private int breakTime = this.maxBreakTime;
    private int spawnInterval;
    private int spawnCooldown = this.spawnInterval = 60;
    private boolean victory = false;
    private boolean defeat = false;
    private int despawnTicks = 600;
    private boolean result = true;
    private int resultPrize = 1;
    private static final int MAX_ACTIVE_MOBS = 10;
    private static int TOTAL_WAVE_MOBS = 20;
    private static final int MAX_DESPAWN_TICKS = 600;
    private static final int ACTIVE_RADIUS = 64;

    public RaidEntity(EntityType<? extends Entity> type, Level level) {
        super(type, level);
        this.f_19794_ = true;
        this.m_6842_(true);
        GunnerManager gunnerManager = GunnerManager.getInstance();
        this.faction = gunnerManager.getFactionByName(gunnerManager.getRandomFactionName());
        MutableComponent factionLang = Component.m_237115_((String)("faction.jeg." + this.faction.getName()));
        this.bossBar = new ServerBossEvent((Component)Component.m_237115_((String)(factionLang.getString() + " active raid!")), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);
        this.bossBar.m_8321_(true);
    }

    public RaidEntity(EntityType<? extends Entity> type, Level level, Faction faction, boolean forceGuns, int waves, int waveSize) {
        super(type, level);
        this.f_19794_ = true;
        this.m_6842_(true);
        this.faction = faction;
        this.forceGuns = forceGuns;
        this.totalWaves = waves;
        MutableComponent factionLang = Component.m_237115_((String)("faction.jeg." + faction.getName()));
        MutableComponent raidLang = Component.m_237115_((String)"raid.jeg");
        this.bossBar = new ServerBossEvent((Component)Component.m_237115_((String)(factionLang.getString() + " " + raidLang.getString())), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);
        this.bossBar.m_8321_(true);
    }

    private static ItemStack getRandomHorseArmor(RandomSource random) {
        Item[] horseArmors = new Item[]{Items.f_42651_, Items.f_42652_, Items.f_42653_};
        return new ItemStack((ItemLike)horseArmors[random.m_188503_(horseArmors.length)]);
    }

    public void spawnMobs(ServerLevel level, Vec3 startPos, boolean forceGuns, int spread) {
        BlockPos.MutableBlockPos spawnPos = this.m_20183_().m_122032_().m_122184_((12 + this.f_19796_.m_188503_(12)) * (this.f_19796_.m_188499_() ? -1 : 1), 0, (12 + this.f_19796_.m_188503_(12)) * (this.f_19796_.m_188499_() ? -1 : 1));
        if (level.m_151572_(spawnPos.m_123341_() - 10, spawnPos.m_123343_() - 10, spawnPos.m_123341_() + 10, spawnPos.m_123343_() + 10) && this.activeMobs.size() < 10 && this.spawnedMobs.size() < TOTAL_WAVE_MOBS) {
            int mobsToSpawn = this.f_19796_.m_216339_(2, 3);
            for (int i = 0; i < mobsToSpawn && this.activeMobs.size() < 10; ++i) {
                Creeper annoyingBoy;
                Mob mob = ModCommands.getFactionMob(level, this.faction, startPos, forceGuns, spread);
                if (mob == null || !ModCommands.spawnRaider(level, (LivingEntity)mob, null, spawnPos, this.m_20182_(), true)) continue;
                this.activeMobs.add((LivingEntity)mob);
                this.spawnedMobs.add((LivingEntity)mob);
                if (!this.activePlayers.isEmpty() && mob instanceof PathfinderMob) {
                    PathfinderMob pathfinderMob = (PathfinderMob)mob;
                    pathfinderMob.m_6710_((LivingEntity)this.activePlayers.stream().findAny().get());
                }
                if (mob.m_19880_().contains("EliteGunner") && level.f_46441_.m_188499_() && ((Boolean)Config.COMMON.gunnerMobs.horsemen.get()).booleanValue()) {
                    if (mob instanceof Zombie) {
                        ZombieHorse zombieHorse = new ZombieHorse(EntityType.f_20502_, this.m_9236_());
                        zombieHorse.m_146884_(mob.m_20182_());
                        zombieHorse.m_20049_("GunnerPatroller");
                        if (level.f_46441_.m_188503_(3) == 0) {
                            randomHorseArmor = RaidEntity.getRandomHorseArmor(level.f_46441_);
                            zombieHorse.m_8061_(EquipmentSlot.CHEST, randomHorseArmor);
                        }
                        this.m_9236_().m_7967_((Entity)zombieHorse);
                        zombieHorse.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 400));
                        mob.m_20329_((Entity)zombieHorse);
                    } else if (mob instanceof AbstractSkeleton) {
                        SkeletonHorse skeletonHorse = new SkeletonHorse(EntityType.f_20525_, this.m_9236_());
                        skeletonHorse.m_146884_(mob.m_20182_());
                        skeletonHorse.m_20049_("GunnerPatroller");
                        if (level.f_46441_.m_188503_(3) == 0) {
                            randomHorseArmor = RaidEntity.getRandomHorseArmor(level.f_46441_);
                            skeletonHorse.m_8061_(EquipmentSlot.CHEST, randomHorseArmor);
                        }
                        this.m_9236_().m_7967_((Entity)skeletonHorse);
                        skeletonHorse.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 400));
                        mob.m_20329_((Entity)skeletonHorse);
                    } else {
                        Horse horse = new Horse(EntityType.f_20457_, this.m_9236_());
                        horse.m_146884_(mob.m_20182_());
                        horse.m_20049_("GunnerPatroller");
                        if (level.f_46441_.m_188503_(3) == 0) {
                            randomHorseArmor = RaidEntity.getRandomHorseArmor(level.f_46441_);
                            horse.m_8061_(EquipmentSlot.CHEST, randomHorseArmor);
                        }
                        this.m_9236_().m_7967_((Entity)horse);
                        mob.m_20329_((Entity)horse);
                    }
                }
                if (((Boolean)Config.COMMON.gunnerMobs.explosiveMobs.get()).booleanValue() && (double)this.m_9236_().f_46441_.m_188501_() < 0.2) {
                    if (this.m_9236_().f_46441_.m_188499_()) {
                        annoyingBoy = new Creeper(EntityType.f_20558_, this.m_9236_());
                        annoyingBoy.m_146884_(mob.m_20182_());
                        this.activeMobs.add((LivingEntity)annoyingBoy);
                        this.spawnedMobs.add((LivingEntity)annoyingBoy);
                        annoyingBoy.m_20049_("GunnerPatroller");
                        this.m_9236_().m_7967_((Entity)annoyingBoy);
                        if (!this.activePlayers.isEmpty()) {
                            annoyingBoy.m_6710_((LivingEntity)this.activePlayers.stream().findAny().get());
                        }
                    } else if (this.m_9236_().f_46441_.m_188499_()) {
                        annoyingBoy = new Phantom(EntityType.f_20509_, this.m_9236_());
                        annoyingBoy.m_146884_(mob.m_20182_());
                        this.activeMobs.add((LivingEntity)annoyingBoy);
                        this.spawnedMobs.add((LivingEntity)annoyingBoy);
                        annoyingBoy.m_20049_("GunnerPatroller");
                        this.m_9236_().m_7967_((Entity)annoyingBoy);
                        explosiveChargeEntity = new ThrowableExplosiveChargeEntity((EntityType<? extends ThrowableGrenadeEntity>)((EntityType)ModEntities.THROWABLE_EXPLOSIVE_CHARGE.get()), (Level)level);
                        this.m_9236_().m_7967_((Entity)explosiveChargeEntity);
                        explosiveChargeEntity.m_20329_((Entity)annoyingBoy);
                        if (!this.activePlayers.isEmpty()) {
                            annoyingBoy.m_6710_((LivingEntity)this.activePlayers.stream().findAny().get());
                        }
                    } else {
                        annoyingBoy = new Silverfish(EntityType.f_20523_, this.m_9236_());
                        annoyingBoy.m_146884_(mob.m_20182_());
                        annoyingBoy.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 200, 0));
                        this.activeMobs.add((LivingEntity)annoyingBoy);
                        this.spawnedMobs.add((LivingEntity)annoyingBoy);
                        annoyingBoy.m_20049_("GunnerPatroller");
                        this.m_9236_().m_7967_((Entity)annoyingBoy);
                        explosiveChargeEntity = new ThrowableExplosiveChargeEntity((EntityType<? extends ThrowableGrenadeEntity>)((EntityType)ModEntities.THROWABLE_EXPLOSIVE_CHARGE.get()), (Level)level);
                        this.m_9236_().m_7967_((Entity)explosiveChargeEntity);
                        explosiveChargeEntity.m_20329_((Entity)annoyingBoy);
                        if (!this.activePlayers.isEmpty()) {
                            annoyingBoy.m_6710_((LivingEntity)this.activePlayers.stream().findAny().get());
                        }
                    }
                }
                if (!((Boolean)Config.COMMON.gunnerMobs.raidSupportMobs.get()).booleanValue()) continue;
                if ((double)this.m_9236_().f_46441_.m_188501_() < 0.3 && mob.m_6095_().m_204039_(ModTags.Entities.UNDEAD)) {
                    annoyingBoy = new Phantom(EntityType.f_20509_, this.m_9236_());
                    annoyingBoy.m_146884_(mob.m_20182_().m_82520_(0.0, 10.0, 0.0));
                    this.activeMobs.add((LivingEntity)annoyingBoy);
                    this.spawnedMobs.add((LivingEntity)annoyingBoy);
                    annoyingBoy.m_20049_("GunnerPatroller");
                    if (level.m_46461_() && annoyingBoy.m_6095_().m_204039_(ModTags.Entities.UNDEAD)) {
                        annoyingBoy.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 1200, 0, false, true));
                        annoyingBoy.m_252836_();
                    }
                    this.m_9236_().m_7967_((Entity)annoyingBoy);
                    if (!this.activePlayers.isEmpty()) {
                        annoyingBoy.m_6710_((LivingEntity)this.activePlayers.stream().findAny().get());
                    }
                }
                if (!((double)this.m_9236_().f_46441_.m_188501_() < 0.2) || !(mob instanceof AbstractIllager)) continue;
                if (this.m_9236_().f_46441_.m_188499_()) {
                    annoyingBoy = new Witch(EntityType.f_20495_, this.m_9236_());
                    annoyingBoy.m_146884_(mob.m_20182_());
                    this.activeMobs.add((LivingEntity)annoyingBoy);
                    this.spawnedMobs.add((LivingEntity)annoyingBoy);
                    annoyingBoy.m_20049_("GunnerPatroller");
                    this.m_9236_().m_7967_((Entity)annoyingBoy);
                    if (this.activePlayers.isEmpty()) continue;
                    annoyingBoy.m_6710_((LivingEntity)this.activePlayers.stream().findAny().get());
                    continue;
                }
                annoyingBoy = new Evoker(EntityType.f_20568_, this.m_9236_());
                annoyingBoy.m_146884_(mob.m_20182_());
                this.activeMobs.add((LivingEntity)annoyingBoy);
                this.spawnedMobs.add((LivingEntity)annoyingBoy);
                annoyingBoy.m_20049_("GunnerPatroller");
                this.m_9236_().m_7967_((Entity)annoyingBoy);
                if (this.activePlayers.isEmpty()) continue;
                annoyingBoy.m_6710_((LivingEntity)this.activePlayers.stream().findAny().get());
            }
        }
        if (this.activeMobs.size() >= 10 || this.spawnedMobs.size() >= TOTAL_WAVE_MOBS) {
            this.isSpawningMobs = false;
        }
    }

    public void waveIterator() {
        if (this.currentWave < this.totalWaves) {
            for (Player player : this.activePlayers) {
                this.bossBar.m_6543_((ServerPlayer)player);
            }
            this.inWave = true;
            this.isSpawningMobs = true;
            ++this.currentWave;
            this.playHorn();
        }
    }

    public void playHorn() {
        int x = this.m_9236_().f_46441_.m_216339_(-25, 25);
        int z = this.m_9236_().f_46441_.m_216339_(-25, 25);
        this.m_9236_().m_5594_(null, BlockPos.m_274446_((Position)this.m_20182_().m_82520_((double)x, 32.0, (double)z)), (SoundEvent)((Holder.Reference)SoundEvents.f_215702_.get(0)).get(), SoundSource.HOSTILE, 1000.0f, 1.0f);
    }

    public void playCelebrationHorn() {
        int x = this.m_9236_().f_46441_.m_216339_(-25, 25);
        int z = this.m_9236_().f_46441_.m_216339_(-25, 25);
        SoundEvent sound = this.m_9236_().f_46441_.m_188499_() ? (SoundEvent)((Holder.Reference)SoundEvents.f_215702_.get(0)).get() : (SoundEvent)((Holder.Reference)SoundEvents.f_215702_.get(1)).get();
        this.m_9236_().m_5594_(null, BlockPos.m_274446_((Position)this.m_20182_().m_82520_((double)x, 32.0, (double)z)), sound, SoundSource.HOSTILE, 1000.0f, 1.0f);
    }

    public boolean isWaveComplete() {
        if (this.spawningWave) {
            return false;
        }
        return this.activeMobs.isEmpty() && this.spawnedMobs.size() >= TOTAL_WAVE_MOBS;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public boolean isInWave() {
        return this.inWave;
    }

    public int getCurrentWave() {
        return this.currentWave;
    }

    public HashSet<LivingEntity> getActiveMobs() {
        return this.activeMobs;
    }

    public HashSet<Player> getActivePlayers() {
        return this.activePlayers;
    }

    private void updateBossBar() {
        if (this.isFinished) {
            this.bossBar.m_8321_(false);
            this.bossBar.m_7706_();
            return;
        }
        int remainingMobs = TOTAL_WAVE_MOBS - this.spawnedMobs.size();
        float progress = (float)remainingMobs / (float)TOTAL_WAVE_MOBS;
        this.bossBar.m_142711_(progress);
        MutableComponent factionLang = Component.m_237115_((String)("faction.jeg." + this.faction.getName()));
        MutableComponent raidLang = Component.m_237115_((String)"raid.jeg");
        MutableComponent waveLang = Component.m_237115_((String)"raid.jeg.wave");
        this.bossBar.m_6456_((Component)Component.m_237115_((String)(factionLang.getString() + " " + raidLang.getString() + " | " + waveLang.getString() + " : " + this.currentWave + "/" + this.totalWaves)));
    }

    private void updatePlayers() {
        AABB playerBox = this.m_20191_();
        AABB inflatedBox = playerBox.m_82377_(64.0, 64.0, 64.0);
        List nearbyPlayers = this.m_9236_().m_45976_(Player.class, inflatedBox);
        for (Player player2 : nearbyPlayers) {
            if (this.activePlayers.contains(player2)) continue;
            this.activePlayers.add(player2);
            System.out.println("Player entered: " + player2.m_7755_().getString());
        }
        this.activePlayers.removeIf(player -> !nearbyPlayers.contains(player) || player.m_21224_());
    }

    private void waveReward(Player player, ServerLevel serverLevel) {
        ResourceLocation lootTableID = new ResourceLocation("jeg", "factions/raids/generic_raid_wave_reward");
        LootTable lootTable = serverLevel.m_7654_().m_278653_().m_278676_(lootTableID);
        LootParams lootParams = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81455_, (Object)player).m_287286_(LootContextParams.f_81460_, (Object)player.m_20182_()).m_287235_(LootContextParamSets.f_81411_);
        for (int i = 0; i < 1; ++i) {
            ObjectArrayList loot = lootTable.m_287195_(lootParams);
            for (ItemStack itemStack : loot) {
                if (player.m_150109_().m_36054_(itemStack)) continue;
                player.m_36176_(itemStack, false);
            }
        }
    }

    private void victoryReward(Player player, ServerLevel serverLevel) {
        ResourceLocation lootTableID = new ResourceLocation("jeg", "factions/raids/generic_raid_victory_reward");
        LootTable lootTable = serverLevel.m_7654_().m_278653_().m_278676_(lootTableID);
        LootParams lootParams = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81455_, (Object)player).m_287286_(LootContextParams.f_81460_, (Object)player.m_20182_()).m_287235_(LootContextParamSets.f_81411_);
        for (int i = 0; i < 1; ++i) {
            ObjectArrayList loot = lootTable.m_287195_(lootParams);
            for (ItemStack itemStack : loot) {
                if (player.m_150109_().m_36054_(itemStack)) continue;
                player.m_36176_(itemStack, false);
            }
        }
        ResourceLocation lootTableID2 = new ResourceLocation("jeg", "factions/raids/" + this.faction.getName() + "/victory_reward");
        LootTable lootTable2 = serverLevel.m_7654_().m_278653_().m_278676_(lootTableID2);
        LootParams lootParams2 = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81455_, (Object)player).m_287286_(LootContextParams.f_81460_, (Object)player.m_20182_()).m_287235_(LootContextParamSets.f_81411_);
        for (int i = 0; i < 1; ++i) {
            ObjectArrayList loot = lootTable2.m_287195_(lootParams2);
            for (ItemStack itemStack : loot) {
                if (player.m_150109_().m_36054_(itemStack)) continue;
                player.m_36176_(itemStack, false);
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_ && !this.isFinished) {
            this.summonParticleRing();
        }
        if (!this.m_9236_().f_46443_) {
            this.activeMobs.removeIf(mob -> mob.m_213877_() || !mob.m_6084_() || mob.m_21224_());
            this.updateBossBar();
            this.updatePlayers();
            if (this.getActivePlayers().isEmpty() || this.m_9236_().m_46791_().equals((Object)Difficulty.PEACEFUL)) {
                this.isFinished = true;
                this.defeat = true;
            }
            if (this.currentWave >= this.totalWaves && this.isWaveComplete()) {
                this.isFinished = true;
            }
            if (this.breakTime > 0 && this.currentWave != 0 && this.f_19797_ % 5 == 0) {
                FireworkRocketEntity firework = new FireworkRocketEntity(this.m_9236_(), ServerPlayHandler.getFireworkStack(this.f_19796_.m_188499_(), false, this.f_19796_.m_216339_(0, 3), 3), this.m_20185_() + (double)this.f_19796_.m_216339_(-32, 32), this.m_20186_() + (double)this.f_19796_.m_216339_(0, 3), this.m_20189_() + (double)this.f_19796_.m_216339_(-32, 32), false);
                this.m_9236_().m_7967_((Entity)firework);
            }
            if (this.justFinishedWave) {
                for (Player player : this.activePlayers) {
                    MutableComponent message = Component.m_237115_((String)"broadcast.jeg.raid.next_wave");
                    player.m_213846_((Component)message);
                    this.waveReward(player, (ServerLevel)player.m_9236_());
                }
                this.justFinishedWave = false;
            }
            if (!this.isFinished) {
                if (this.isSpawningMobs) {
                    --this.spawnCooldown;
                    if (this.spawnCooldown <= 0) {
                        this.spawnMobs((ServerLevel)this.m_9236_(), this.m_20182_(), this.forceGuns, 10);
                        this.spawnCooldown = this.spawnInterval;
                    }
                }
                if (!this.inWave) {
                    if (this.spawningWave) {
                        float progress = 1.0f - (float)this.cooldown / (float)this.maxCooldown;
                        this.bossBar.m_142711_(progress);
                        if (this.currentWave != 0 && this.breakTime == this.maxBreakTime) {
                            this.justFinishedWave = true;
                        }
                        --this.breakTime;
                        if (this.breakTime <= 0) {
                            --this.cooldown;
                            if (this.cooldown <= 0) {
                                this.waveIterator();
                                this.inWave = true;
                                this.spawningWave = false;
                            }
                        }
                    } else {
                        if (this.currentWave < this.totalWaves) {
                            this.spawningWave = true;
                        }
                        this.cooldown = this.maxCooldown;
                        this.breakTime = this.maxBreakTime;
                    }
                } else if (this.activeMobs.size() < 10 && this.spawnedMobs.size() < TOTAL_WAVE_MOBS) {
                    this.isSpawningMobs = true;
                }
                if (this.getActiveMobs().size() < 10 && this.spawnedMobs.size() > TOTAL_WAVE_MOBS - TOTAL_WAVE_MOBS / 5) {
                    for (LivingEntity livingEntity : this.getActiveMobs()) {
                        livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 3600, 0, false, false));
                    }
                }
            }
            if (this.isWaveComplete()) {
                if (this.currentWave >= this.totalWaves) {
                    this.victory = true;
                }
                this.inWave = false;
                this.cooldown = this.maxCooldown;
                this.breakTime = this.maxBreakTime;
                this.spawnedMobs.clear();
                this.activeMobs.clear();
            }
            if (this.isFinished) {
                if (this.resultPrize > 0) {
                    if (this.victory) {
                        MutableComponent message = Component.m_237110_((String)"broadcast.jeg.raid.victory", (Object[])new Object[]{Component.m_237115_((String)("faction.jeg." + this.faction.getName()))}).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.GOLD);
                        ((ServerLevel)this.m_9236_()).m_7654_().m_6846_().m_240416_((Component)message, false);
                        for (Player player : this.activePlayers) {
                            this.victoryReward(player, (ServerLevel)player.m_9236_());
                        }
                        --this.resultPrize;
                    }
                    if (this.defeat) {
                        for (LivingEntity livingEntity : this.getActiveMobs()) {
                            livingEntity.m_21195_(MobEffects.f_19619_);
                        }
                        MutableComponent message2 = Component.m_237110_((String)"broadcast.jeg.raid.no_players", (Object[])new Object[]{Component.m_237115_((String)("faction.jeg." + this.faction.getName()))}).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.RED);
                        ((ServerLevel)this.m_9236_()).m_7654_().m_6846_().m_240416_((Component)message2, false);
                        MutableComponent mutableComponent = Component.m_237110_((String)"broadcast.jeg.raid.defeat", (Object[])new Object[]{Component.m_237115_((String)("faction.jeg." + this.faction.getName()))}).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.RED);
                        ((ServerLevel)this.m_9236_()).m_7654_().m_6846_().m_240416_((Component)mutableComponent, false);
                        --this.resultPrize;
                    }
                }
                if (this.victory && this.f_19797_ % 5 == 0) {
                    FireworkRocketEntity firework = new FireworkRocketEntity(this.m_9236_(), ServerPlayHandler.getFireworkStack(this.f_19796_.m_188499_(), false, this.f_19796_.m_216339_(0, 3), 3), this.m_20185_() + (double)this.f_19796_.m_216339_(-64, 64), this.m_20186_() + (double)this.f_19796_.m_216339_(0, 3), this.m_20189_() + (double)this.f_19796_.m_216339_(-64, 64), false);
                    this.m_9236_().m_7967_((Entity)firework);
                }
                if (this.defeat && this.f_19797_ % 80 == 0) {
                    this.playCelebrationHorn();
                }
                ((ServerLevel)this.m_9236_()).m_8606_(12000, 0, false, false);
                --this.despawnTicks;
                if (this.despawnTicks < 0) {
                    this.bossBar.m_8321_(false);
                    this.bossBar.m_7706_();
                    this.m_146870_();
                }
            }
        }
    }

    public void onRemovedFromWorld() {
        Level level;
        if (!this.victory && !this.defeat && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            MutableComponent message2 = Component.m_237110_((String)"broadcast.jeg.raid.no_players", (Object[])new Object[]{Component.m_237115_((String)("faction.jeg." + this.faction.getName()))}).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.RED);
            serverLevel.m_7654_().m_6846_().m_240416_((Component)message2, false);
            MutableComponent message = Component.m_237110_((String)"broadcast.jeg.raid.defeat", (Object[])new Object[]{Component.m_237115_((String)("faction.jeg." + this.faction.getName()))}).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.RED);
            serverLevel.m_7654_().m_6846_().m_240416_((Component)message, false);
        }
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compoundTag) {
    }

    protected void m_7380_(CompoundTag compoundTag) {
    }

    public static void summonRaidEntity(ServerLevel level, Faction faction, Vec3 startPos, boolean forceGuns) {
        RaidEntity raidEntity = new RaidEntity((EntityType<? extends Entity>)((EntityType)ModEntities.RAID_ENTITY.get()), (Level)level);
        raidEntity.m_146884_(startPos);
        raidEntity.faction = faction;
        if ((double)raidEntity.m_9236_().f_46441_.m_188501_() < 0.3) {
            level.m_8606_(0, 12000, true, true);
        }
        level.m_7967_((Entity)raidEntity);
        MutableComponent message = Component.m_237110_((String)"broadcast.jeg.raid", (Object[])new Object[]{Component.m_237115_((String)("faction.jeg." + raidEntity.faction.getName())), BlockPos.m_274446_((Position)startPos)}).m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.BOLD);
        level.m_7654_().m_6846_().m_240416_((Component)message, false);
    }

    public ServerBossEvent getBossBar() {
        return this.bossBar;
    }

    private void summonParticleRing() {
        for (int i = 0; i < 360; ++i) {
            double angle = Math.toRadians(i);
            double xOffset = Math.cos(angle) * 64.0;
            double zOffset = Math.sin(angle) * 64.0;
            this.m_9236_().m_7106_((ParticleOptions)ModParticleTypes.ENTITY_LASER.get(), this.m_20185_() + xOffset, this.m_20186_() + 5.0, this.m_20189_() + zOffset, 0.0, 0.0, 0.0);
        }
    }
}

