/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.modifier;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import ttv.migami.jeg.modifier.Modifier;
import ttv.migami.jeg.modifier.ModifierRegistry;

public class ModifierHelper {
    private static final Random RANDOM = new Random();

    public static Modifier getRandomGroup() {
        ArrayList<Modifier> groups = new ArrayList<Modifier>(ModifierRegistry.getAll());
        Collections.shuffle(groups, RANDOM);
        float totalWeight = 0.0f;
        for (Modifier group : groups) {
            totalWeight += group.getChance();
        }
        float randomValue = RANDOM.nextFloat() * totalWeight;
        float cumulativeWeight = 0.0f;
        for (Modifier group : groups) {
            if (!(randomValue <= (cumulativeWeight += group.getChance()))) continue;
            return group;
        }
        return groups.stream().findFirst().orElse(null);
    }

    public static Modifier getGroupByName(String name) {
        for (Modifier group : ModifierRegistry.getAll()) {
            if (!group.getName().equalsIgnoreCase(name)) continue;
            return group;
        }
        return null;
    }
}

