/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import ttv.migami.jeg.init.ModParticleTypes;

public class ColoredFlareData
implements ParticleOptions {
    public static final Codec<ColoredFlareData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("r").forGetter(d -> d.r), (App)Codec.INT.fieldOf("g").forGetter(d -> d.g), (App)Codec.INT.fieldOf("b").forGetter(d -> d.b)).apply((Applicative)instance, ColoredFlareData::new));
    public static final ParticleOptions.Deserializer<ColoredFlareData> DESERIALIZER = new ParticleOptions.Deserializer<ColoredFlareData>(){

        public ColoredFlareData fromCommand(ParticleType<ColoredFlareData> type, StringReader reader) throws CommandSyntaxException {
            int r = reader.readInt();
            reader.expect(' ');
            int g = reader.readInt();
            reader.expect(' ');
            int b = reader.readInt();
            return new ColoredFlareData(r, g, b);
        }

        public ColoredFlareData fromNetwork(ParticleType<ColoredFlareData> type, FriendlyByteBuf buf) {
            return new ColoredFlareData(buf.readInt(), buf.readInt(), buf.readInt());
        }
    };
    private final int r;
    private final int g;
    private final int b;

    public ColoredFlareData(int r, int g, int b) {
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public ParticleType<?> m_6012_() {
        return (ParticleType)ModParticleTypes.COLORED_FLARE_SMOKE.get();
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeInt(this.r);
        buffer.writeInt(this.g);
        buffer.writeInt(this.b);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%d %d %d", this.r, this.g, this.b);
    }

    public int getR() {
        return this.r;
    }

    public int getG() {
        return this.g;
    }

    public int getB() {
        return this.b;
    }
}

