/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;
import ttv.migami.jeg.init.ModParticleTypes;

public class LaserData
implements ParticleOptions {
    public static final Codec<LaserData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("dir").forGetter(data -> data.direction.ordinal()), (App)Codec.LONG.fieldOf("pos").forGetter(p_239806_0_ -> p_239806_0_.pos.m_121878_())).apply((Applicative)builder, LaserData::new));
    public static final ParticleOptions.Deserializer<LaserData> DESERIALIZER = new ParticleOptions.Deserializer<LaserData>(){

        public LaserData fromCommand(ParticleType<LaserData> particleType, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            int dir = reader.readInt();
            reader.expect(' ');
            long pos = reader.readLong();
            return new LaserData(dir, pos);
        }

        public LaserData fromNetwork(ParticleType<LaserData> particleType, FriendlyByteBuf buffer) {
            return new LaserData(buffer.readInt(), buffer.readLong());
        }
    };
    private final Direction direction;
    private final BlockPos pos;

    public LaserData(int dir, long pos) {
        this.direction = Direction.values()[dir];
        this.pos = BlockPos.m_122022_((long)pos);
    }

    public LaserData(Direction dir, BlockPos pos) {
        this.direction = dir;
        this.pos = pos;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public ParticleType<?> m_6012_() {
        return (ParticleType)ModParticleTypes.LASER.get();
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.direction);
        buffer.m_130064_(this.pos);
    }

    public String m_5942_() {
        return ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()) + " " + this.direction.m_122433_();
    }

    public static Codec<LaserData> codec(ParticleType<LaserData> type) {
        return CODEC;
    }
}

