/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.client;

import com.mrcrayfish.framework.network.message.IMessage;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.MouseSettingsScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import ttv.migami.jeg.JustEnoughGuns;
import ttv.migami.jeg.client.CustomGunManager;
import ttv.migami.jeg.client.GunButtonBindings;
import ttv.migami.jeg.client.KeyBinds;
import ttv.migami.jeg.client.handler.AimingHandler;
import ttv.migami.jeg.client.handler.BulletTrailRenderingHandler;
import ttv.migami.jeg.client.handler.ControllerHandler;
import ttv.migami.jeg.client.handler.CrosshairHandler;
import ttv.migami.jeg.client.handler.GunRenderingHandler;
import ttv.migami.jeg.client.handler.PlayerModelHandler;
import ttv.migami.jeg.client.handler.RecoilHandler;
import ttv.migami.jeg.client.handler.ReloadHandler;
import ttv.migami.jeg.client.handler.ShootingHandler;
import ttv.migami.jeg.client.handler.SoundHandler;
import ttv.migami.jeg.client.render.gun.ModelOverrides;
import ttv.migami.jeg.client.render.gun.model.AssaultRifleModel;
import ttv.migami.jeg.client.render.gun.model.AtlanteanSpearModel;
import ttv.migami.jeg.client.render.gun.model.BlossomRifleModel;
import ttv.migami.jeg.client.render.gun.model.BoltActionRifleModel;
import ttv.migami.jeg.client.render.gun.model.BurstRifleModel;
import ttv.migami.jeg.client.render.gun.model.CombatRifleModel;
import ttv.migami.jeg.client.render.gun.model.CustomSMGModel;
import ttv.migami.jeg.client.render.gun.model.DoubleBarrelShotgunModel;
import ttv.migami.jeg.client.render.gun.model.HolyShotgunModel;
import ttv.migami.jeg.client.render.gun.model.PumpShotgunModel;
import ttv.migami.jeg.client.render.gun.model.RevolverModel;
import ttv.migami.jeg.client.render.gun.model.SemiAutoRifleModel;
import ttv.migami.jeg.client.render.gun.model.TyphooneeModel;
import ttv.migami.jeg.client.render.gun.model.WaterpipeShotgunModel;
import ttv.migami.jeg.client.screen.AttachmentScreen;
import ttv.migami.jeg.client.screen.GunmetalWorkbenchScreen;
import ttv.migami.jeg.client.screen.GunniteWorkbenchScreen;
import ttv.migami.jeg.client.screen.RecyclerScreen;
import ttv.migami.jeg.client.screen.ScrapWorkbenchScreen;
import ttv.migami.jeg.client.util.PropertyHelper;
import ttv.migami.jeg.debug.IEditorMenu;
import ttv.migami.jeg.debug.client.screen.EditorScreen;
import ttv.migami.jeg.enchantment.EnchantmentTypes;
import ttv.migami.jeg.init.ModBlocks;
import ttv.migami.jeg.init.ModContainers;
import ttv.migami.jeg.init.ModItems;
import ttv.migami.jeg.item.GunItem;
import ttv.migami.jeg.item.IColored;
import ttv.migami.jeg.item.attachment.IAttachment;
import ttv.migami.jeg.network.PacketHandler;
import ttv.migami.jeg.network.message.C2SMessageAttachments;

@Mod.EventBusSubscriber(modid="jeg", value={Dist.CLIENT})
public class ClientHandler {
    private static Field mouseOptionsField;

    public static void setup() {
        MinecraftForge.EVENT_BUS.register((Object)AimingHandler.get());
        MinecraftForge.EVENT_BUS.register((Object)BulletTrailRenderingHandler.get());
        MinecraftForge.EVENT_BUS.register((Object)CrosshairHandler.get());
        MinecraftForge.EVENT_BUS.register((Object)GunRenderingHandler.get());
        MinecraftForge.EVENT_BUS.register((Object)RecoilHandler.get());
        MinecraftForge.EVENT_BUS.register((Object)ReloadHandler.get());
        MinecraftForge.EVENT_BUS.register((Object)ShootingHandler.get());
        MinecraftForge.EVENT_BUS.register((Object)SoundHandler.get());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerModelHandler());
        if (JustEnoughGuns.controllableLoaded) {
            MinecraftForge.EVENT_BUS.register((Object)new ControllerHandler());
            GunButtonBindings.register();
        }
        ClientHandler.setupRenderLayers();
        ClientHandler.registerColors();
        ClientHandler.registerModelOverrides();
        ClientHandler.registerScreenFactories();
    }

    private static void setupRenderLayers() {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.SCRAP_WORKBENCH.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.GUNMETAL_WORKBENCH.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.GUNNITE_WORKBENCH.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.RECYCLER.get()), (RenderType)RenderType.m_110463_());
    }

    private static void registerColors() {
        ItemColor color = (stack, index) -> {
            ItemStack renderingWeapon;
            if (!IColored.isDyeable(stack)) {
                return -1;
            }
            if (index == 0 && stack.m_41782_() && stack.m_41783_().m_128425_("Color", 3)) {
                return stack.m_41783_().m_128451_("Color");
            }
            if (index == 0 && stack.m_41720_() instanceof IAttachment && (renderingWeapon = GunRenderingHandler.get().getRenderingWeapon()) != null) {
                return Minecraft.m_91087_().getItemColors().m_92676_(renderingWeapon, index);
            }
            if (index == 2) {
                return PropertyHelper.getReticleColor(stack);
            }
            return -1;
        };
        ForgeRegistries.ITEMS.forEach(item -> {
            if (item instanceof IColored) {
                Minecraft.m_91087_().getItemColors().m_92689_(color, new ItemLike[]{item});
            }
        });
    }

    private static void registerModelOverrides() {
        ModelOverrides.register((Item)ModItems.COMBAT_RIFLE.get(), new CombatRifleModel());
        ModelOverrides.register((Item)ModItems.ASSAULT_RIFLE.get(), new AssaultRifleModel());
        ModelOverrides.register((Item)ModItems.REVOLVER.get(), new RevolverModel());
        ModelOverrides.register((Item)ModItems.WATERPIPE_SHOTGUN.get(), new WaterpipeShotgunModel());
        ModelOverrides.register((Item)ModItems.SEMI_AUTO_RIFLE.get(), new SemiAutoRifleModel());
        ModelOverrides.register((Item)ModItems.BURST_RIFLE.get(), new BurstRifleModel());
        ModelOverrides.register((Item)ModItems.PUMP_SHOTGUN.get(), new PumpShotgunModel());
        ModelOverrides.register((Item)ModItems.BOLT_ACTION_RIFLE.get(), new BoltActionRifleModel());
        ModelOverrides.register((Item)ModItems.CUSTOM_SMG.get(), new CustomSMGModel());
        ModelOverrides.register((Item)ModItems.BLOSSOM_RIFLE.get(), new BlossomRifleModel());
        ModelOverrides.register((Item)ModItems.DOUBLE_BARREL_SHOTGUN.get(), new DoubleBarrelShotgunModel());
        ModelOverrides.register((Item)ModItems.HOLY_SHOTGUN.get(), new HolyShotgunModel());
        ModelOverrides.register((Item)ModItems.ATLANTEAN_SPEAR.get(), new AtlanteanSpearModel());
        ModelOverrides.register((Item)ModItems.TYPHOONEE.get(), new TyphooneeModel());
    }

    private static void registerScreenFactories() {
        MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.GUNNITE_WORKBENCH.get()), GunniteWorkbenchScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.SCRAP_WORKBENCH.get()), ScrapWorkbenchScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.GUNMETAL_WORKBENCH.get()), GunmetalWorkbenchScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.ATTACHMENTS.get()), AttachmentScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.RECYCLER.get()), RecyclerScreen::new);
    }

    @SubscribeEvent
    public static void onScreenInit(ScreenEvent.Init.Post event) {
        if (event.getScreen() instanceof MouseSettingsScreen) {
            MouseSettingsScreen screen = (MouseSettingsScreen)event.getScreen();
            if (mouseOptionsField == null) {
                mouseOptionsField = ObfuscationReflectionHelper.findField(MouseSettingsScreen.class, (String)"f_96218_");
                mouseOptionsField.setAccessible(true);
            }
            try {
                OptionsList optionsList = (OptionsList)mouseOptionsField.get(screen);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void onKeyPressed(InputEvent.Key event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && mc.f_91080_ == null && event.getAction() == 1 && KeyBinds.KEY_ATTACHMENTS.m_90857_()) {
            PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageAttachments());
        }
    }

    public static void onRegisterReloadListener(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)((ResourceManagerReloadListener)manager -> PropertyHelper.resetCache()));
    }

    public static void registerAdditional(ModelEvent.RegisterAdditional event) {
        event.register(new ResourceLocation("jeg", "special/test"));
    }

    public static void onRegisterCreativeTab(CreativeModeTabEvent.Register event) {
        event.registerCreativeModeTab(new ResourceLocation("jeg", "creative_tab"), builder -> {
            builder.m_257941_((Component)Component.m_237115_((String)"itemGroup.jeg"));
            builder.m_257737_(() -> {
                ItemStack stack = new ItemStack((ItemLike)ModItems.ASSAULT_RIFLE.get());
                stack.m_41784_().m_128379_("IgnoreAmmo", true);
                return stack;
            });
            builder.m_257501_((flags, output) -> {
                ModItems.REGISTER.getEntries().forEach(registryObject -> {
                    Object patt9677$temp = registryObject.get();
                    if (patt9677$temp instanceof GunItem) {
                        GunItem item = (GunItem)patt9677$temp;
                        ItemStack stack = new ItemStack((ItemLike)item);
                        stack.m_41784_().m_128405_("AmmoCount", item.getGun().getReloads().getMaxAmmo());
                        output.m_246342_(stack);
                        return;
                    }
                    output.m_246326_((ItemLike)registryObject.get());
                });
                CustomGunManager.fill(output);
                for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS) {
                    if (enchantment.f_44672_ != EnchantmentTypes.GUN && enchantment.f_44672_ != EnchantmentTypes.SEMI_AUTO_GUN) continue;
                    output.m_246267_(EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(enchantment, enchantment.m_6586_())), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
                }
            });
        });
    }

    public static Screen createEditorScreen(IEditorMenu menu) {
        return new EditorScreen(Minecraft.m_91087_().f_91080_, menu);
    }
}

