/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.client.render.pose;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;
import ttv.migami.jeg.Config;
import ttv.migami.jeg.client.handler.ReloadHandler;
import ttv.migami.jeg.client.render.pose.AimPose;
import ttv.migami.jeg.client.render.pose.LimbPose;
import ttv.migami.jeg.client.render.pose.WeaponPose;
import ttv.migami.jeg.client.util.RenderUtil;
import ttv.migami.jeg.common.GripType;

public class TwoHandedPose
extends WeaponPose {
    @Override
    protected AimPose getUpPose() {
        AimPose upPose = new AimPose();
        upPose.getIdle().setRenderYawOffset(45.0f).setItemRotation(new Vector3f(60.0f, 0.0f, 10.0f)).setRightArm(new LimbPose().setRotationAngleX(-120.0f).setRotationAngleY(-55.0f).setRotationPointX(-5.0f).setRotationPointY(3.0f).setRotationPointZ(0.0f)).setLeftArm(new LimbPose().setRotationAngleX(-160.0f).setRotationAngleY(-20.0f).setRotationAngleZ(-30.0f).setRotationPointY(2.0f).setRotationPointZ(-1.0f));
        upPose.getAiming().setRenderYawOffset(45.0f).setItemRotation(new Vector3f(40.0f, 0.0f, 30.0f)).setItemTranslate(new Vector3f(-1.0f, 0.0f, 0.0f)).setRightArm(new LimbPose().setRotationAngleX(-140.0f).setRotationAngleY(-55.0f).setRotationPointX(-5.0f).setRotationPointY(3.0f).setRotationPointZ(0.0f)).setLeftArm(new LimbPose().setRotationAngleX(-170.0f).setRotationAngleY(-20.0f).setRotationAngleZ(-35.0f).setRotationPointY(1.0f).setRotationPointZ(0.0f));
        return upPose;
    }

    @Override
    protected AimPose getForwardPose() {
        AimPose forwardPose = new AimPose();
        forwardPose.getIdle().setRenderYawOffset(45.0f).setItemRotation(new Vector3f(30.0f, -11.0f, 0.0f)).setRightArm(new LimbPose().setRotationAngleX(-60.0f).setRotationAngleY(-55.0f).setRotationAngleZ(0.0f).setRotationPointX(-5.0f).setRotationPointY(2.0f).setRotationPointZ(1.0f)).setLeftArm(new LimbPose().setRotationAngleX(-65.0f).setRotationAngleY(-10.0f).setRotationAngleZ(5.0f).setRotationPointY(2.0f).setRotationPointZ(-1.0f));
        forwardPose.getAiming().setRenderYawOffset(45.0f).setItemRotation(new Vector3f(5.0f, -21.0f, 0.0f)).setRightArm(new LimbPose().setRotationAngleX(-85.0f).setRotationAngleY(-65.0f).setRotationAngleZ(0.0f).setRotationPointX(-5.0f).setRotationPointY(2.0f)).setLeftArm(new LimbPose().setRotationAngleX(-90.0f).setRotationAngleY(-15.0f).setRotationAngleZ(0.0f).setRotationPointY(2.0f).setRotationPointZ(0.0f));
        return forwardPose;
    }

    @Override
    protected AimPose getDownPose() {
        AimPose downPose = new AimPose();
        downPose.getIdle().setRenderYawOffset(45.0f).setItemRotation(new Vector3f(-15.0f, -5.0f, 0.0f)).setItemTranslate(new Vector3f(0.0f, -0.5f, 0.5f)).setRightArm(new LimbPose().setRotationAngleX(-30.0f).setRotationAngleY(-65.0f).setRotationAngleZ(0.0f).setRotationPointX(-5.0f).setRotationPointY(2.0f)).setLeftArm(new LimbPose().setRotationAngleX(-5.0f).setRotationAngleY(-20.0f).setRotationAngleZ(20.0f).setRotationPointY(5.0f).setRotationPointZ(0.0f));
        downPose.getAiming().setRenderYawOffset(45.0f).setItemRotation(new Vector3f(-20.0f, -5.0f, -10.0f)).setItemTranslate(new Vector3f(0.0f, -0.5f, 1.0f)).setRightArm(new LimbPose().setRotationAngleX(-30.0f).setRotationAngleY(-65.0f).setRotationAngleZ(0.0f).setRotationPointX(-5.0f).setRotationPointY(1.0f)).setLeftArm(new LimbPose().setRotationAngleX(-10.0f).setRotationAngleY(-20.0f).setRotationAngleZ(30.0f).setRotationPointY(5.0f).setRotationPointZ(0.0f));
        return downPose;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void applyPlayerModelRotation(Player player, ModelPart rightArm, ModelPart leftArm, ModelPart head, InteractionHand hand, float aimProgress) {
        if (((Boolean)Config.CLIENT.display.oldAnimations.get()).booleanValue()) {
            Minecraft mc = Minecraft.m_91087_();
            boolean right = mc.f_91066_.m_232107_().m_231551_() == HumanoidArm.RIGHT ? hand == InteractionHand.MAIN_HAND : hand == InteractionHand.OFF_HAND;
            ModelPart mainArm = right ? rightArm : leftArm;
            ModelPart secondaryArm = right ? leftArm : rightArm;
            mainArm.f_104203_ = head.f_104203_;
            mainArm.f_104204_ = head.f_104204_;
            mainArm.f_104205_ = head.f_104205_;
            secondaryArm.f_104203_ = head.f_104203_;
            secondaryArm.f_104204_ = head.f_104204_;
            secondaryArm.f_104205_ = head.f_104205_;
            mainArm.f_104203_ = (float)Math.toRadians(-55.0f + aimProgress * -30.0f);
            mainArm.f_104204_ = (float)Math.toRadians((-45.0f + aimProgress * -20.0f) * (right ? 1.0f : -1.0f));
            secondaryArm.f_104203_ = (float)Math.toRadians(-42.0f + aimProgress * -48.0f);
            secondaryArm.f_104204_ = (float)Math.toRadians((-15.0f + aimProgress * 5.0f) * (right ? 1.0f : -1.0f));
        } else {
            super.applyPlayerModelRotation(player, rightArm, leftArm, head, hand, aimProgress);
            float angle = this.getPlayerPitch(player);
            head.f_104203_ = (float)Math.toRadians((double)angle > 0.0 ? (double)(angle * 70.0f) : (double)(angle * 90.0f));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void applyPlayerPreRender(Player player, InteractionHand hand, float aimProgress, PoseStack poseStack, MultiBufferSource buffer) {
        if (((Boolean)Config.CLIENT.display.oldAnimations.get()).booleanValue()) {
            boolean right = Minecraft.m_91087_().f_91066_.m_232107_().m_231551_() == HumanoidArm.RIGHT ? hand == InteractionHand.MAIN_HAND : hand == InteractionHand.OFF_HAND;
            player.f_20884_ = player.f_19859_ + (right ? 25.0f : -25.0f) + aimProgress * (right ? 20.0f : -20.0f);
            player.f_20883_ = player.m_146908_() + (right ? 25.0f : -25.0f) + aimProgress * (right ? 20.0f : -20.0f);
        } else {
            super.applyPlayerPreRender(player, hand, aimProgress, poseStack, buffer);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void applyHeldItemTransforms(Player player, InteractionHand hand, float aimProgress, PoseStack poseStack, MultiBufferSource buffer) {
        if (((Boolean)Config.CLIENT.display.oldAnimations.get()).booleanValue()) {
            if (hand == InteractionHand.MAIN_HAND) {
                boolean right = Minecraft.m_91087_().f_91066_.m_232107_().m_231551_() == HumanoidArm.RIGHT ? hand == InteractionHand.MAIN_HAND : hand == InteractionHand.OFF_HAND;
                poseStack.m_85837_(0.0, 0.0, 0.05);
                float invertRealProgress = 1.0f - aimProgress;
                poseStack.m_252781_(Axis.f_252403_.m_252977_(25.0f * invertRealProgress * (right ? 1.0f : -1.0f)));
                poseStack.m_252781_(Axis.f_252436_.m_252977_((30.0f * invertRealProgress + aimProgress * -20.0f) * (right ? 1.0f : -1.0f)));
                poseStack.m_252781_(Axis.f_252529_.m_252977_(25.0f * invertRealProgress + aimProgress * 5.0f));
            }
        } else {
            super.applyHeldItemTransforms(player, hand, aimProgress, poseStack, buffer);
        }
    }

    @Override
    public void renderFirstPersonArms(Player player, HumanoidArm hand, ItemStack stack, PoseStack poseStack, MultiBufferSource buffer, int light, float partialTicks) {
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        BakedModel model = Minecraft.m_91087_().m_91291_().m_174264_(stack, player.f_19853_, (LivingEntity)player, 0);
        float translateX = model.m_7442_().f_111790_.f_111756_.x();
        int side = hand.m_20828_() == HumanoidArm.RIGHT ? 1 : -1;
        poseStack.m_252880_(translateX * (float)side, 0.0f, 0.0f);
        boolean slim = Minecraft.m_91087_().f_91074_.m_108564_().equals("slim");
        float armWidth = slim ? 3.0f : 4.0f;
        poseStack.m_85836_();
        float reloadProgress = ReloadHandler.get().getReloadProgress(partialTicks);
        poseStack.m_85837_((double)reloadProgress * 0.5, (double)(-reloadProgress), (double)(-reloadProgress) * 0.5);
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        poseStack.m_85837_(0.25 * (double)side, 0.0, 0.0);
        poseStack.m_85837_((double)armWidth / 2.0 * 0.0625 * (double)side, 0.0, 0.0);
        poseStack.m_85837_(-0.3125 * (double)side, -0.1, -0.4375);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(80.0f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(15.0f * (float)(-side)));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(15.0f * (float)(-side)));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-35.0f));
        RenderUtil.renderFirstPersonArm((LocalPlayer)player, hand.m_20828_(), poseStack, buffer, light);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.1, -0.675);
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        poseStack.m_85837_(-0.25 * (double)side, 0.0, 0.0);
        poseStack.m_85837_(-((double)armWidth / 2.0) * 0.0625 * (double)side, 0.0, 0.0);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(80.0f));
        RenderUtil.renderFirstPersonArm((LocalPlayer)player, hand, poseStack, buffer, light);
        poseStack.m_85849_();
    }

    @Override
    public boolean applyOffhandTransforms(Player player, PlayerModel model, ItemStack stack, PoseStack poseStack, float partialTicks) {
        return GripType.applyBackTransforms(player, poseStack);
    }
}

