/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.common;

import com.mrcrayfish.framework.api.network.LevelLocation;
import com.mrcrayfish.framework.network.message.IMessage;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import ttv.migami.jeg.Config;
import ttv.migami.jeg.common.AmmoContext;
import ttv.migami.jeg.common.DelayedTask;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.common.ReloadType;
import ttv.migami.jeg.init.ModSyncedDataKeys;
import ttv.migami.jeg.item.GunItem;
import ttv.migami.jeg.network.PacketHandler;
import ttv.migami.jeg.network.message.S2CMessageGunSound;
import ttv.migami.jeg.util.GunEnchantmentHelper;

@Mod.EventBusSubscriber(modid="jeg")
public class ReloadTracker {
    private static final Map<Player, ReloadTracker> RELOAD_TRACKER_MAP = new WeakHashMap<Player, ReloadTracker>();
    private final int startTick;
    private final int slot;
    private final ItemStack stack;
    private final Gun gun;

    private ReloadTracker(Player player) {
        this.startTick = player.f_19797_;
        this.slot = player.m_150109_().f_35977_;
        this.stack = player.m_150109_().m_36056_();
        this.gun = ((GunItem)this.stack.m_41720_()).getModifiedGun(this.stack);
    }

    private boolean isSameWeapon(Player player) {
        return !this.stack.m_41619_() && player.m_150109_().f_35977_ == this.slot && player.m_150109_().m_36056_() == this.stack;
    }

    private boolean isWeaponFull() {
        CompoundTag tag = this.stack.m_41784_();
        return tag.m_128451_("AmmoCount") >= GunEnchantmentHelper.getAmmoCapacity(this.stack, this.gun);
    }

    private boolean isWeaponEmpty() {
        CompoundTag tag = this.stack.m_41784_();
        return tag.m_128451_("AmmoCount") == 0;
    }

    private boolean hasNoAmmo(Player player) {
        if (this.gun.getReloads().getReloadType() == ReloadType.SINGLE_ITEM) {
            return Gun.findAmmo(player, this.gun.getReloads().getReloadItem()).stack().m_41619_();
        }
        return Gun.findAmmo(player, this.gun.getProjectile().getItem()).stack().m_41619_();
    }

    private boolean canReload(Player player) {
        if (this.gun.getReloads().getReloadType() == ReloadType.MAG_FED || this.gun.getReloads().getReloadType() == ReloadType.SINGLE_ITEM) {
            if (this.isWeaponEmpty()) {
                int deltaTicks = player.f_19797_ - this.startTick;
                int interval = this.gun.getReloads().getReloadTimer() + this.gun.getReloads().getEmptyMagTimer();
                return deltaTicks > interval;
            }
            int deltaTicks = player.f_19797_ - this.startTick;
            int interval = this.gun.getReloads().getReloadTimer();
            return deltaTicks > interval;
        }
        int deltaTicks = player.f_19797_ - this.startTick;
        int interval = GunEnchantmentHelper.getReloadInterval(this.stack);
        return deltaTicks > 0 && deltaTicks % interval == 0;
    }

    public static int ammoInInventory(ItemStack[] ammoStack) {
        int result = 0;
        for (ItemStack x : ammoStack) {
            result += x.m_41613_();
        }
        return result;
    }

    private void shrinkFromAmmoPool(ItemStack[] ammoStack, Player player, int shrinkAmount) {
        int shrinkAmt = shrinkAmount;
        ArrayList stacks = new ArrayList();
        for (ItemStack x : ammoStack) {
            if (!x.m_41619_()) {
                int max = Math.min(shrinkAmt, x.m_41613_());
                x.m_41774_(max);
                shrinkAmt -= max;
            }
            if (shrinkAmt != 0) continue;
            return;
        }
    }

    private void increaseMagAmmo(Player player) {
        ResourceLocation reloadSound;
        ItemStack[] ammoStack = Gun.findAmmoStack(player, this.gun.getProjectile().getItem());
        if (ammoStack.length > 0) {
            CompoundTag tag = this.stack.m_41783_();
            int ammoAmount = Math.min(ReloadTracker.ammoInInventory(ammoStack), GunEnchantmentHelper.getAmmoCapacity(this.stack, this.gun));
            int currentAmmo = tag.m_128451_("AmmoCount");
            int maxAmmo = GunEnchantmentHelper.getAmmoCapacity(this.stack, this.gun);
            int amount = maxAmmo - currentAmmo;
            if (tag != null) {
                if (ammoAmount < amount) {
                    tag.m_128405_("AmmoCount", currentAmmo + ammoAmount);
                    this.shrinkFromAmmoPool(ammoStack, player, ammoAmount);
                } else {
                    tag.m_128405_("AmmoCount", maxAmmo);
                    this.shrinkFromAmmoPool(ammoStack, player, amount);
                }
            }
        }
        if ((reloadSound = this.gun.getSounds().getReload()) != null) {
            double radius = (Double)Config.SERVER.reloadMaxDistance.get();
            double soundX = player.m_20185_();
            double soundY = player.m_20186_() + 1.0;
            double soundZ = player.m_20189_();
            S2CMessageGunSound message = new S2CMessageGunSound(reloadSound, SoundSource.PLAYERS, (float)soundX, (float)soundY, (float)soundZ, 1.0f, 1.0f, player.m_19879_(), false, true);
            PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)player.f_19853_, (double)soundX, (double)soundY, (double)soundZ, (double)radius), (IMessage)message);
        }
    }

    private void reloadItem(Player player) {
        ResourceLocation reloadSound;
        Item bucket;
        ResourceLocation bucketLocation;
        Item item;
        AmmoContext context = Gun.findAmmo(player, this.gun.getReloads().getReloadItem());
        ItemStack ammo = context.stack();
        if (!ammo.m_41619_()) {
            Container container;
            CompoundTag tag = this.stack.m_41783_();
            if (tag != null) {
                int maxAmmo = GunEnchantmentHelper.getAmmoCapacity(this.stack, this.gun);
                tag.m_128405_("AmmoCount", maxAmmo);
                ammo.m_41774_(1);
            }
            if ((container = context.container()) != null) {
                container.m_6596_();
            }
        }
        Item waterBucket = Items.f_42447_;
        ResourceLocation waterBucketLocation = ForgeRegistries.ITEMS.getKey((Object)waterBucket);
        if (this.gun.getReloads().getReloadItem().equals((Object)waterBucketLocation) && (item = (Item)ForgeRegistries.ITEMS.getValue(bucketLocation = ForgeRegistries.ITEMS.getKey((Object)(bucket = Items.f_42446_)))) != null) {
            ItemStack itemStack = new ItemStack((ItemLike)item);
            player.f_19853_.m_7967_((Entity)new ItemEntity(player.f_19853_, player.m_20185_(), player.m_20186_(), player.m_20189_(), itemStack.m_41777_()));
        }
        if ((reloadSound = this.gun.getSounds().getReload()) != null) {
            double radius = (Double)Config.SERVER.reloadMaxDistance.get();
            double soundX = player.m_20185_();
            double soundY = player.m_20186_() + 1.0;
            double soundZ = player.m_20189_();
            S2CMessageGunSound message = new S2CMessageGunSound(reloadSound, SoundSource.PLAYERS, (float)soundX, (float)soundY, (float)soundZ, 1.0f, 1.0f, player.m_19879_(), false, true);
            PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)player.f_19853_, (double)soundX, (double)soundY, (double)soundZ, (double)radius), (IMessage)message);
        }
    }

    private void increaseAmmo(Player player) {
        ResourceLocation reloadSound;
        AmmoContext context = Gun.findAmmo(player, this.gun.getProjectile().getItem());
        ItemStack ammo = context.stack();
        if (!ammo.m_41619_()) {
            int amount = Math.min(ammo.m_41613_(), this.gun.getReloads().getReloadAmount());
            CompoundTag tag = this.stack.m_41783_();
            if (tag != null) {
                int maxAmmo = GunEnchantmentHelper.getAmmoCapacity(this.stack, this.gun);
                amount = Math.min(amount, maxAmmo - tag.m_128451_("AmmoCount"));
                tag.m_128405_("AmmoCount", tag.m_128451_("AmmoCount") + amount);
            }
            ammo.m_41774_(amount);
            Container container = context.container();
            if (container != null) {
                container.m_6596_();
            }
        }
        if ((reloadSound = this.gun.getSounds().getReload()) != null) {
            double radius = (Double)Config.SERVER.reloadMaxDistance.get();
            double soundX = player.m_20185_();
            double soundY = player.m_20186_() + 1.0;
            double soundZ = player.m_20189_();
            S2CMessageGunSound message = new S2CMessageGunSound(reloadSound, SoundSource.PLAYERS, (float)soundX, (float)soundY, (float)soundZ, 1.0f, 1.0f, player.m_19879_(), false, true);
            PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)player.f_19853_, (double)soundX, (double)soundY, (double)soundZ, (double)radius), (IMessage)message);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !event.player.f_19853_.f_46443_) {
            Player player = event.player;
            if (((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player)).booleanValue()) {
                ReloadTracker tracker;
                if (!RELOAD_TRACKER_MAP.containsKey(player)) {
                    if (!(player.m_150109_().m_36056_().m_41720_() instanceof GunItem)) {
                        ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)false);
                        return;
                    }
                    RELOAD_TRACKER_MAP.put(player, new ReloadTracker(player));
                }
                if (!(tracker = RELOAD_TRACKER_MAP.get(player)).isSameWeapon(player) || tracker.isWeaponFull() || tracker.hasNoAmmo(player)) {
                    RELOAD_TRACKER_MAP.remove(player);
                    ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)false);
                    return;
                }
                if (tracker.canReload(player)) {
                    Player finalPlayer = player;
                    Gun gun = tracker.gun;
                    if (gun.getReloads().getReloadType() == ReloadType.MAG_FED) {
                        tracker.increaseMagAmmo(player);
                    } else if (gun.getReloads().getReloadType() == ReloadType.SINGLE_ITEM) {
                        tracker.reloadItem(player);
                    } else if (gun.getReloads().getReloadType() == ReloadType.MANUAL) {
                        tracker.increaseAmmo(player);
                    }
                    if (tracker.isWeaponFull() || tracker.hasNoAmmo(player)) {
                        RELOAD_TRACKER_MAP.remove(player);
                        ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)false);
                        DelayedTask.runAfter(4, () -> {
                            ResourceLocation cockSound = gun.getSounds().getCock();
                            if (cockSound != null && finalPlayer.m_6084_()) {
                                double soundX = finalPlayer.m_20185_();
                                double soundY = finalPlayer.m_20186_() + 1.0;
                                double soundZ = finalPlayer.m_20189_();
                                double radius = (Double)Config.SERVER.reloadMaxDistance.get();
                                S2CMessageGunSound messageSound = new S2CMessageGunSound(cockSound, SoundSource.PLAYERS, (float)soundX, (float)soundY, (float)soundZ, 1.0f, 1.0f, finalPlayer.m_19879_(), false, true);
                                PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)finalPlayer.f_19853_, (double)soundX, (double)soundY, (double)soundZ, (double)radius), (IMessage)messageSound);
                            }
                        });
                    }
                }
            } else {
                RELOAD_TRACKER_MAP.remove(player);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerEvent.PlayerLoggedOutEvent event) {
        MinecraftServer server = event.getEntity().m_20194_();
        if (server != null) {
            server.execute(() -> RELOAD_TRACKER_MAP.remove(event.getEntity()));
        }
    }
}

