/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.common.network;

import com.mrcrayfish.framework.api.network.LevelLocation;
import com.mrcrayfish.framework.network.message.IMessage;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import ttv.migami.jeg.Config;
import ttv.migami.jeg.JustEnoughGuns;
import ttv.migami.jeg.blockentity.GunmetalWorkbenchBlockEntity;
import ttv.migami.jeg.blockentity.GunniteWorkbenchBlockEntity;
import ttv.migami.jeg.blockentity.ScrapWorkbenchBlockEntity;
import ttv.migami.jeg.common.FireMode;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.common.ProjectileManager;
import ttv.migami.jeg.common.ReloadType;
import ttv.migami.jeg.common.ShootTracker;
import ttv.migami.jeg.common.SpreadTracker;
import ttv.migami.jeg.common.container.AttachmentContainer;
import ttv.migami.jeg.common.container.GunmetalWorkbenchContainer;
import ttv.migami.jeg.common.container.GunniteWorkbenchContainer;
import ttv.migami.jeg.common.container.ScrapWorkbenchContainer;
import ttv.migami.jeg.crafting.GunmetalWorkbenchRecipe;
import ttv.migami.jeg.crafting.GunmetalWorkbenchRecipes;
import ttv.migami.jeg.crafting.GunniteWorkbenchRecipe;
import ttv.migami.jeg.crafting.GunniteWorkbenchRecipes;
import ttv.migami.jeg.crafting.ScrapWorkbenchRecipe;
import ttv.migami.jeg.crafting.ScrapWorkbenchRecipes;
import ttv.migami.jeg.entity.projectile.ProjectileEntity;
import ttv.migami.jeg.event.BurstFireEvent;
import ttv.migami.jeg.event.GunFireEvent;
import ttv.migami.jeg.init.ModEnchantments;
import ttv.migami.jeg.init.ModSyncedDataKeys;
import ttv.migami.jeg.interfaces.IProjectileFactory;
import ttv.migami.jeg.item.GunItem;
import ttv.migami.jeg.item.IColored;
import ttv.migami.jeg.network.PacketHandler;
import ttv.migami.jeg.network.message.C2SMessagePreFireSound;
import ttv.migami.jeg.network.message.C2SMessageShoot;
import ttv.migami.jeg.network.message.S2CMessageBulletTrail;
import ttv.migami.jeg.network.message.S2CMessageGunSound;
import ttv.migami.jeg.util.GunEnchantmentHelper;
import ttv.migami.jeg.util.GunModifierHelper;

public class ServerPlayHandler {
    private static final Predicate<LivingEntity> HOSTILE_ENTITIES = entity -> entity.m_5720_() == SoundSource.HOSTILE && !(entity instanceof NeutralMob) && !((List)Config.COMMON.aggroMobs.exemptEntities.get()).contains(EntityType.m_20613_((EntityType)entity.m_6095_()).toString());

    /*
     * Enabled aggressive block sorting
     */
    public static void handleShoot(C2SMessageShoot message, ServerPlayer player) {
        int level;
        CompoundTag tag;
        ResourceLocation fireSound;
        double radius;
        Gun modifiedGun;
        GunItem item;
        ItemStack heldItem;
        Level world;
        block13: {
            Iterator iterator;
            double z;
            double y;
            double x;
            double radius2;
            block14: {
                block12: {
                    if (player.m_5833_()) {
                        return;
                    }
                    if (player.m_21211_().m_41720_() == Items.f_42740_) {
                        return;
                    }
                    world = player.f_19853_;
                    heldItem = player.m_21120_(InteractionHand.MAIN_HAND);
                    Item item2 = heldItem.m_41720_();
                    if (!(item2 instanceof GunItem)) break block12;
                    item = (GunItem)item2;
                    if (!Gun.hasAmmo(heldItem) && !player.m_7500_()) break block12;
                    modifiedGun = item.getModifiedGun(heldItem);
                    if (modifiedGun == null) return;
                    if (MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent.Pre((Player)player, heldItem))) {
                        return;
                    }
                    player.m_146922_(Mth.m_14177_((float)message.getRotationYaw()));
                    player.m_146926_(Mth.m_14036_((float)message.getRotationPitch(), (float)-90.0f, (float)90.0f));
                    ShootTracker tracker = ShootTracker.getShootTracker((Player)player);
                    if (tracker.hasCooldown(item) && tracker.getRemaining(item) > (long)((Integer)Config.SERVER.cooldownThreshold.get()).intValue()) {
                        JustEnoughGuns.LOGGER.warn(player.m_7755_().m_214077_() + "(" + player.m_20148_() + ") tried to fire before cooldown finished or server is lagging? Remaining milliseconds: " + tracker.getRemaining(item));
                        return;
                    }
                    tracker.putCooldown(heldItem, item, modifiedGun);
                    if (((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player)).booleanValue()) {
                        ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)false);
                    }
                    if (!modifiedGun.getGeneral().isAlwaysSpread() && modifiedGun.getGeneral().getSpread() > 0.0f) {
                        SpreadTracker.get((Player)player).update((Player)player, item);
                    }
                    if (modifiedGun.getGeneral().getFireMode() != FireMode.PULSE) {
                        int count = modifiedGun.getGeneral().getProjectileAmount();
                        Gun.Projectile projectileProps = modifiedGun.getProjectile();
                        ProjectileEntity[] spawnedProjectiles = new ProjectileEntity[count];
                        for (int i = 0; i < count; ++i) {
                            IProjectileFactory factory = ProjectileManager.getInstance().getFactory(projectileProps.getItem());
                            ProjectileEntity projectileEntity = factory.create(world, (LivingEntity)player, heldItem, item, modifiedGun);
                            projectileEntity.setWeapon(heldItem);
                            projectileEntity.setAdditionalDamage(Gun.getAdditionalDamage(heldItem));
                            world.m_7967_((Entity)projectileEntity);
                            spawnedProjectiles[i] = projectileEntity;
                            projectileEntity.m_8119_();
                        }
                        if (!projectileProps.isVisible()) {
                            double spawnX = player.m_20185_();
                            double spawnY = player.m_20186_() + 1.0;
                            double spawnZ = player.m_20189_();
                            radius = (Double)Config.COMMON.network.projectileTrackingRange.get();
                            ParticleOptions data = GunEnchantmentHelper.getParticle(heldItem);
                            S2CMessageBulletTrail messageBulletTrail = new S2CMessageBulletTrail(spawnedProjectiles, projectileProps, player.m_19879_(), data);
                            PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)player.f_19853_, (double)spawnX, (double)spawnY, (double)spawnZ, (double)radius), (IMessage)messageBulletTrail);
                        }
                    }
                    MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent.Post((Player)player, heldItem));
                    if (!((Boolean)Config.COMMON.aggroMobs.enabled.get()).booleanValue()) break block13;
                    radius2 = GunModifierHelper.getModifiedFireSoundRadius(heldItem, (Double)Config.COMMON.aggroMobs.unsilencedRange.get());
                    x = player.m_20185_();
                    y = player.m_20186_() + 0.5;
                    z = player.m_20189_();
                    AABB box = new AABB(x - radius2, y - radius2, z - radius2, x + radius2, y + radius2, z + radius2);
                    radius2 *= radius2;
                    iterator = world.m_6443_(LivingEntity.class, box, HOSTILE_ENTITIES).iterator();
                    break block14;
                }
                world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, 0.8f);
                return;
            }
            while (iterator.hasNext()) {
                double dz;
                double dy;
                LivingEntity entity = (LivingEntity)iterator.next();
                double dx = x - entity.m_20185_();
                if (!(dx * dx + (dy = y - entity.m_20186_()) * dy + (dz = z - entity.m_20189_()) * dz <= radius2)) continue;
                entity.m_6703_((LivingEntity)((Boolean)Config.COMMON.aggroMobs.angerHostileMobs.get() != false ? player : entity));
            }
        }
        if ((fireSound = ServerPlayHandler.getFireSound(heldItem, modifiedGun)) != null) {
            double posX = player.m_20185_();
            double posY = player.m_20186_() + (double)player.m_20192_();
            double posZ = player.m_20189_();
            float volume = GunModifierHelper.getFireSoundVolume(heldItem);
            float pitch = 0.9f + world.f_46441_.m_188501_() * 0.2f;
            radius = GunModifierHelper.getModifiedFireSoundRadius(heldItem, (Double)Config.SERVER.gunShotMaxDistance.get());
            boolean muzzle = modifiedGun.getDisplay().getFlash() != null;
            S2CMessageGunSound messageSound = new S2CMessageGunSound(fireSound, SoundSource.PLAYERS, (float)posX, (float)posY, (float)posZ, volume, pitch, player.m_19879_(), muzzle, false);
            PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)player.f_19853_, (double)posX, (double)posY, (double)posZ, (double)radius), (IMessage)messageSound);
        }
        if (!(player.m_7500_() || (tag = heldItem.m_41784_()).m_128471_("IgnoreAmmo") || (level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.RECLAIMED.get()), (ItemStack)heldItem)) != 0 && player.f_19853_.f_46441_.m_188503_(4 - Mth.m_14045_((int)level, (int)1, (int)2)) == 0)) {
            tag.m_128405_("AmmoCount", Math.max(0, tag.m_128451_("AmmoCount") - 1));
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
    }

    public static void handlePreFireSound(C2SMessagePreFireSound message, ServerPlayer player) {
        Level world = player.f_19853_;
        ItemStack heldItem = player.m_21120_(InteractionHand.MAIN_HAND);
        Item item = heldItem.m_41720_();
        if (item instanceof GunItem) {
            Gun modifiedGun;
            ResourceLocation fireSound;
            GunItem item2 = (GunItem)item;
            if ((Gun.hasAmmo(heldItem) || player.m_7500_()) && (fireSound = ServerPlayHandler.getPreFireSound(heldItem, modifiedGun = item2.getModifiedGun(heldItem))) != null) {
                double posX = player.m_20185_();
                double posY = player.m_20186_() + (double)player.m_20192_();
                double posZ = player.m_20189_();
                float volume = GunModifierHelper.getFireSoundVolume(heldItem);
                float pitch = 0.9f + world.f_46441_.m_188501_() * 0.2f;
                double radius = GunModifierHelper.getModifiedFireSoundRadius(heldItem, (Double)Config.SERVER.gunShotMaxDistance.get());
                S2CMessageGunSound messageSound = new S2CMessageGunSound(fireSound, SoundSource.PLAYERS, (float)posX, (float)posY, (float)posZ, volume, pitch, player.m_19879_(), false, false);
                PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)player.f_19853_, (double)posX, (double)posY, (double)posZ, (double)radius), (IMessage)messageSound);
            }
        }
    }

    public static void handleBurst(ServerPlayer player) {
        GunItem gunItem;
        Gun gun;
        ItemStack heldItem = player.m_21205_();
        Item item = heldItem.m_41720_();
        if (item instanceof GunItem && (gun = (gunItem = (GunItem)item).getModifiedGun(heldItem)).getGeneral().getFireMode() == FireMode.BURST) {
            BurstFireEvent.resetBurst(heldItem);
        }
    }

    private static ResourceLocation getFireSound(ItemStack stack, Gun modifiedGun) {
        ResourceLocation fireSound = null;
        if (GunModifierHelper.isSilencedFire(stack)) {
            fireSound = modifiedGun.getSounds().getSilencedFire();
        } else if (stack.m_41793_()) {
            fireSound = modifiedGun.getSounds().getEnchantedFire();
        }
        if (fireSound != null) {
            return fireSound;
        }
        return modifiedGun.getSounds().getFire();
    }

    private static ResourceLocation getPreFireSound(ItemStack stack, Gun modifiedGun) {
        return modifiedGun.getSounds().getPreFire();
    }

    public static void handleCraft(ServerPlayer player, ResourceLocation id, BlockPos pos) {
        IColored colored;
        int color;
        DyeItem dyeItem;
        ItemStack dyeStack;
        ItemStack stack;
        Object recipe;
        AbstractContainerMenu workbench;
        Level world = player.f_19853_;
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof ScrapWorkbenchContainer && (workbench = (ScrapWorkbenchContainer)abstractContainerMenu).getPos().equals((Object)pos)) {
            recipe = ScrapWorkbenchRecipes.getRecipeById(world, id);
            if (recipe == null || !((ScrapWorkbenchRecipe)recipe).hasMaterials((Player)player)) {
                return;
            }
            ((ScrapWorkbenchRecipe)recipe).consumeMaterials((Player)player);
            ScrapWorkbenchBlockEntity scrapWorkbenchBlockEntity = workbench.getWorkbench();
            stack = ((ScrapWorkbenchRecipe)recipe).getItem();
            dyeStack = (ItemStack)scrapWorkbenchBlockEntity.getInventory().get(0);
            if (dyeStack.m_41720_() instanceof DyeItem) {
                dyeItem = (DyeItem)dyeStack.m_41720_();
                color = dyeItem.m_41089_().m_41071_();
                if (IColored.isDyeable(stack)) {
                    colored = (IColored)stack.m_41720_();
                    colored.setColor(stack, color);
                    scrapWorkbenchBlockEntity.getInventory().set(0, (Object)ItemStack.f_41583_);
                }
            }
            Containers.m_18992_((Level)world, (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 1.125), (double)((double)pos.m_123343_() + 0.5), (ItemStack)stack);
        }
        if ((recipe = player.f_36096_) instanceof GunmetalWorkbenchContainer && (workbench = (GunmetalWorkbenchContainer)((Object)recipe)).getPos().equals((Object)pos)) {
            recipe = GunmetalWorkbenchRecipes.getRecipeById(world, id);
            if (recipe == null || !((GunmetalWorkbenchRecipe)recipe).hasMaterials((Player)player)) {
                return;
            }
            ((GunmetalWorkbenchRecipe)recipe).consumeMaterials((Player)player);
            GunmetalWorkbenchBlockEntity gunmetalWorkbenchBlockEntity = workbench.getWorkbench();
            stack = ((GunmetalWorkbenchRecipe)recipe).getItem();
            dyeStack = (ItemStack)gunmetalWorkbenchBlockEntity.getInventory().get(0);
            if (dyeStack.m_41720_() instanceof DyeItem) {
                dyeItem = (DyeItem)dyeStack.m_41720_();
                color = dyeItem.m_41089_().m_41071_();
                if (IColored.isDyeable(stack)) {
                    colored = (IColored)stack.m_41720_();
                    colored.setColor(stack, color);
                    gunmetalWorkbenchBlockEntity.getInventory().set(0, (Object)ItemStack.f_41583_);
                }
            }
            Containers.m_18992_((Level)world, (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 1.125), (double)((double)pos.m_123343_() + 0.5), (ItemStack)stack);
        }
        if ((recipe = player.f_36096_) instanceof GunniteWorkbenchContainer && (workbench = (GunniteWorkbenchContainer)((Object)recipe)).getPos().equals((Object)pos)) {
            recipe = GunniteWorkbenchRecipes.getRecipeById(world, id);
            if (recipe == null || !((GunniteWorkbenchRecipe)recipe).hasMaterials((Player)player)) {
                return;
            }
            ((GunniteWorkbenchRecipe)recipe).consumeMaterials((Player)player);
            GunniteWorkbenchBlockEntity gunniteWorkbenchBlockEntity = workbench.getWorkbench();
            stack = ((GunniteWorkbenchRecipe)recipe).getItem();
            dyeStack = (ItemStack)gunniteWorkbenchBlockEntity.getInventory().get(0);
            if (dyeStack.m_41720_() instanceof DyeItem) {
                dyeItem = (DyeItem)dyeStack.m_41720_();
                color = dyeItem.m_41089_().m_41071_();
                if (IColored.isDyeable(stack)) {
                    colored = (IColored)stack.m_41720_();
                    colored.setColor(stack, color);
                    gunniteWorkbenchBlockEntity.getInventory().set(0, (Object)ItemStack.f_41583_);
                }
            }
            Containers.m_18992_((Level)world, (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 1.125), (double)((double)pos.m_123343_() + 0.5), (ItemStack)stack);
        }
    }

    public static void handleUnload(ServerPlayer player) {
        ItemStack stack = player.m_21205_();
        Item item = stack.m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            Gun gun = gunItem.getModifiedGun(stack);
            CompoundTag tag = stack.m_41783_();
            if (gun.getReloads().getReloadType() != ReloadType.SINGLE_ITEM && tag != null && tag.m_128425_("AmmoCount", 3)) {
                int count = tag.m_128451_("AmmoCount");
                tag.m_128405_("AmmoCount", 0);
                ResourceLocation id = gun.getProjectile().getItem();
                Item item2 = (Item)ForgeRegistries.ITEMS.getValue(id);
                if (item2 == null) {
                    return;
                }
                int maxStackSize = item2.m_41459_();
                int stacks = count / maxStackSize;
                for (int i = 0; i < stacks; ++i) {
                    ServerPlayHandler.spawnAmmo(player, new ItemStack((ItemLike)item2, maxStackSize));
                }
                int remaining = count % maxStackSize;
                if (remaining > 0) {
                    ServerPlayHandler.spawnAmmo(player, new ItemStack((ItemLike)item2, remaining));
                }
            }
        }
    }

    private static void spawnAmmo(ServerPlayer player, ItemStack stack) {
        player.m_150109_().m_36054_(stack);
        if (stack.m_41613_() > 0) {
            player.f_19853_.m_7967_((Entity)new ItemEntity(player.f_19853_, player.m_20185_(), player.m_20186_(), player.m_20189_(), stack.m_41777_()));
        }
    }

    public static void handleAttachments(ServerPlayer player) {
        ItemStack heldItem = player.m_21205_();
        if (heldItem.m_41720_() instanceof GunItem) {
            NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((windowId, playerInventory, player1) -> new AttachmentContainer(windowId, playerInventory, heldItem), (Component)Component.m_237115_((String)"container.jeg.attachments")));
        }
    }
}

