/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.crafting;

import com.google.common.collect.ImmutableList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import ttv.migami.jeg.blockentity.GunniteWorkbenchBlockEntity;
import ttv.migami.jeg.crafting.ScrapWorkbenchIngredient;
import ttv.migami.jeg.init.ModRecipeSerializers;
import ttv.migami.jeg.init.ModRecipeTypes;
import ttv.migami.jeg.util.InventoryUtil;

public class GunniteWorkbenchRecipe
implements Recipe<GunniteWorkbenchBlockEntity> {
    private final ResourceLocation id;
    private final ItemStack item;
    private final ImmutableList<ScrapWorkbenchIngredient> materials;

    public GunniteWorkbenchRecipe(ResourceLocation id, ItemStack item, ImmutableList<ScrapWorkbenchIngredient> materials) {
        this.id = id;
        this.item = item;
        this.materials = materials;
    }

    public ItemStack getItem() {
        return this.item.m_41777_();
    }

    public ImmutableList<ScrapWorkbenchIngredient> getMaterials() {
        return this.materials;
    }

    public boolean matches(GunniteWorkbenchBlockEntity inv, Level worldIn) {
        return false;
    }

    public ItemStack assemble(GunniteWorkbenchBlockEntity entity, RegistryAccess access) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return this.item.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.GUNNITE_WORKBENCH.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.GUNNITE_WORKBENCH.get();
    }

    public boolean hasMaterials(Player player) {
        for (ScrapWorkbenchIngredient ingredient : this.getMaterials()) {
            if (InventoryUtil.hasWorkstationIngredient(player, ingredient)) continue;
            return false;
        }
        return true;
    }

    public void consumeMaterials(Player player) {
        for (ScrapWorkbenchIngredient ingredient : this.getMaterials()) {
            InventoryUtil.removeWorkstationIngredient(player, ingredient);
        }
    }
}

