/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;
import ttv.migami.jeg.crafting.ScrapWorkbenchIngredient;
import ttv.migami.jeg.init.ModRecipeSerializers;

public class ScrapWorkbenchRecipeBuilder {
    @Nullable
    private final RecipeCategory category;
    private final Item result;
    private final int count;
    private final List<ScrapWorkbenchIngredient> ingredients;
    private final Advancement.Builder advancementBuilder;
    private final List<ICondition> conditions = new ArrayList<ICondition>();

    private ScrapWorkbenchRecipeBuilder(@Nullable RecipeCategory category, ItemLike item, int count) {
        this.category = category;
        this.result = item.m_5456_();
        this.count = count;
        this.ingredients = new ArrayList<ScrapWorkbenchIngredient>();
        this.advancementBuilder = Advancement.Builder.m_138353_();
    }

    public static ScrapWorkbenchRecipeBuilder crafting(ItemLike item) {
        return new ScrapWorkbenchRecipeBuilder(null, item, 1);
    }

    public static ScrapWorkbenchRecipeBuilder crafting(ItemLike item, int count) {
        return new ScrapWorkbenchRecipeBuilder(null, item, count);
    }

    public static ScrapWorkbenchRecipeBuilder crafting(@Nullable RecipeCategory category, ItemLike item) {
        return new ScrapWorkbenchRecipeBuilder(category, item, 1);
    }

    public static ScrapWorkbenchRecipeBuilder crafting(@Nullable RecipeCategory category, ItemLike item, int count) {
        return new ScrapWorkbenchRecipeBuilder(category, item, count);
    }

    public ScrapWorkbenchRecipeBuilder addIngredient(ItemLike item, int count) {
        this.ingredients.add(ScrapWorkbenchIngredient.of(item, count));
        return this;
    }

    public ScrapWorkbenchRecipeBuilder addIngredient(ScrapWorkbenchIngredient ingredient) {
        this.ingredients.add(ingredient);
        return this;
    }

    public ScrapWorkbenchRecipeBuilder addCriterion(String name, CriterionTriggerInstance criterionIn) {
        this.advancementBuilder.m_138386_(name, criterionIn);
        return this;
    }

    public ScrapWorkbenchRecipeBuilder addCondition(ICondition condition) {
        this.conditions.add(condition);
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumer) {
        ResourceLocation resourcelocation = ForgeRegistries.ITEMS.getKey((Object)this.result);
        this.build(consumer, resourcelocation);
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        this.validate(id);
        this.advancementBuilder.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        consumer.accept(new Result(id, (ItemLike)this.result, this.count, this.ingredients, this.conditions, this.advancementBuilder, new ResourceLocation(id.m_135827_(), "recipes/" + (this.category != null ? this.category.m_247710_() : "") + "/" + id.m_135815_())));
    }

    private void validate(ResourceLocation id) {
        if (this.advancementBuilder.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Item item;
        private final int count;
        private final List<ScrapWorkbenchIngredient> ingredients;
        private final List<ICondition> conditions;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation id, ItemLike item, int count, List<ScrapWorkbenchIngredient> ingredients, List<ICondition> conditions, Advancement.Builder advancement, ResourceLocation advancementId) {
            this.id = id;
            this.item = item.m_5456_();
            this.count = count;
            this.ingredients = ingredients;
            this.conditions = conditions;
            this.advancement = advancement;
            this.advancementId = advancementId;
        }

        public void m_7917_(JsonObject json) {
            JsonArray conditions = new JsonArray();
            this.conditions.forEach(condition -> conditions.add((JsonElement)CraftingHelper.serialize((ICondition)condition)));
            if (conditions.size() > 0) {
                json.add("conditions", (JsonElement)conditions);
            }
            JsonArray materials = new JsonArray();
            this.ingredients.forEach(ingredient -> materials.add(ingredient.m_43942_()));
            json.add("materials", (JsonElement)materials);
            JsonObject resultObject = new JsonObject();
            resultObject.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.item).toString());
            if (this.count > 1) {
                resultObject.addProperty("count", (Number)this.count);
            }
            json.add("result", (JsonElement)resultObject);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRecipeSerializers.SCRAP_WORKBENCH.get();
        }

        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

