/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.util;

import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.interfaces.IGunModifier;
import ttv.migami.jeg.item.attachment.IAttachment;
import ttv.migami.jeg.item.attachment.impl.Attachment;
import ttv.migami.jeg.util.GunEnchantmentHelper;

public class GunModifierHelper {
    private static final IGunModifier[] EMPTY = new IGunModifier[0];

    private static IGunModifier[] getModifiers(ItemStack weapon, IAttachment.Type type) {
        Item item;
        ItemStack stack = Gun.getAttachment(type, weapon);
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof IAttachment) {
            IAttachment attachment = (IAttachment)item;
            return ((Attachment)attachment.getProperties()).getModifiers();
        }
        return EMPTY;
    }

    public static int getModifiedProjectileLife(ItemStack weapon, int life) {
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                life = modifier.modifyProjectileLife(life);
            }
        }
        return life;
    }

    public static double getModifiedProjectileGravity(ItemStack weapon, double gravity) {
        IGunModifier[] modifiers;
        int i;
        for (i = 0; i < IAttachment.Type.values().length; ++i) {
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                gravity = modifier.modifyProjectileGravity(gravity);
            }
        }
        for (i = 0; i < IAttachment.Type.values().length; ++i) {
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                gravity += modifier.additionalProjectileGravity();
            }
        }
        return gravity;
    }

    public static float getModifiedSpread(ItemStack weapon, float spread) {
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                spread = modifier.modifyProjectileSpread(spread);
            }
        }
        return spread;
    }

    public static double getModifiedProjectileSpeed(ItemStack weapon, double speed) {
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                speed = modifier.modifyProjectileSpeed(speed);
            }
        }
        return speed;
    }

    public static float getFireSoundVolume(ItemStack weapon) {
        float volume = 1.0f;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                volume = modifier.modifyFireSoundVolume(volume);
            }
        }
        return Mth.m_14036_((float)volume, (float)0.0f, (float)16.0f);
    }

    public static double getMuzzleFlashScale(ItemStack weapon, double scale) {
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                scale = modifier.modifyMuzzleFlashScale(scale);
            }
        }
        return scale;
    }

    public static float getKickReduction(ItemStack weapon) {
        float kickReduction = 1.0f;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                kickReduction *= Mth.m_14036_((float)modifier.kickModifier(), (float)0.0f, (float)1.0f);
            }
        }
        return 1.0f - kickReduction;
    }

    public static float getRecoilModifier(ItemStack weapon) {
        float recoilReduction = 1.0f;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                recoilReduction *= Mth.m_14036_((float)modifier.recoilModifier(), (float)0.0f, (float)1.0f);
            }
        }
        return 1.0f - recoilReduction;
    }

    public static boolean isSilencedFire(ItemStack weapon) {
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                if (!modifier.silencedFire()) continue;
                return true;
            }
        }
        return false;
    }

    public static double getModifiedFireSoundRadius(ItemStack weapon, double radius) {
        double minRadius = radius;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                double newRadius = modifier.modifyFireSoundRadius(radius);
                if (!(newRadius < minRadius)) continue;
                minRadius = newRadius;
            }
        }
        return Mth.m_14008_((double)minRadius, (double)0.0, (double)Double.MAX_VALUE);
    }

    public static float getAdditionalDamage(ItemStack weapon) {
        float additionalDamage = 0.0f;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                additionalDamage += modifier.additionalDamage();
            }
        }
        return additionalDamage;
    }

    public static float getModifiedProjectileDamage(ItemStack weapon, float damage) {
        float finalDamage = damage;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                finalDamage = modifier.modifyProjectileDamage(finalDamage);
            }
        }
        return finalDamage;
    }

    public static float getModifiedDamage(ItemStack weapon, Gun modifiedGun, float damage) {
        IGunModifier[] modifiers;
        int i;
        float finalDamage = damage;
        for (i = 0; i < IAttachment.Type.values().length; ++i) {
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                finalDamage = modifier.modifyProjectileDamage(finalDamage);
            }
        }
        for (i = 0; i < IAttachment.Type.values().length; ++i) {
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                finalDamage += modifier.additionalDamage();
            }
        }
        return finalDamage;
    }

    public static double getModifiedAimDownSightSpeed(ItemStack weapon, double speed) {
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                speed = modifier.modifyAimDownSightSpeed(speed);
            }
        }
        return Mth.m_14008_((double)speed, (double)0.01, (double)Double.MAX_VALUE);
    }

    public static int getModifiedRate(ItemStack weapon, int rate) {
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                rate = modifier.modifyFireRate(rate);
            }
        }
        return Mth.m_14045_((int)rate, (int)0, (int)Integer.MAX_VALUE);
    }

    public static float getCriticalChance(ItemStack weapon) {
        float chance = 0.0f;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                chance += modifier.criticalChance();
            }
        }
        return Mth.m_14036_((float)(chance += GunEnchantmentHelper.getPuncturingChance(weapon)), (float)0.0f, (float)1.0f);
    }
}

