/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.blockentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import ttv.migami.jeg.crafting.AbstractRecyclingRecipe;

public abstract class AbstractRecyclerBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeHolder,
StackedContentsCompatible {
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_FUEL = 1;
    protected static final int SLOT_RESULT = 2;
    public static final int DATA_LIT_TIME = 0;
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{2, 1};
    private static final int[] SLOTS_FOR_SIDES = new int[]{1};
    public static final int DATA_LIT_DURATION = 1;
    public static final int DATA_RECYCLING_PROGRESS = 2;
    public static final int DATA_RECYCLING_TOTAL_TIME = 3;
    public static final int NUM_DATA_VALUES = 4;
    public static final int BURN_TIME_STANDARD = 200;
    public static final int BURN_COOL_SPEED = 2;
    public NonNullList<ItemStack> items = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
    int litTime;
    int litDuration;
    int recyclingProgress;
    int recyclingTotalTime;
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int p_58431_) {
            switch (p_58431_) {
                case 0: {
                    return AbstractRecyclerBlockEntity.this.litTime;
                }
                case 1: {
                    return AbstractRecyclerBlockEntity.this.litDuration;
                }
                case 2: {
                    return AbstractRecyclerBlockEntity.this.recyclingProgress;
                }
                case 3: {
                    return AbstractRecyclerBlockEntity.this.recyclingTotalTime;
                }
            }
            return 0;
        }

        public void m_8050_(int p_58433_, int p_58434_) {
            switch (p_58433_) {
                case 0: {
                    AbstractRecyclerBlockEntity.this.litTime = p_58434_;
                    break;
                }
                case 1: {
                    AbstractRecyclerBlockEntity.this.litDuration = p_58434_;
                    break;
                }
                case 2: {
                    AbstractRecyclerBlockEntity.this.recyclingProgress = p_58434_;
                    break;
                }
                case 3: {
                    AbstractRecyclerBlockEntity.this.recyclingTotalTime = p_58434_;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    private final RecipeType<? extends AbstractRecyclingRecipe> recipeType;
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    protected AbstractRecyclerBlockEntity(BlockEntityType<?> p_154991_, BlockPos p_154992_, BlockState p_154993_, RecipeType<? extends AbstractRecyclingRecipe> p_154994_) {
        super(p_154991_, p_154992_, p_154993_);
        this.recipeType = p_154994_;
    }

    @Deprecated
    public static Map<Item, Integer> getFuel() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Items.f_42448_, 20000);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Blocks.f_50353_, 16000);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Items.f_42585_, 2400);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Items.f_42413_, 1600);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Items.f_42414_, 1600);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (TagKey<Item>)ItemTags.f_13182_, 300);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (TagKey<Item>)ItemTags.f_13168_, 300);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (TagKey<Item>)ItemTags.f_13174_, 300);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (TagKey<Item>)ItemTags.f_13175_, 150);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (TagKey<Item>)ItemTags.f_13178_, 300);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (TagKey<Item>)ItemTags.f_13177_, 300);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Blocks.f_50132_, 300);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Blocks.f_50480_, 300);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Blocks.f_50479_, 300);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Blocks.f_50481_, 300);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Blocks.f_50483_, 300);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Blocks.f_50482_, 300);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Blocks.f_50192_, 300);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Blocks.f_50475_, 300);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Blocks.f_50474_, 300);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Blocks.f_50476_, 300);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Blocks.f_50478_, 300);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Blocks.f_50477_, 300);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Blocks.f_50065_, 300);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Blocks.f_50078_, 300);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Blocks.f_50624_, 300);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Blocks.f_50131_, 300);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Blocks.f_50087_, 300);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Blocks.f_50325_, 300);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Blocks.f_50091_, 300);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Blocks.f_50329_, 300);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (TagKey<Item>)ItemTags.f_13191_, 300);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Items.f_42411_, 300);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Items.f_42523_, 300);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Blocks.f_50155_, 300);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (TagKey<Item>)ItemTags.f_13157_, 200);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Items.f_42421_, 200);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Items.f_42420_, 200);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Items.f_42424_, 200);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Items.f_42423_, 200);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Items.f_42422_, 200);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (TagKey<Item>)ItemTags.f_13173_, 200);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (TagKey<Item>)ItemTags.f_13155_, 1200);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (TagKey<Item>)ItemTags.f_13167_, 100);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (TagKey<Item>)ItemTags.f_13170_, 100);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Items.f_42398_, 100);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (TagKey<Item>)ItemTags.f_13180_, 100);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Items.f_42399_, 100);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (TagKey<Item>)ItemTags.f_215867_, 67);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Blocks.f_50577_, 4001);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Items.f_42717_, 300);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Blocks.f_50571_, 50);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Blocks.f_50036_, 100);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Blocks.f_50616_, 400);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Blocks.f_50617_, 300);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Blocks.f_50618_, 300);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Blocks.f_50621_, 300);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Blocks.f_50622_, 300);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Blocks.f_50625_, 300);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Blocks.f_50715_, 300);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Blocks.f_152541_, 100);
        AbstractRecyclerBlockEntity.add((Map<Item, Integer>)map, (ItemLike)Blocks.f_152542_, 100);
        return map;
    }

    private static boolean isNeverARecyclerFuel(Item p_58398_) {
        return p_58398_.m_204114_().m_203656_(ItemTags.f_13153_);
    }

    private static void add(Map<Item, Integer> p_204303_, TagKey<Item> p_204304_, int p_204305_) {
        for (Holder holder : Registry.f_122827_.m_206058_(p_204304_)) {
            if (AbstractRecyclerBlockEntity.isNeverARecyclerFuel((Item)holder.m_203334_())) continue;
            p_204303_.put((Item)holder.m_203334_(), p_204305_);
        }
    }

    private static void add(Map<Item, Integer> p_58375_, ItemLike p_58376_, int p_58377_) {
        Item item = p_58376_.m_5456_();
        if (AbstractRecyclerBlockEntity.isNeverARecyclerFuel(item)) {
            if (SharedConstants.f_136183_) {
                throw (IllegalStateException)Util.m_137570_((Throwable)new IllegalStateException("A developer tried to explicitly make fire resistant item " + item.m_7626_(null).getString() + " a recycler fuel. That will not work!"));
            }
        } else {
            p_58375_.put(item, p_58377_);
        }
    }

    private boolean isLit() {
        return this.litTime > 0;
    }

    public void m_142466_(CompoundTag p_155025_) {
        super.m_142466_(p_155025_);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)p_155025_, this.items);
        this.litTime = p_155025_.m_128451_("BurnTime");
        this.recyclingProgress = p_155025_.m_128451_("CookTime");
        this.recyclingTotalTime = p_155025_.m_128451_("CookTimeTotal");
        this.litDuration = this.getBurnDuration((ItemStack)this.items.get(1));
        CompoundTag compoundtag = p_155025_.m_128469_("RecipesUsed");
        for (String s : compoundtag.m_128431_()) {
            this.recipesUsed.put((Object)new ResourceLocation(s), compoundtag.m_128451_(s));
        }
    }

    protected void m_183515_(CompoundTag p_187452_) {
        super.m_183515_(p_187452_);
        p_187452_.m_128405_("BurnTime", this.litTime);
        p_187452_.m_128405_("CookTime", this.recyclingProgress);
        p_187452_.m_128405_("CookTimeTotal", this.recyclingTotalTime);
        ContainerHelper.m_18973_((CompoundTag)p_187452_, this.items);
        CompoundTag compoundtag = new CompoundTag();
        this.recipesUsed.forEach((p_187449_, p_187450_) -> compoundtag.m_128405_(p_187449_.toString(), p_187450_.intValue()));
        p_187452_.m_128365_("RecipesUsed", (Tag)compoundtag);
    }

    public static void serverTick(Level p_155014_, BlockPos p_155015_, BlockState p_155016_, AbstractRecyclerBlockEntity p_155017_) {
        boolean flag = p_155017_.isLit();
        boolean flag1 = false;
        Recipe recipe = p_155014_.m_7465_().m_44015_(p_155017_.recipeType, (Container)p_155017_, p_155014_).orElse(null);
        int i = p_155017_.m_6893_();
        ItemStack itemstackInput = (ItemStack)p_155017_.items.get(0);
        if (p_155017_.isLit()) {
            --p_155017_.litTime;
        }
        ItemStack itemstack = (ItemStack)p_155017_.items.get(1);
        if (p_155017_.isLit() || !itemstack.m_41619_() && !((ItemStack)p_155017_.items.get(0)).m_41619_()) {
            if (!p_155017_.isLit() && p_155017_.canBurn(recipe, p_155017_.items, i)) {
                p_155017_.litDuration = p_155017_.litTime = p_155017_.getBurnDuration(itemstack);
                if (p_155017_.isLit()) {
                    flag1 = true;
                    if (itemstack.hasCraftingRemainingItem()) {
                        p_155017_.items.set(1, (Object)itemstack.getCraftingRemainingItem());
                    } else if (!itemstack.m_41619_()) {
                        Item item = itemstack.m_41720_();
                        itemstack.m_41774_(1);
                        if (itemstack.m_41619_()) {
                            p_155017_.items.set(1, (Object)itemstack.getCraftingRemainingItem());
                        }
                    }
                }
            }
            if (p_155017_.isLit() && p_155017_.canBurn(recipe, p_155017_.items, i)) {
                ++p_155017_.recyclingProgress;
                if (p_155017_.recyclingProgress == p_155017_.recyclingTotalTime) {
                    p_155017_.recyclingProgress = 0;
                    p_155017_.recyclingTotalTime = AbstractRecyclerBlockEntity.getTotalRecyclingTime(p_155014_, p_155017_.recipeType, (Container)p_155017_);
                    if (p_155017_.burn(recipe, p_155017_.items, i)) {
                        p_155017_.m_6029_(recipe);
                    }
                    flag1 = true;
                }
            } else {
                p_155017_.recyclingProgress = 0;
            }
        } else if (!p_155017_.isLit() && p_155017_.recyclingProgress > 0) {
            p_155017_.recyclingProgress = Mth.m_14045_((int)(p_155017_.recyclingProgress - 2), (int)0, (int)p_155017_.recyclingTotalTime);
        }
        if (flag != p_155017_.isLit()) {
            flag1 = true;
            p_155016_ = (BlockState)p_155016_.m_61124_((Property)AbstractFurnaceBlock.f_48684_, (Comparable)Boolean.valueOf(p_155017_.isLit()));
            p_155014_.m_7731_(p_155015_, p_155016_, 3);
        }
        if (flag1) {
            AbstractRecyclerBlockEntity.m_155232_((Level)p_155014_, (BlockPos)p_155015_, (BlockState)p_155016_);
        }
    }

    private boolean canBurn(@Nullable Recipe<?> p_155006_, NonNullList<ItemStack> p_155007_, int p_155008_) {
        if (!((ItemStack)p_155007_.get(0)).m_41619_() && p_155006_ != null) {
            ItemStack itemstack = p_155006_.m_5874_((Container)this);
            if (itemstack.m_41619_()) {
                return false;
            }
            ItemStack itemstack1 = (ItemStack)p_155007_.get(2);
            if (itemstack1.m_41619_()) {
                return true;
            }
            if (!itemstack1.m_41656_(itemstack)) {
                return false;
            }
            if (itemstack1.m_41613_() + itemstack.m_41613_() <= p_155008_ && itemstack1.m_41613_() + itemstack.m_41613_() <= itemstack1.m_41741_()) {
                return true;
            }
            return itemstack1.m_41613_() + itemstack.m_41613_() <= itemstack.m_41741_();
        }
        return false;
    }

    private boolean burn(@Nullable Recipe<?> p_155027_, NonNullList<ItemStack> p_155028_, int p_155029_) {
        if (p_155027_ != null && this.canBurn(p_155027_, p_155028_, p_155029_)) {
            ItemStack itemstack = (ItemStack)p_155028_.get(0);
            ItemStack itemstack1 = p_155027_.m_5874_((Container)this);
            ItemStack itemstack2 = (ItemStack)p_155028_.get(2);
            if (itemstack2.m_41619_()) {
                p_155028_.set(2, (Object)itemstack1.m_41777_());
            } else if (itemstack2.m_150930_(itemstack1.m_41720_())) {
                itemstack2.m_41769_(itemstack1.m_41613_());
            }
            if (itemstack.m_150930_(Blocks.f_50057_.m_5456_()) && !((ItemStack)p_155028_.get(1)).m_41619_() && ((ItemStack)p_155028_.get(1)).m_150930_(Items.f_42446_)) {
                p_155028_.set(1, (Object)new ItemStack((ItemLike)Items.f_42447_));
            }
            itemstack.m_41774_(1);
            return true;
        }
        return false;
    }

    protected int getBurnDuration(ItemStack p_58343_) {
        if (p_58343_.m_41619_()) {
            return 0;
        }
        Item item = p_58343_.m_41720_();
        return ForgeHooks.getBurnTime((ItemStack)p_58343_, this.recipeType);
    }

    private static int getTotalRecyclingTime(Level p_155010_, RecipeType<? extends AbstractRecyclingRecipe> p_155011_, Container p_155012_) {
        return p_155010_.m_7465_().m_44015_(p_155011_, p_155012_, p_155010_).map(AbstractRecyclingRecipe::getRecyclingTime).orElse(200);
    }

    public static boolean isFuel(ItemStack p_58400_) {
        return ForgeHooks.getBurnTime((ItemStack)p_58400_, null) > 0;
    }

    public int[] m_7071_(Direction p_58363_) {
        if (p_58363_ == Direction.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        return p_58363_ == Direction.UP ? SLOTS_FOR_UP : SLOTS_FOR_SIDES;
    }

    public boolean m_7155_(int p_58336_, ItemStack p_58337_, @Nullable Direction p_58338_) {
        return this.m_7013_(p_58336_, p_58337_);
    }

    public boolean m_7157_(int p_58392_, ItemStack p_58393_, Direction p_58394_) {
        if (p_58394_ == Direction.DOWN && p_58392_ == 1) {
            return p_58393_.m_150930_(Items.f_42447_) || p_58393_.m_150930_(Items.f_42446_);
        }
        return true;
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int p_58328_) {
        return (ItemStack)this.items.get(p_58328_);
    }

    public ItemStack m_7407_(int p_58330_, int p_58331_) {
        return ContainerHelper.m_18969_(this.items, (int)p_58330_, (int)p_58331_);
    }

    public ItemStack m_8016_(int p_58387_) {
        return ContainerHelper.m_18966_(this.items, (int)p_58387_);
    }

    public void m_6836_(int p_58333_, ItemStack p_58334_) {
        ItemStack itemstack = (ItemStack)this.items.get(p_58333_);
        boolean flag = !p_58334_.m_41619_() && p_58334_.m_41656_(itemstack) && ItemStack.m_41658_((ItemStack)p_58334_, (ItemStack)itemstack);
        this.items.set(p_58333_, (Object)p_58334_);
        if (p_58334_.m_41613_() > this.m_6893_()) {
            p_58334_.m_41764_(this.m_6893_());
        }
        if (p_58333_ == 0 && !flag) {
            this.recyclingTotalTime = AbstractRecyclerBlockEntity.getTotalRecyclingTime(this.f_58857_, this.recipeType, (Container)this);
            this.recyclingProgress = 0;
            this.m_6596_();
        }
    }

    public boolean m_6542_(Player p_58340_) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return p_58340_.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public boolean m_7013_(int p_58389_, ItemStack p_58390_) {
        if (p_58389_ == 2) {
            return false;
        }
        if (p_58389_ != 1) {
            return true;
        }
        ItemStack itemstack = (ItemStack)this.items.get(1);
        return ForgeHooks.getBurnTime((ItemStack)p_58390_, this.recipeType) > 0 || p_58390_.m_150930_(Items.f_42446_) && !itemstack.m_150930_(Items.f_42446_);
    }

    public void m_6211_() {
        this.items.clear();
    }

    public void m_6029_(@Nullable Recipe<?> p_58345_) {
        if (p_58345_ != null) {
            ResourceLocation resourcelocation = p_58345_.m_6423_();
            this.recipesUsed.addTo((Object)resourcelocation, 1);
        }
    }

    @Nullable
    public Recipe<?> m_7928_() {
        return null;
    }

    public void m_8015_(Player p_58396_) {
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer p_155004_) {
        List<Recipe<?>> list = this.getRecipesToAwardAndPopExperience(p_155004_.m_9236_(), p_155004_.m_20182_());
        p_155004_.m_7281_(list);
        this.recipesUsed.clear();
    }

    public List<Recipe<?>> getRecipesToAwardAndPopExperience(ServerLevel p_154996_, Vec3 p_154997_) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            p_154996_.m_7465_().m_44043_((ResourceLocation)entry.getKey()).ifPresent(p_155023_ -> {
                list.add(p_155023_);
                AbstractRecyclerBlockEntity.createExperience(p_154996_, p_154997_, entry.getIntValue(), ((AbstractRecyclingRecipe)p_155023_).getExperience());
            });
        }
        return list;
    }

    private static void createExperience(ServerLevel p_154999_, Vec3 p_155000_, int p_155001_, float p_155002_) {
        int i = Mth.m_14143_((float)((float)p_155001_ * p_155002_));
        float f = Mth.m_14187_((float)((float)p_155001_ * p_155002_));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        ExperienceOrb.m_147082_((ServerLevel)p_154999_, (Vec3)p_155000_, (int)i);
    }

    public void m_5809_(StackedContents p_58342_) {
        for (ItemStack itemstack : this.items) {
            p_58342_.m_36491_(itemstack);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (int x = 0; x < this.handlers.length; ++x) {
            this.handlers[x].invalidate();
        }
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    }
}

