/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.client.render.pose;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ttv.migami.jeg.client.render.IHeldAnimation;
import ttv.migami.jeg.client.util.RenderUtil;

public class OneHandedPose
implements IHeldAnimation {
    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void applyPlayerModelRotation(Player player, ModelPart rightArm, ModelPart leftArm, ModelPart head, InteractionHand hand, float aimProgress) {
        boolean right = Minecraft.m_91087_().f_91066_.m_232107_().m_231551_() == HumanoidArm.RIGHT ? hand == InteractionHand.MAIN_HAND : hand == InteractionHand.OFF_HAND;
        ModelPart arm = right ? rightArm : leftArm;
        IHeldAnimation.copyModelAngles(head, arm);
        arm.f_104203_ += (float)Math.toRadians(-70.0);
        if (player.m_21211_().m_41720_() == Items.f_42740_) {
            arm.f_104203_ = (float)Math.toRadians(-30.0);
        }
    }

    @Override
    public void renderFirstPersonArms(Player player, HumanoidArm hand, ItemStack stack, PoseStack poseStack, MultiBufferSource buffer, int light, float partialTicks) {
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        BakedModel model = Minecraft.m_91087_().m_91291_().m_174264_(stack, player.f_19853_, (LivingEntity)player, 0);
        float translateX = model.m_7442_().f_111790_.f_111756_.m_122239_();
        float translateZ = model.m_7442_().f_111790_.f_111756_.m_122269_();
        int side = hand.m_20828_() == HumanoidArm.RIGHT ? 1 : -1;
        poseStack.m_85837_((double)(translateX * (float)side), 0.0, (double)(-translateZ - 0.25f));
        boolean slim = Minecraft.m_91087_().f_91074_.m_108564_().equals("slim");
        float armWidth = slim ? 3.0f : 4.0f;
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        poseStack.m_85837_(-0.25 * (double)side, 0.0, 0.0);
        poseStack.m_85837_(-((double)armWidth / 2.0) * 0.0625 * (double)side, 0.0, 0.0);
        poseStack.m_85837_(0.0, 0.15, -1.3125);
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(75.0f));
        RenderUtil.renderFirstPersonArm((LocalPlayer)player, hand, poseStack, buffer, light);
    }

    @Override
    public boolean applyOffhandTransforms(Player player, PlayerModel model, ItemStack stack, PoseStack poseStack, float partialTicks) {
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        if (player.m_6047_()) {
            poseStack.m_85837_(-0.28125, -0.9375, -0.25);
        } else if (!player.m_6844_(EquipmentSlot.LEGS).m_41619_()) {
            poseStack.m_85837_(-0.25, -0.8125, 0.0625);
        } else {
            poseStack.m_85837_(-0.21875, -0.8125, 0.0625);
        }
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(75.0f));
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_((float)(Math.toDegrees(model.f_102813_.f_104203_) / 10.0)));
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        return true;
    }

    @Override
    public boolean canApplySprintingAnimation() {
        return true;
    }

    @Override
    public boolean canRenderOffhandItem() {
        return true;
    }

    @Override
    public double getFallSwayZOffset() {
        return 0.5;
    }
}

