/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.common;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import ttv.migami.jeg.client.render.IHeldAnimation;
import ttv.migami.jeg.client.render.pose.BazookaPose;
import ttv.migami.jeg.client.render.pose.MiniGunPose;
import ttv.migami.jeg.client.render.pose.OneHandedPose;
import ttv.migami.jeg.client.render.pose.TwoHandedPose;

public class GripType {
    public static final GripType ONE_HANDED = new GripType(new ResourceLocation("jeg", "one_handed"), new OneHandedPose());
    public static final GripType TWO_HANDED = new GripType(new ResourceLocation("jeg", "two_handed"), new TwoHandedPose());
    public static final GripType MINI_GUN = new GripType(new ResourceLocation("jeg", "mini_gun"), new MiniGunPose());
    public static final GripType BAZOOKA = new GripType(new ResourceLocation("jeg", "bazooka"), new BazookaPose());
    private static Map<ResourceLocation, GripType> gripTypeMap = new HashMap<ResourceLocation, GripType>();
    private final ResourceLocation id;
    private final IHeldAnimation heldAnimation;

    public static boolean applyBackTransforms(Player player, PoseStack poseStack) {
        if (player.m_6844_(EquipmentSlot.CHEST).m_41720_() == Items.f_42741_) {
            return false;
        }
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        if (player.m_6047_()) {
            poseStack.m_85837_(0.0, -0.4375, -0.25);
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(30.0f));
        } else {
            poseStack.m_85837_(0.0, -0.3125, -0.125);
        }
        if (!player.m_6844_(EquipmentSlot.CHEST).m_41619_()) {
            poseStack.m_85837_(0.0, 0.0, -0.0625);
        }
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(-45.0f));
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        return true;
    }

    public static void registerType(GripType type) {
        gripTypeMap.putIfAbsent(type.getId(), type);
    }

    public static GripType getType(ResourceLocation id) {
        return gripTypeMap.getOrDefault(id, ONE_HANDED);
    }

    public GripType(ResourceLocation id, IHeldAnimation heldAnimation) {
        this.id = id;
        this.heldAnimation = heldAnimation;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public IHeldAnimation getHeldAnimation() {
        return this.heldAnimation;
    }

    static {
        GripType.registerType(ONE_HANDED);
        GripType.registerType(TWO_HANDED);
        GripType.registerType(MINI_GUN);
        GripType.registerType(BAZOOKA);
    }
}

