/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.entity;

import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import ttv.migami.jeg.init.ModEntities;

public class Bubble
extends Mob {
    private int warmupDelayTicks;
    private int lifeTicks = 140;
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;
    private static final EntityDataAccessor<Boolean> JUST_SPAWNED = SynchedEntityData.m_135353_(Bubble.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DESPAWNING = SynchedEntityData.m_135353_(Bubble.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public Bubble(EntityType<? extends Bubble> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public Bubble(Level pLevel, LivingEntity pPlayer, BlockPos pPos) {
        super((EntityType)ModEntities.BUBBLE.get(), pLevel);
        this.m_146884_(Vec3.m_82512_((Vec3i)pPos.m_7637_(0.5, -0.5, 0.5)));
        this.setOwner(pPlayer);
        this.f_19794_ = true;
    }

    public void setOwner(@javax.annotation.Nullable LivingEntity pOwner) {
        this.owner = pOwner;
        this.ownerUUID = pOwner == null ? null : pOwner.m_20148_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(JUST_SPAWNED, (Object)true);
        this.f_19804_.m_135372_(DESPAWNING, (Object)false);
    }

    public void m_7378_(CompoundTag pCompound) {
    }

    public void m_7380_(CompoundTag pCompound) {
    }

    public void m_8119_() {
        super.m_8119_();
        Level level = this.f_19853_;
        if (!level.f_46443_) {
            BlockPos blockAbove = this.m_20183_().m_6630_(4);
            BlockPos blockJustAbove = this.m_20183_().m_6630_(3);
            BlockPos emergencyBrake = this.m_20183_().m_6630_(2);
            if (level.m_8055_(blockAbove).m_60804_((BlockGetter)level, blockAbove) || level.m_8055_(blockAbove).m_60804_((BlockGetter)level, blockJustAbove) || level.m_8055_(blockAbove).m_60804_((BlockGetter)level, emergencyBrake)) {
                this.m_20334_(0.0, 0.0, 0.0);
            } else {
                this.m_20334_(0.0, 0.1, 0.0);
            }
            List collidedEntities = level.m_45933_((Entity)this, this.m_20191_());
            for (Entity entity : collidedEntities) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                if (entity instanceof Bubble) {
                    this.m_142687_(Entity.RemovalReason.KILLED);
                    this.onDeath();
                }
                if (livingEntity.m_6060_()) {
                    livingEntity.m_20095_();
                    ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123796_, livingEntity.m_20185_(), livingEntity.m_20186_() + 1.0, livingEntity.m_20189_(), 6, 0.3, 0.3, 0.3, 0.0);
                }
                if (entity instanceof Player) {
                    entity.m_20329_((Entity)this);
                } else {
                    livingEntity.m_20329_((Entity)this);
                }
                livingEntity.m_20301_(livingEntity.m_6062_());
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 20, 0, false, false));
                if (!livingEntity.m_5842_()) continue;
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 20, 0, false, false));
            }
            ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123804_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 1.0, 0.0, 1.0, 0.0);
            if (--this.warmupDelayTicks < 0) {
                --this.lifeTicks;
                if (this.warmupDelayTicks == -1) {
                    this.setJustSpawned(true);
                    level.m_5594_(null, this.m_20183_(), SoundEvents.f_12278_, SoundSource.PLAYERS, 2.0f, 1.0f);
                }
                if (this.lifeTicks < 20) {
                    this.setJustSpawned(false);
                    this.setDespawning(true);
                }
                if (this.lifeTicks < 0) {
                    this.m_146870_();
                }
            }
        }
    }

    public void onDeath() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 2.0);
    }

    public void setJustSpawned(boolean justSpawned) {
        this.f_19804_.m_135381_(JUST_SPAWNED, (Object)justSpawned);
    }

    public boolean justSpawned() {
        return (Boolean)this.f_19804_.m_135370_(JUST_SPAWNED);
    }

    public void setDespawning(boolean despawning) {
        this.f_19804_.m_135381_(DESPAWNING, (Object)despawning);
    }

    public boolean despawning() {
        return (Boolean)this.f_19804_.m_135370_(DESPAWNING);
    }
}

