/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.entity;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;
import ttv.migami.jeg.common.ModTags;
import ttv.migami.jeg.init.ModEntities;

public class Splash
extends Entity {
    private int warmupDelayTicks;
    private int lifeTicks = 70;
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;
    private float damage = 2.5f;
    private Set<Entity> damagedEntities = new HashSet<Entity>();
    public int textureIndex = 0;
    private int tickCounter = 0;
    private static final EntityDataAccessor<Integer> TEXTURE_INDEX = SynchedEntityData.m_135353_(Splash.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> JUST_SPAWNED = SynchedEntityData.m_135353_(Splash.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DESPAWNING = SynchedEntityData.m_135353_(Splash.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public Splash(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public Splash(Level pLevel, LivingEntity pPlayer, BlockPos pPos) {
        super((EntityType)ModEntities.SPLASH.get(), pLevel);
        this.m_146884_(Vec3.m_82512_((Vec3i)pPos.m_7637_(0.5, -0.5, 0.5)));
        this.setOwner(pPlayer);
    }

    public Splash(Level pLevel, LivingEntity pPlayer, BlockPos pPos, int lifetime) {
        super((EntityType)ModEntities.SPLASH.get(), pLevel);
        this.m_146884_(Vec3.m_82512_((Vec3i)pPos.m_7637_(0.5, -0.5, 0.5)));
        this.setOwner(pPlayer);
        this.lifeTicks = lifetime;
        this.damage = 8.0f;
    }

    public void setOwner(@javax.annotation.Nullable LivingEntity pOwner) {
        this.owner = pOwner;
        this.ownerUUID = pOwner == null ? null : pOwner.m_20148_();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(TEXTURE_INDEX, (Object)0);
        this.f_19804_.m_135372_(JUST_SPAWNED, (Object)true);
        this.f_19804_.m_135372_(DESPAWNING, (Object)false);
    }

    protected void m_7378_(CompoundTag pCompound) {
    }

    protected void m_7380_(CompoundTag pCompound) {
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_8119_() {
        super.m_8119_();
        Level level = this.f_19853_;
        if (!level.f_46443_) {
            ++this.tickCounter;
            if (this.tickCounter % 3 == 0) {
                this.tickCounter = 0;
                this.textureIndex = (this.textureIndex + 1) % 6;
            }
            this.setTextureIndex(this.textureIndex);
            int radius = 5;
            BlockPos entityPos = this.m_20183_();
            for (int x = -radius; x <= radius; ++x) {
                for (int y = -radius; y <= radius; ++y) {
                    for (int z = -radius; z <= radius; ++z) {
                        BlockPos blockPos = entityPos.m_7918_(x, y, z);
                        BlockState blockState = level.m_8055_(blockPos);
                        if (!(blockState.m_60734_() instanceof FireBlock)) continue;
                        level.m_5594_(null, this.m_20183_(), SoundEvents.f_11937_, SoundSource.PLAYERS, 0.05f, 1.0f);
                        level.m_46597_(blockPos, Blocks.f_50016_.m_49966_());
                    }
                }
            }
            List collidedEntities = level.m_45933_((Entity)this, this.m_20191_());
            for (Entity entity : collidedEntities) {
                if (!(entity instanceof LivingEntity) || entity == this.owner) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                if (livingEntity.m_6060_()) {
                    livingEntity.m_20095_();
                    ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123796_, livingEntity.m_20185_(), livingEntity.m_20186_() + 1.0, livingEntity.m_20189_(), 6, 0.3, 0.3, 0.3, 0.0);
                }
                if (this.getTextureIndex() == 3) {
                    if (livingEntity.m_6095_().m_204039_(ModTags.Entities.FIRE)) {
                        livingEntity.m_6469_(new DamageSource("generic"), this.damage * 2.0f);
                    } else {
                        livingEntity.m_6469_(new DamageSource("generic"), this.damage);
                    }
                }
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 3, false, true));
                this.markAsDamaged((Entity)livingEntity);
            }
            ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 3, 1.5, 2.0, 1.5, 0.1);
            if (this.getTextureIndex() == 3 && this.tickCounter % 4 == 0 && this.f_19797_ > 20) {
                level.m_5594_(null, this.m_20183_(), SoundEvents.f_12278_, SoundSource.PLAYERS, 2.0f, 1.0f);
            }
            if (--this.warmupDelayTicks < 0) {
                --this.lifeTicks;
                if (this.warmupDelayTicks == -1) {
                    this.setJustSpawned(true);
                    ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_(), this.m_20186_() + 2.0, this.m_20189_(), 50, 1.5, 2.0, 1.5, 1.0);
                    level.m_5594_(null, this.m_20183_(), SoundEvents.f_12278_, SoundSource.PLAYERS, 2.0f, 1.0f);
                }
                if (this.lifeTicks < 20) {
                    this.setJustSpawned(false);
                    this.setDespawning(true);
                }
                if (this.lifeTicks < 0) {
                    this.m_146870_();
                }
            }
        }
    }

    private boolean hasBeenDamaged(Entity entity) {
        return this.damagedEntities.contains(entity);
    }

    private void markAsDamaged(Entity entity) {
        this.damagedEntities.add(entity);
    }

    public void setTextureIndex(int textureIndex) {
        this.f_19804_.m_135381_(TEXTURE_INDEX, (Object)textureIndex);
    }

    public int getTextureIndex() {
        return (Integer)this.f_19804_.m_135370_(TEXTURE_INDEX);
    }

    public void setJustSpawned(boolean justSpawned) {
        this.f_19804_.m_135381_(JUST_SPAWNED, (Object)justSpawned);
    }

    public boolean justSpawned() {
        return (Boolean)this.f_19804_.m_135370_(JUST_SPAWNED);
    }

    public void setDespawning(boolean despawning) {
        this.f_19804_.m_135381_(DESPAWNING, (Object)despawning);
    }

    public boolean despawning() {
        return (Boolean)this.f_19804_.m_135370_(DESPAWNING);
    }
}

