/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.entity.projectile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import ttv.migami.jeg.Config;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.entity.Splash;
import ttv.migami.jeg.entity.projectile.ProjectileEntity;
import ttv.migami.jeg.init.ModParticleTypes;
import ttv.migami.jeg.interfaces.IExplosionDamageable;
import ttv.migami.jeg.item.GunItem;
import ttv.migami.jeg.world.ProjectileExplosion;

public class WhirpoolEntity
extends ProjectileEntity {
    public WhirpoolEntity(EntityType<? extends ProjectileEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public WhirpoolEntity(EntityType<? extends ProjectileEntity> entityType, Level worldIn, LivingEntity shooter, ItemStack weapon, GunItem item, Gun modifiedGun) {
        super(entityType, worldIn, shooter, weapon, item, modifiedGun);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
    }

    @Override
    protected void onProjectileTick() {
        block4: {
            if (!this.f_19853_.f_46443_ || this.f_19797_ >= this.life || this.f_19797_ <= 2) break block4;
            this.f_19853_.m_6493_((ParticleOptions)ModParticleTypes.TYPHOONEE_BEAM.get(), true, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            if (this.m_5842_()) {
                for (int i = 0; i < 2; ++i) {
                    this.f_19853_.m_6493_((ParticleOptions)ParticleTypes.f_123795_, true, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                    this.f_19853_.m_6493_((ParticleOptions)ParticleTypes.f_123795_, true, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                }
            } else {
                for (int i = 0; i < 2; ++i) {
                    this.f_19853_.m_6493_((ParticleOptions)ParticleTypes.f_123769_, true, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                    this.f_19853_.m_6493_((ParticleOptions)ParticleTypes.f_123769_, true, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    protected void onHitEntity(Entity entity, Vec3 hitVec, Vec3 startVec, Vec3 endVec, boolean headshot) {
        if (this.m_5842_()) {
            WhirpoolEntity.createWhirpool(this, ((Double)Config.COMMON.missiles.explosionRadius.get()).floatValue(), false);
        } else {
            WhirpoolEntity.createLandWhirpool(this, this.shooter, new BlockPos(entity.m_20318_(1.0f)));
        }
    }

    @Override
    protected void onHitBlock(BlockState state, BlockPos pos, Direction face, double x, double y, double z) {
        if (this.m_5842_()) {
            WhirpoolEntity.createWhirpool(this, ((Double)Config.COMMON.missiles.explosionRadius.get()).floatValue(), false);
        } else {
            WhirpoolEntity.createLandWhirpool(this, this.shooter, new BlockPos(this.m_20318_(1.0f)));
        }
    }

    @Override
    public void onExpired() {
        if (this.m_5842_()) {
            WhirpoolEntity.createWhirpool(this, ((Double)Config.COMMON.missiles.explosionRadius.get()).floatValue(), false);
        }
    }

    public static void createWhirpool(Entity entity, float radius, boolean forceNone) {
        DamageSource damageSource;
        Level world = entity.f_19853_;
        if (world.m_5776_()) {
            return;
        }
        if (entity instanceof ProjectileEntity) {
            ProjectileEntity projectile = (ProjectileEntity)entity;
            damageSource = DamageSource.m_19373_((LivingEntity)projectile.getShooter());
        } else {
            damageSource = null;
        }
        DamageSource source = damageSource;
        Explosion.BlockInteraction mode = (Boolean)Config.COMMON.gameplay.griefing.enableBlockRemovalOnExplosions.get() != false && !forceNone ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE;
        ProjectileExplosion explosion = new ProjectileExplosion(world, entity, source, null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), radius / 2.0f, false, mode);
        if (ForgeEventFactory.onExplosionStart((Level)world, (Explosion)explosion)) {
            return;
        }
        explosion.m_46061_();
        explosion.m_46075_(true);
        explosion.m_46081_().forEach(pos -> {
            if (world.m_8055_(pos).m_60734_() instanceof IExplosionDamageable) {
                ((IExplosionDamageable)world.m_8055_(pos).m_60734_()).onProjectileExploded(world, world.m_8055_(pos), (BlockPos)pos, entity);
            }
        });
        if (mode == Explosion.BlockInteraction.NONE) {
            explosion.m_46080_();
        }
        for (ServerPlayer player : ((ServerLevel)world).m_6907_()) {
            if (!(player.m_20275_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_()) < 4096.0)) continue;
            player.f_8906_.m_9829_((Packet)new ClientboundExplodePacket(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), radius, explosion.m_46081_(), (Vec3)explosion.m_46078_().get(player)));
        }
    }

    public static void createLandWhirpool(Entity entity, LivingEntity player, BlockPos pos) {
        Level world = entity.f_19853_;
        world.m_7967_((Entity)new Splash(world, player, pos));
    }
}

