/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.event;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ttv.migami.jeg.Config;
import ttv.migami.jeg.common.FireMode;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.common.ModTags;
import ttv.migami.jeg.event.GunFireEvent;
import ttv.migami.jeg.init.ModEffects;
import ttv.migami.jeg.init.ModItems;
import ttv.migami.jeg.init.ModParticleTypes;
import ttv.migami.jeg.init.ModSounds;
import ttv.migami.jeg.item.GunItem;
import ttv.migami.jeg.item.TyphooneeItem;
import ttv.migami.jeg.item.UnderwaterFirearmItem;
import ttv.migami.jeg.item.attachment.IAttachment;
import ttv.migami.jeg.util.GunModifierHelper;

@Mod.EventBusSubscriber(modid="jeg", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class GunEventBus {
    static final Map<UUID, Long> runningPlayers = new HashMap<UUID, Long>();
    private static final long RUN_DURATION_THRESHOLD = 2000L;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Item item;
            Player player = event.player;
            UUID playerId = player.m_20148_();
            if (player.m_20142_() && (item = player.m_21205_().m_41720_()) instanceof GunItem) {
                Item item2;
                GunItem gunItem = (GunItem)item;
                long currentTime = System.currentTimeMillis();
                runningPlayers.putIfAbsent(playerId, currentTime);
                ItemCooldowns tracker = player.m_36335_();
                if (currentTime - runningPlayers.get(playerId) >= 2000L && !tracker.m_41519_((Item)gunItem) && !player.m_21023_(MobEffects.f_19597_) && (item2 = Gun.getAttachment(IAttachment.Type.BARREL, player.m_21205_()).m_41720_()) instanceof SwordItem) {
                    SwordItem swordItem = (SwordItem)item2;
                    ItemStack bayonet = Gun.getAttachment(IAttachment.Type.BARREL, player.m_21205_());
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 10, 0, false, false));
                    float damage = swordItem.m_43299_();
                    int maxDamage = bayonet.m_41776_();
                    int currentDamage = bayonet.m_41773_();
                    if ((double)currentDamage >= (double)maxDamage / 1.5) {
                        damage = 0.0f;
                    }
                    damage += (float)bayonet.getEnchantmentLevel(Enchantments.f_44977_);
                    if (runningPlayers.containsKey(playerId)) {
                        AABB boundingBox = player.m_20191_().m_82400_(1.5);
                        float finalDamage = damage;
                        player.f_19853_.m_45933_((Entity)player, boundingBox).forEach(entity -> {
                            if (entity != player && entity instanceof LivingEntity) {
                                LivingEntity target = (LivingEntity)entity;
                                if (target.f_19802_ == 0) {
                                    Vec3 direction = entity.m_20182_().m_82546_(player.m_20182_()).m_82541_();
                                    player.f_19802_ = 40;
                                    if (GunModifierHelper.getSwordSweepingEdge(player) < 2) {
                                        player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 2, false, false));
                                    }
                                    target.m_5997_(direction.f_82479_ * (double)GunModifierHelper.getSwordKnockBack(player), 0.5, direction.f_82481_ * (double)GunModifierHelper.getSwordKnockBack(player));
                                    if ((double)currentDamage <= (double)maxDamage / 1.5) {
                                        Level patt5586$temp;
                                        target.m_6469_(new DamageSource("generic"), GunModifierHelper.getSwordDamage(player) / 1.5f);
                                        player.f_19853_.m_5594_(null, player.m_20097_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 2.0f, 1.0f);
                                        if (GunModifierHelper.getSwordFireAspect(player) > 0) {
                                            entity.m_20254_(2 * GunModifierHelper.getSwordFireAspect(player));
                                        }
                                        if ((patt5586$temp = player.f_19853_) instanceof ServerLevel) {
                                            ServerLevel serverLevel = (ServerLevel)patt5586$temp;
                                            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123798_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (int)finalDamage, 0.3, (double)entity.m_20206_(), 0.3, 0.2);
                                        }
                                    } else {
                                        player.f_19853_.m_5594_(player, player.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 3.0f, 1.0f);
                                    }
                                    Vec3 pushBackDirection = player.m_20182_().m_82546_(target.m_20182_()).m_82541_();
                                    double pushBackForce = 1.0;
                                    if (GunModifierHelper.getSwordSweepingEdge(player) < 3) {
                                        player.m_5997_(pushBackDirection.f_82479_ * pushBackForce, 0.5, pushBackDirection.f_82481_ * pushBackForce);
                                    }
                                    if (!player.m_150110_().f_35937_ && ((Boolean)Config.COMMON.gameplay.gunDurability.get()).booleanValue() && (double)currentDamage <= (double)maxDamage / 1.5) {
                                        bayonet.m_41622_(15, (LivingEntity)player, null);
                                    }
                                }
                            }
                        });
                        Vec3 start = player.m_20299_(1.0f);
                        Vec3 look = player.m_20154_();
                        Vec3 end = start.m_82549_(look.m_82490_(0.5));
                        BlockHitResult hitResult = player.f_19853_.m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
                        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
                            Vec3 pushBackDirection = player.m_20154_().m_82541_().m_82490_(-1.0);
                            double pushBackForce = 1.0;
                            player.f_19853_.m_5594_(player, player.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 3.0f, 1.0f);
                            player.m_5997_(pushBackDirection.f_82479_ * pushBackForce, 0.5, pushBackDirection.f_82481_ * pushBackForce);
                        }
                    }
                }
            } else {
                runningPlayers.remove(playerId);
            }
        }
    }

    @SubscribeEvent
    public static void preShoot(GunFireEvent.Pre event) {
        Player player = event.getEntity();
        Level level = event.getEntity().f_19853_;
        ItemStack heldItem = player.m_21205_();
        CompoundTag tag = heldItem.m_41783_();
        Item item = heldItem.m_41720_();
        if (item instanceof GunItem) {
            ItemCooldowns tracker;
            GunItem gunItem = (GunItem)item;
            Gun gun = gunItem.getModifiedGun(heldItem);
            if (!(heldItem.m_41720_() instanceof UnderwaterFirearmItem) && player.m_5842_() && !((Boolean)Config.COMMON.gameplay.underwaterFiring.get()).booleanValue()) {
                event.setCanceled(true);
            }
            if ((tracker = player.m_36335_()).m_41519_(heldItem.m_41720_()) && gun.getGeneral().getFireMode() == FireMode.PULSE) {
                event.setCanceled(true);
            }
            if (heldItem.m_41763_() && tag != null) {
                if (heldItem.m_41773_() == heldItem.m_41776_() - 1) {
                    level.m_5594_(player, player.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    event.getEntity().m_36335_().m_41524_(event.getStack().m_41720_(), gun.getGeneral().getRate());
                    event.setCanceled(true);
                }
                int maxDamage = heldItem.m_41776_();
                int currentDamage = heldItem.m_41773_();
                if ((double)currentDamage >= (double)maxDamage / 1.5 && ((Boolean)Config.COMMON.gameplay.gunJamming.get()).booleanValue()) {
                    if (Math.random() >= 0.975) {
                        event.getEntity().m_5496_((SoundEvent)ModSounds.ITEM_PISTOL_COCK.get(), 1.0f, 1.0f);
                        int coolDown = gun.getGeneral().getRate() * 10;
                        if (coolDown > 60) {
                            coolDown = 60;
                        }
                        event.getEntity().m_36335_().m_41524_(event.getStack().m_41720_(), coolDown);
                        event.setCanceled(true);
                    }
                } else if (tag.m_128451_("AmmoCount") >= 1) {
                    GunEventBus.broken(heldItem, level, player);
                }
            }
        }
    }

    @SubscribeEvent
    public static void postShoot(GunFireEvent.Post event) {
        Player player = event.getEntity();
        Level level = event.getEntity().f_19853_;
        ItemStack heldItem = player.m_21205_();
        CompoundTag tag = heldItem.m_41783_();
        Item item = heldItem.m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            Gun gun = gunItem.getModifiedGun(heldItem);
            if (gun.getProjectile().ejectsCasing() && tag != null && (tag.m_128451_("AmmoCount") >= 1 || player.m_150110_().f_35937_)) {
                GunEventBus.ejectCasing(level, (LivingEntity)player);
            }
            if (heldItem.m_41763_() && tag != null) {
                if (tag.m_128451_("AmmoCount") >= 1 && ((Boolean)Config.COMMON.gameplay.gunDurability.get()).booleanValue()) {
                    GunEventBus.damageGun(heldItem, level, player);
                    GunEventBus.damageAttachments(heldItem, level, player);
                }
                if ((double)heldItem.m_41773_() >= (double)heldItem.m_41776_() / 1.5) {
                    level.m_5594_(player, player.m_20183_(), SoundEvents.f_11668_, SoundSource.PLAYERS, 0.5f, 1.75f);
                }
            }
            float damage = gun.getProjectile().getDamage();
            if (gunItem instanceof UnderwaterFirearmItem && tag != null && gunItem instanceof TyphooneeItem) {
                GunEventBus.typhooneeBlast(level, player, damage);
            }
        }
    }

    public static void broken(ItemStack stack, Level level, Player player) {
        int maxDamage = stack.m_41776_();
        int currentDamage = stack.m_41773_();
        if (currentDamage >= maxDamage - 2) {
            level.m_5594_(player, player.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public static void damageGun(ItemStack stack, Level level, Player player) {
        if (!player.m_150110_().f_35937_ && stack.m_41763_()) {
            int maxDamage = stack.m_41776_();
            int currentDamage = stack.m_41773_();
            if (currentDamage >= maxDamage - 1) {
                if (currentDamage >= maxDamage - 2) {
                    level.m_5594_(player, player.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            } else {
                stack.m_41622_(1, (LivingEntity)player, null);
            }
        }
    }

    public static void damageAttachments(ItemStack stack, Level level, Player player) {
        if (!player.m_150110_().f_35937_ && stack.m_41720_() instanceof GunItem) {
            ItemStack scopeStack = Gun.getAttachment(IAttachment.Type.SCOPE, stack);
            if (Gun.hasAttachmentEquipped(stack, IAttachment.Type.SCOPE) && scopeStack.m_41763_()) {
                int maxDamage = scopeStack.m_41776_();
                int currentDamage = scopeStack.m_41773_();
                if (currentDamage == maxDamage - 1) {
                    level.m_5594_(player, player.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    Gun.removeAttachment(stack, "Scope");
                } else {
                    scopeStack.m_41622_(1, (LivingEntity)player, null);
                }
            }
            ItemStack barrelStack = Gun.getAttachment(IAttachment.Type.BARREL, stack);
            if (Gun.hasAttachmentEquipped(stack, IAttachment.Type.BARREL) && barrelStack.m_41763_() && !(barrelStack.m_41720_() instanceof SwordItem)) {
                int maxDamage = barrelStack.m_41776_();
                int currentDamage = barrelStack.m_41773_();
                if (currentDamage == maxDamage - 1) {
                    level.m_5594_(player, player.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    Gun.removeAttachment(stack, "Barrel");
                } else {
                    barrelStack.m_41622_(1, (LivingEntity)player, null);
                }
            }
            ItemStack stockStack = Gun.getAttachment(IAttachment.Type.STOCK, stack);
            if (Gun.hasAttachmentEquipped(stack, IAttachment.Type.STOCK) && stockStack.m_41763_()) {
                int maxDamage = stockStack.m_41776_();
                int currentDamage = stockStack.m_41773_();
                if (currentDamage == maxDamage - 1) {
                    level.m_5594_(player, player.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    Gun.removeAttachment(stack, "Stock");
                } else {
                    stockStack.m_41622_(1, (LivingEntity)player, null);
                }
            }
            ItemStack underBarrelStack = Gun.getAttachment(IAttachment.Type.UNDER_BARREL, stack);
            if (Gun.hasAttachmentEquipped(stack, IAttachment.Type.UNDER_BARREL) && underBarrelStack.m_41763_()) {
                int maxDamage = underBarrelStack.m_41776_();
                int currentDamage = underBarrelStack.m_41773_();
                if (currentDamage == maxDamage - 1) {
                    level.m_5594_(player, player.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    Gun.removeAttachment(stack, "Under_Barrel");
                } else {
                    underBarrelStack.m_41622_(1, (LivingEntity)player, null);
                }
            }
        }
    }

    public static void typhooneeBlast(Level level, Player player, float damage) {
        if (!level.m_5776_()) {
            Entity z2;
            HitResult result = player.m_19907_(64.0, 0.0f, false);
            Vec3 userPos = player.m_146892_();
            Vec3 targetPos = result.m_82450_();
            Vec3 distanceTo = targetPos.m_82546_(userPos);
            Vec3 normal = distanceTo.m_82541_();
            for (int i = 3; i < Mth.m_14107_((double)distanceTo.m_82553_()); ++i) {
                Vec3 vec33 = userPos.m_82549_(normal.m_82490_((double)i));
                if (!player.m_5842_()) {
                    ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123769_, vec33.f_82479_, vec33.f_82480_, vec33.f_82481_, 3, 0.3, 0.3, 0.3, 1.0);
                    ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123804_, vec33.f_82479_, vec33.f_82480_, vec33.f_82481_, 1, 0.3, 0.3, 0.3, 0.0);
                    ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123796_, vec33.f_82479_, vec33.f_82480_, vec33.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                    ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123796_, vec33.f_82479_, vec33.f_82480_, vec33.f_82481_, 1, 0.4, 0.4, 0.4, 0.4);
                } else {
                    ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123795_, vec33.f_82479_, vec33.f_82480_, vec33.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                    ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123795_, vec33.f_82479_, vec33.f_82480_, vec33.f_82481_, 3, 0.4, 0.4, 0.4, 0.4);
                }
                ((ServerLevel)level).m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.TYPHOONEE_BEAM.get()), vec33.f_82479_, vec33.f_82480_, vec33.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            }
            int radius = 2;
            BlockPos blockPos = new BlockPos(result.m_82450_());
            for (int x = -radius; x <= radius; ++x) {
                for (int y = -radius; y <= radius; ++y) {
                    for (int z2 = -radius; z2 <= radius; ++z2) {
                        BlockPos blockPos2 = blockPos.m_7918_(x, y, z2);
                        BlockState blockState = level.m_8055_(blockPos2);
                        if (!(blockState.m_60734_() instanceof FireBlock)) continue;
                        level.m_46597_(blockPos2, Blocks.f_50016_.m_49966_());
                        level.m_5594_(null, new BlockPos(result.m_82450_()), SoundEvents.f_11937_, SoundSource.PLAYERS, 0.2f, 1.0f);
                    }
                }
            }
            EntityHitResult e = ProjectileUtil.m_37304_((Level)level, (Entity)player, (Vec3)userPos, (Vec3)targetPos, (AABB)new AABB(userPos, targetPos), TyphooneeItem::canDamage);
            if (e != null && (z2 = e.m_82443_()) instanceof LivingEntity) {
                LivingEntity entity = (LivingEntity)z2;
                float advantageMultiplier = 1.0f;
                if (entity.m_6095_().m_204039_(ModTags.Entities.FIRE)) {
                    advantageMultiplier = 2.0f;
                }
                if (entity.m_6060_()) {
                    entity.m_20095_();
                    ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123796_, entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_(), 6, 0.3, 0.3, 0.3, 0.0);
                }
                ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123804_, entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_(), 6, 0.3, 0.3, 0.3, 0.0);
                entity.m_6469_(new DamageSource("generic"), damage * advantageMultiplier);
                double d1 = 0.5 * (1.0 - entity.m_21133_(Attributes.f_22278_));
                double d0 = 2.5 * (1.0 - entity.m_21133_(Attributes.f_22278_));
                entity.m_5997_(normal.m_7096_() * d0, normal.m_7098_() * d1, normal.m_7094_() * d0);
                entity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.DEAFENED.get(), 100, 0, false, false));
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 50));
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 2));
            }
        }
    }

    public static void ejectCasing(Level level, LivingEntity livingEntity) {
        Player playerEntity = (Player)livingEntity;
        ItemStack heldItem = playerEntity.m_21205_();
        Gun gun = ((GunItem)heldItem.m_41720_()).getModifiedGun(heldItem);
        Vec3 lookVec = playerEntity.m_20154_();
        Vec3 rightVec = new Vec3(-lookVec.f_82481_, 0.0, lookVec.f_82479_).m_82541_();
        Vec3 forwardVec = new Vec3(lookVec.f_82479_, 0.0, lookVec.f_82481_).m_82541_();
        double offsetX = rightVec.f_82479_ * 0.5 + forwardVec.f_82479_ * 0.5;
        double offsetY = (double)playerEntity.m_20192_() - 0.4;
        double offsetZ = rightVec.f_82481_ * 0.5 + forwardVec.f_82481_ * 0.5;
        Vec3 particlePos = playerEntity.m_20318_(1.0f).m_82520_(offsetX, offsetY, offsetZ);
        ResourceLocation pistolAmmoLocation = ModItems.PISTOL_AMMO.getId();
        ResourceLocation rifleAmmoLocation = ModItems.RIFLE_AMMO.getId();
        ResourceLocation shotgunShellLocation = ModItems.SHOTGUN_SHELL.getId();
        ResourceLocation spectreAmmoLocation = ModItems.SPECTRE_AMMO.getId();
        ResourceLocation projectileLocation = gun.getProjectile().getItem();
        SimpleParticleType casingType = (SimpleParticleType)ModParticleTypes.CASING_PARTICLE.get();
        if (projectileLocation != null) {
            if (projectileLocation.equals((Object)pistolAmmoLocation) || projectileLocation.equals((Object)rifleAmmoLocation)) {
                casingType = (SimpleParticleType)ModParticleTypes.CASING_PARTICLE.get();
            } else if (projectileLocation.equals((Object)shotgunShellLocation)) {
                casingType = (SimpleParticleType)ModParticleTypes.SHELL_PARTICLE.get();
            } else if (projectileLocation.equals((Object)spectreAmmoLocation)) {
                casingType = (SimpleParticleType)ModParticleTypes.SPECTRE_CASING_PARTICLE.get();
            }
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)casingType, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

