/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.client.render;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ttv.migami.jeg.Config;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.item.GunItem;
import ttv.migami.jeg.util.GunModifierHelper;

@Mod.EventBusSubscriber(modid="jeg", value={Dist.CLIENT})
public class AmmoCounterRenderer {
    protected static final ResourceLocation GUI_ICONS_LOCATION = new ResourceLocation("textures/gui/icons.png");
    private static final int BAR_WIDTH = 100;
    private static final int BAR_HEIGHT = 10;
    private static final int PADDING = 75;
    private static final int SEGMENT_PADDING = 0;

    @SubscribeEvent
    public static void onRenderGameOverlay(RenderGameOverlayEvent.Post event) {
        if (event.isCanceled()) {
            return;
        }
        if (!((Boolean)Config.CLIENT.display.displayAmmoGUI.get()).booleanValue()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player != null) {
            Item heldItem = player.m_21205_().m_41720_();
            ItemStack itemStack = player.m_21205_();
            if (heldItem instanceof GunItem) {
                Gun gun = ((GunItem)player.m_21205_().m_41720_()).getModifiedGun(itemStack);
                CompoundTag tagCompound = itemStack.m_41783_();
                if (minecraft.f_91080_ != null) {
                    return;
                }
                if (tagCompound != null) {
                    Window window = minecraft.m_91268_();
                    int x = minecraft.m_91268_().m_85445_() - 100 - 75 + (Integer)Config.CLIENT.display.displayAmmoGUIXOffset.get();
                    int y = (int)((double)window.m_85446_() * 0.85) + (Integer)Config.CLIENT.display.displayAmmoGUIYOffset.get();
                    int currentAmmo = tagCompound.m_128451_("AmmoCount");
                    int maxAmmo = GunModifierHelper.getModifiedAmmoCapacity(itemStack, gun);
                    MutableComponent name = new TranslatableComponent(itemStack.m_41778_()).m_130940_(ChatFormatting.WHITE);
                    PoseStack poseStack = event.getMatrixStack();
                    if (!((Boolean)Config.CLIENT.display.classicAmmoGUI.get()).booleanValue()) {
                        if (maxAmmo > 100) {
                            AmmoCounterRenderer.drawAmmoBar(poseStack, x, y, currentAmmo, maxAmmo, name, 255);
                        } else {
                            AmmoCounterRenderer.drawSegmentedBar(poseStack, x, y, currentAmmo, maxAmmo, name, 255);
                        }
                    } else {
                        MutableComponent ammoCountValue = new TextComponent(currentAmmo + " / " + GunModifierHelper.getModifiedAmmoCapacity(itemStack, gun)).m_130940_(ChatFormatting.BOLD);
                        minecraft.f_91062_.m_92889_(poseStack, (Component)ammoCountValue, (float)x, (float)y, 0xFFFFFF);
                    }
                    RenderSystem.m_69461_();
                }
            }
        }
    }

    private static void drawAmmoBar(PoseStack poseStack, int x, int y, int currentAmount, int maxAmount, MutableComponent gunName, int alpha) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_ICONS_LOCATION);
        int barColor = alpha << 24 | 0xFFFFFF;
        int backgroundColor = alpha << 24 | 0x3F3F3F;
        int barWidth = (int)(98.0 * ((double)currentAmount / (double)maxAmount));
        AmmoCounterRenderer.fill(poseStack, x, y + 1, x + 1 + barWidth, y + 10, backgroundColor);
        AmmoCounterRenderer.fill(poseStack, x, y + 1, x + 1 + barWidth, y + 10 - 1, barColor);
        Minecraft.m_91087_().f_91062_.m_92889_(poseStack, (Component)gunName, (float)x, (float)(y - 10), 0xFFFFFF);
    }

    private static void drawSegmentedBar(PoseStack poseStack, int x, int y, int currentAmount, int maxAmount, MutableComponent gunName, int alpha) {
        int rowY;
        int rowEndIndex;
        int rowStartIndex;
        int row;
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_ICONS_LOCATION);
        int segmentWidth = (100 - (Math.min(maxAmount, 30) - 1) * 0) / Math.min(maxAmount, 30);
        int barColor = alpha << 24 | 0xFFFFFF;
        int backgroundColor = alpha << 24 | 0x3F3F3F;
        int segmentsPerRow = Math.min(maxAmount, 30);
        int numRows = (int)Math.ceil((double)maxAmount / (double)segmentsPerRow);
        for (row = 0; row < numRows; ++row) {
            int backgroundWidth;
            rowStartIndex = row * segmentsPerRow;
            rowEndIndex = Math.min(rowStartIndex + segmentsPerRow, maxAmount);
            rowY = y + row * 10;
            int n = backgroundWidth = row < numRows - 1 ? segmentsPerRow * segmentWidth + (segmentsPerRow - 1) * 0 : maxAmount % segmentsPerRow * segmentWidth + (maxAmount % segmentsPerRow - 1) * 0;
            if (backgroundWidth == 0) {
                backgroundWidth = segmentsPerRow * segmentWidth + (segmentsPerRow - 1) * 0;
            }
            AmmoCounterRenderer.fill(poseStack, x, rowY + 1, x + backgroundWidth, rowY + 10, backgroundColor);
        }
        for (row = 0; row < numRows; ++row) {
            rowStartIndex = row * segmentsPerRow;
            rowEndIndex = Math.min(rowStartIndex + segmentsPerRow, maxAmount);
            rowY = y + row * 10;
            for (int i = rowStartIndex; i < rowEndIndex; ++i) {
                int segmentX = x - 1 + (i - rowStartIndex) * (segmentWidth + 0);
                if (i >= currentAmount) continue;
                AmmoCounterRenderer.fill(poseStack, segmentX + 1, rowY + 1, segmentX + segmentWidth, rowY + 10 - 1, barColor);
            }
        }
        Minecraft.m_91087_().f_91062_.m_92763_(poseStack, (Component)gunName, (float)x, (float)(y - 10), 0xFFFFFF);
    }

    private static void fill(PoseStack poseStack, int x1, int y1, int x2, int y2, int color) {
        Gui.m_93172_((PoseStack)poseStack, (int)x1, (int)y1, (int)x2, (int)y2, (int)color);
    }
}

