/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.entity.animal;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirRandomPos;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import ttv.migami.jeg.blockentity.BeehiveBlockEntityAbstract;
import ttv.migami.jeg.common.ModTags;
import ttv.migami.jeg.init.ModEntities;
import ttv.migami.jeg.init.ModParticleTypes;
import ttv.migami.jeg.init.ModPointOfInterestTypes;

public class Boo
extends Bee {
    protected Predicate<PoiType> beehiveInterests = poi -> poi == ModPointOfInterestTypes.BOO_NEST.get();
    protected FollowParentGoal followParentGoal;
    protected BreedGoal breedGoal;
    protected EnterHiveGoal enterHiveGoal;
    public final float VANISHING_TIME = 600.0f;
    public float vanishingTime = 600.0f;
    public boolean isExposed = false;

    public Boo(EntityType<? extends Bee> entityType, Level world) {
        super(entityType, world);
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25));
        this.m_21441_(BlockPathTypes.TRAPDOOR, -1.0f);
    }

    protected boolean isSunSensitive() {
        return true;
    }

    protected void m_8099_() {
        this.registerBaseGoals();
        this.f_27699_ = new PollinateGoal();
        this.f_21345_.m_25352_(4, (Goal)this.f_27699_);
        this.f_27701_ = new Bee.BeeGoToKnownFlowerGoal((Bee)this);
        this.f_21345_.m_25352_(6, (Goal)this.f_27701_);
        this.f_21345_.m_25352_(7, (Goal)new Bee.BeeGrowCropGoal((Bee)this));
    }

    protected void registerBaseGoals() {
        this.f_21345_.m_25352_(0, (Goal)new BeeAttackGoal((PathfinderMob)this, 1.4, true));
        this.enterHiveGoal = new EnterHiveGoal();
        this.f_21345_.m_25352_(1, (Goal)this.enterHiveGoal);
        this.breedGoal = new BreedGoal((Animal)this, 1.0, Boo.class);
        this.f_21345_.m_25352_(2, (Goal)this.breedGoal);
        this.followParentGoal = new FollowParentGoal((Animal)this, 1.25);
        this.f_21345_.m_25352_(5, (Goal)this.followParentGoal);
        this.f_21345_.m_25352_(0, (Goal)new UpdateNestGoal());
        this.f_27700_ = new BooGoToHiveGoal();
        this.f_21345_.m_25352_(5, (Goal)this.f_27700_);
        this.f_21345_.m_25352_(8, (Goal)new BooWanderGoal());
        this.f_21345_.m_25352_(9, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new Bee.BeeHurtByOtherGoal((Bee)this, (Bee)this).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new Bee.BeeBecomeAngryTargetGoal((Bee)this));
        this.f_27699_ = new EmptyPollinateGoal();
        this.f_27701_ = new EmptyFindFlowerGoal();
    }

    public boolean m_7327_(Entity p_27722_) {
        boolean flag = p_27722_.m_6469_(DamageSource.m_19364_((LivingEntity)this), (float)((int)this.m_21133_(Attributes.f_22281_)));
        if (flag) {
            this.m_19970_((LivingEntity)this, p_27722_);
            if (p_27722_ instanceof LivingEntity) {
                ((LivingEntity)p_27722_).m_21321_(((LivingEntity)p_27722_).m_21235_() + 1);
                int i = 0;
                if (this.f_19853_.m_46791_() == Difficulty.NORMAL) {
                    i = 10;
                } else if (this.f_19853_.m_46791_() == Difficulty.HARD) {
                    i = 18;
                }
                if (i > 0) {
                    ((LivingEntity)p_27722_).m_147207_(new MobEffectInstance(MobEffects.f_19614_, i * 20, 0), (Entity)this);
                }
            }
            this.m_27925_(false);
            this.m_5496_(SoundEvents.f_11692_, 1.0f, 1.0f);
        }
        return flag;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_27856_() && this.f_19796_.nextFloat() < 0.05f) {
            for (int i = 0; i < this.f_19796_.nextInt(2) + 1; ++i) {
                this.m_27779_(this.f_19853_, this.m_20185_() - (double)0.3f, this.m_20185_() + (double)0.3f, this.m_20189_() - (double)0.3f, this.m_20189_() + (double)0.3f, this.m_20227_(0.5), (ParticleOptions)ParticleTypes.f_123782_);
            }
        }
    }

    public void m_27779_(Level pLevel, double pStartX, double pEndX, double pStartZ, double pEndZ, double pPosY, ParticleOptions pParticleOption) {
        pLevel.m_7106_(pParticleOption, Mth.m_14139_((double)pLevel.f_46441_.nextDouble(), (double)pStartX, (double)pEndX), pPosY, Mth.m_14139_((double)pLevel.f_46441_.nextDouble(), (double)pStartZ, (double)pEndZ), 0.0, 0.0, 0.0);
    }

    public void m_8107_() {
        if (this.m_6084_()) {
            boolean flag;
            Level level = this.f_19853_;
            boolean bl = flag = this.isSunSensitive() && this.m_21527_();
            if (flag) {
                this.isExposed = true;
            }
            if (this.isExposed) {
                this.vanishingTime -= 1.0f;
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                double d = 0.1;
                float rng = this.m_21187_().nextFloat();
                if (this.isExposed && (double)rng <= d) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_(), this.m_20186_() + 0.2, this.m_20189_(), 2, 0.3, 0.25, 0.3, 0.0);
                }
                if ((double)rng <= d) {
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.GHOST_FLAME.get()), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 1, 0.2, 0.2, 0.2, 0.0);
                }
            }
        }
        super.m_8107_();
    }

    void m_27880_(BlockPos p_27881_) {
        Vec3 vec31;
        Vec3 vec3 = Vec3.m_82539_((Vec3i)p_27881_);
        int i = 0;
        BlockPos blockpos = this.m_142538_();
        int j = (int)vec3.f_82480_ - blockpos.m_123342_();
        if (j > 2) {
            i = 4;
        } else if (j < -2) {
            i = -4;
        }
        int k = 6;
        int l = 8;
        int i1 = blockpos.m_123333_((Vec3i)p_27881_);
        if (i1 < 15) {
            k = i1 / 2;
            l = i1 / 2;
        }
        if ((vec31 = AirRandomPos.m_148387_((PathfinderMob)this, (int)k, (int)l, (int)i, (Vec3)vec3, (double)0.3141592741012573)) != null) {
            this.f_21344_.m_26529_(0.5f);
            this.f_21344_.m_26519_(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, 1.0);
        }
    }

    public boolean m_27866_() {
        if (this.f_27711_ <= 0 && !this.f_27699_.m_28086_() && !this.m_27857_() && this.m_5448_() == null) {
            boolean flag = this.m_27865_() || this.f_19853_.m_46471_() || this.f_19853_.m_46461_() || this.m_27856_();
            return flag && !this.m_27868_();
        }
        return false;
    }

    boolean m_27889_(BlockPos p_27890_) {
        return !this.m_27816_(p_27890_, 32);
    }

    public int getTimeInHive(boolean hasNectar) {
        return 4800;
    }

    public boolean m_6673_(DamageSource source) {
        return source.equals(DamageSource.f_19310_) || source.equals(DamageSource.f_19325_) || super.m_6673_(source);
    }

    @Nonnull
    protected PathNavigation m_6037_(@Nonnull Level worldIn) {
        PathNavigation navigator = super.m_6037_(worldIn);
        if (navigator instanceof FlyingPathNavigation) {
            navigator.m_7008_(false);
            ((FlyingPathNavigation)navigator).m_26443_(false);
        }
        return navigator;
    }

    protected void m_142669_() {
        super.m_142669_();
        if (!this.m_6162_()) {
            BlockPos pos = this.m_142538_();
            if (this.f_19853_.m_46859_(pos)) {
                this.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            } else if (this.f_19853_.m_46859_(pos.m_7495_())) {
                pos = pos.m_7495_();
                this.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            }
        }
    }

    @Nullable
    public Boo getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (Boo)((EntityType)ModEntities.BOO.get()).m_20615_((Level)serverLevel);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.m_6162_() ? sizeIn.f_20378_ * 0.25f : sizeIn.f_20378_ * 0.5f;
    }

    public class TemptGoal
    extends net.minecraft.world.entity.ai.goal.TemptGoal {
        public TemptGoal(PathfinderMob entity, double speed) {
            super(entity, speed, Ingredient.f_43901_, false);
            List<ItemStack> listOfStuff = Arrays.asList(Ingredient.m_204132_((TagKey)ItemTags.f_13149_).m_43908_());
            this.f_25935_ = Ingredient.m_43921_(listOfStuff.stream());
        }
    }

    public class PollinateGoal
    extends Bee.BeePollinateGoal {
        public PollinateGoal() {
            super((Bee)Boo.this);
        }

        public void m_8037_() {
            if (Boo.this.m_27852_()) {
                super.m_8037_();
            }
        }
    }

    public class BeeAttackGoal
    extends MeleeAttackGoal {
        BeeAttackGoal(PathfinderMob mob, double speedModifier, boolean followingTargetEvenIfNotSeen) {
            super(mob, speedModifier, followingTargetEvenIfNotSeen);
        }

        public boolean m_8036_() {
            return super.m_8036_() && Boo.this.m_21660_() && !Boo.this.m_27857_();
        }

        public boolean m_8045_() {
            return super.m_8045_() && Boo.this.m_21660_() && !Boo.this.m_27857_();
        }
    }

    public class EnterHiveGoal
    extends Bee.BeeEnterHiveGoal {
        public EnterHiveGoal() {
            super((Bee)Boo.this);
        }

        public boolean m_7989_() {
            BlockEntity blockEntity;
            if (Boo.this.f_27698_ != null && Boo.this.m_27866_() && Boo.this.f_27698_.m_203195_((Position)Boo.this.m_20182_(), 2.0) && (blockEntity = Boo.this.f_19853_.m_7702_(Boo.this.f_27698_)) instanceof BeehiveBlockEntityAbstract) {
                BeehiveBlockEntityAbstract boohiveBlockEntity = (BeehiveBlockEntityAbstract)blockEntity;
                if (!boohiveBlockEntity.m_58775_()) {
                    return true;
                }
                Boo.this.f_27698_ = null;
            }
            return false;
        }
    }

    public class UpdateNestGoal
    extends Bee.BeeLocateHiveGoal {
        public UpdateNestGoal() {
            super((Bee)Boo.this);
        }

        public void m_8056_() {
            Boo.this.f_27713_ = 200;
            List<BlockPos> nearbyNests = this.getNearbyFreeNests();
            if (!nearbyNests.isEmpty()) {
                BlockPos blockPos;
                Iterator<BlockPos> iterator = nearbyNests.iterator();
                do {
                    if (iterator.hasNext()) continue;
                    Boo.this.f_27700_.m_28006_();
                    Boo.this.f_27698_ = nearbyNests.get(0);
                    return;
                } while (Boo.this.f_27700_.m_27993_(blockPos = iterator.next()));
                Boo.this.f_27698_ = blockPos;
            }
        }

        private List<BlockPos> getNearbyFreeNests() {
            BlockPos pos = Boo.this.m_142538_();
            PoiManager poiManager = ((ServerLevel)Boo.this.f_19853_).m_8904_();
            Stream stream = poiManager.m_27181_(Boo.this.beehiveInterests, pos, 30, PoiManager.Occupancy.ANY);
            return stream.map(PoiRecord::m_27257_).filter(arg_0 -> ((Boo)Boo.this).m_27884_(arg_0)).sorted(Comparator.comparingDouble(vec -> vec.m_123331_((Vec3i)pos))).collect(Collectors.toList());
        }
    }

    public class BooGoToHiveGoal
    extends Bee.BeeGoToHiveGoal {
        int f_27980_;
        public final List<BlockPos> f_27981_;
        @Nullable
        private Path lastPath;
        private int ticksStuck;

        public BooGoToHiveGoal() {
            super((Bee)Boo.this);
            this.f_27980_ = Boo.this.f_19853_.f_46441_.nextInt(10);
            this.f_27981_ = Lists.newArrayList();
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_7989_() {
            return Boo.this.f_27698_ != null && !Boo.this.m_21536_() && Boo.this.m_27866_() && !this.hasReachedTarget(Boo.this.f_27698_) && Boo.this.f_19853_.m_8055_(Boo.this.f_27698_).m_204336_(ModTags.Blocks.BEEHIVES);
        }

        public boolean m_8011_() {
            return this.m_7989_();
        }

        public void m_8056_() {
            this.f_27980_ = 0;
            this.ticksStuck = 0;
            super.m_8056_();
        }

        public void m_8041_() {
            this.f_27980_ = 0;
            this.ticksStuck = 0;
            Boo.this.f_21344_.m_26573_();
            Boo.this.f_21344_.m_26566_();
        }

        public void m_8037_() {
            if (Boo.this.f_27698_ != null) {
                ++this.f_27980_;
                if (this.f_27980_ > this.m_183277_(600)) {
                    this.dropAndBlacklistHive();
                } else if (!Boo.this.f_21344_.m_26572_()) {
                    if (!Boo.this.m_27816_(Boo.this.f_27698_, 16)) {
                        if (Boo.this.m_27889_(Boo.this.f_27698_)) {
                            this.dropHive();
                        } else {
                            Boo.this.m_27880_(Boo.this.f_27698_);
                        }
                    } else {
                        boolean flag = this.pathfindDirectlyTowards(Boo.this.f_27698_);
                        if (!flag) {
                            this.dropAndBlacklistHive();
                        } else if (this.lastPath != null && Boo.this.f_21344_.m_26570_().m_77385_(this.lastPath)) {
                            ++this.ticksStuck;
                            if (this.ticksStuck > 60) {
                                this.dropHive();
                                this.ticksStuck = 0;
                            }
                        } else {
                            this.lastPath = Boo.this.f_21344_.m_26570_();
                        }
                    }
                }
            }
        }

        private boolean pathfindDirectlyTowards(BlockPos pPos) {
            Boo.this.f_21344_.m_26529_(10.0f);
            Boo.this.f_21344_.m_26519_((double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), 1.0);
            return Boo.this.f_21344_.m_26570_() != null && Boo.this.f_21344_.m_26570_().m_77403_();
        }

        public boolean m_27993_(BlockPos pPos) {
            return this.f_27981_.contains(pPos);
        }

        protected void m_27998_(BlockPos pPos) {
            this.f_27981_.add(pPos);
            while (this.f_27981_.size() > 3) {
                this.f_27981_.remove(0);
            }
        }

        public void m_28006_() {
            this.f_27981_.clear();
        }

        private void dropAndBlacklistHive() {
            if (Boo.this.f_27698_ != null) {
                this.m_27998_(Boo.this.f_27698_);
            }
            this.dropHive();
        }

        private void dropHive() {
            Boo.this.f_27698_ = null;
            Boo.this.f_27713_ = 200;
        }

        private boolean hasReachedTarget(BlockPos pPos) {
            if (Boo.this.m_27816_(pPos, 2)) {
                return true;
            }
            Path path = Boo.this.f_21344_.m_26570_();
            return path != null && path.m_77406_().equals((Object)pPos) && path.m_77403_() && path.m_77392_();
        }
    }

    public class BooWanderGoal
    extends Bee.BeeWanderGoal {
        public BooWanderGoal() {
            super((Bee)Boo.this);
        }

        public boolean m_8036_() {
            return super.m_8036_() || Boo.this.f_27698_ != null && !Boo.this.m_27816_(Boo.this.f_27698_, 22);
        }

        public boolean m_8045_() {
            return Boo.this.f_21344_.m_26572_();
        }
    }

    public class EmptyPollinateGoal
    extends PollinateGoal {
        public boolean m_7989_() {
            return false;
        }
    }

    public class EmptyFindFlowerGoal
    extends Bee.BeeGoToKnownFlowerGoal {
        public EmptyFindFlowerGoal() {
            super((Bee)Boo.this);
        }

        public boolean m_7989_() {
            return false;
        }
    }
}

