/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.event;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ttv.migami.jeg.common.FireMode;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.event.GunFireEvent;
import ttv.migami.jeg.item.GunItem;

@Mod.EventBusSubscriber(modid="jeg", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BurstFireEvent {
    private static int burstCount = 0;

    @SubscribeEvent
    public static void preShoot(GunFireEvent.Pre event) {
        GunItem gunItem;
        Gun gun;
        Player player = event.getPlayer();
        ItemStack heldItem = player.m_21205_();
        Item item = heldItem.m_41720_();
        if (item instanceof GunItem && (gun = (gunItem = (GunItem)item).getModifiedGun(heldItem)).getGeneral().getFireMode() == FireMode.BURST) {
            int serverModifier;
            int n = serverModifier = event.getEntity().m_20194_() == null ? 2 : 1;
            if (burstCount / serverModifier >= gun.getGeneral().getBurstAmount()) {
                BurstFireEvent.applyBurstTag(heldItem);
            }
            if (BurstFireEvent.isBursting(heldItem)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void postShoot(GunFireEvent.Post event) {
        GunItem gunItem;
        Gun gun;
        ItemStack heldItem;
        Item item;
        if (!event.isClient() && (item = (heldItem = event.getStack()).m_41720_()) instanceof GunItem && (gun = (gunItem = (GunItem)item).getModifiedGun(heldItem)).getGeneral().getFireMode() == FireMode.BURST && burstCount <= gun.getGeneral().getBurstAmount()) {
            ++burstCount;
        }
    }

    public static boolean isBursting(ItemStack heldItem) {
        boolean burst = false;
        Item item = heldItem.m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            CompoundTag tag = heldItem.m_41783_();
            Gun gun = gunItem.getModifiedGun(heldItem);
            if (tag != null && gun.getGeneral().getFireMode() == FireMode.BURST) {
                burst = tag.m_128471_("Bursting");
            }
        }
        return burst;
    }

    private static void applyBurstTag(ItemStack heldItem) {
        GunItem gunItem;
        Gun gun;
        Item item = heldItem.m_41720_();
        if (item instanceof GunItem && (gun = (gunItem = (GunItem)item).getModifiedGun(heldItem)).getGeneral().getFireMode() == FireMode.BURST) {
            CompoundTag tag = heldItem.m_41784_();
            if (!BurstFireEvent.isBursting(heldItem)) {
                tag.m_128379_("Bursting", true);
            }
        }
    }

    public static void resetBurst(ItemStack heldItem) {
        GunItem gunItem;
        Gun gun;
        Item item = heldItem.m_41720_();
        if (item instanceof GunItem && (gun = (gunItem = (GunItem)item).getModifiedGun(heldItem)).getGeneral().getFireMode() == FireMode.BURST) {
            CompoundTag tag = heldItem.m_41784_();
            burstCount = 0;
            if (BurstFireEvent.isBursting(heldItem)) {
                tag.m_128473_("Bursting");
            }
        }
    }
}

