/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.world.feature;

import java.util.List;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import ttv.migami.jeg.init.ModBlocks;

public class ModOreFeatures {
    public static Holder<PlacedFeature> SCRAP_ORE_REPLACEABLES;
    public static Holder<PlacedFeature> BRIMSTONE_ORE_REPLACEABLES;
    public static Holder<PlacedFeature> BRIMSTONE_ORE_DRIPSTONE_REPLACEABLES;
    public static Holder<PlacedFeature> BRIMSTONE_ORE_NETHER_REPLACEABLES;
    private static final RuleTest STONE;
    private static final RuleTest DEEPSLATE;
    private static final RuleTest DRIPSTONE_BLOCK;
    private static final RuleTest BLACKSTONE;
    private static final RuleTest BASALT;
    private static final List<OreConfiguration.TargetBlockState> ORE_SCRAP_TARGET_LIST;
    private static final List<OreConfiguration.TargetBlockState> ORE_BRIMSTONE_TARGET_LIST;
    private static final List<OreConfiguration.TargetBlockState> ORE_DRIPSTONE_BRIMSTONE_TARGET_LIST;
    private static final List<OreConfiguration.TargetBlockState> ORE_NETHER_BRIMSTONE_TARGET_LIST;

    public static void registerOreFeatures() {
        OreConfiguration scrap_ore = new OreConfiguration(ORE_SCRAP_TARGET_LIST, 10, 0.0f);
        SCRAP_ORE_REPLACEABLES = ModOreFeatures.registerPlacedOreFeature("overworld_scrap_ore", new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)scrap_ore), new PlacementModifier[]{CountPlacement.m_191628_((int)15), InSquarePlacement.m_191715_(), BiomeFilter.m_191561_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)128))});
        OreConfiguration overworld_brimstone_ore = new OreConfiguration(ORE_BRIMSTONE_TARGET_LIST, 9, 0.0f);
        BRIMSTONE_ORE_REPLACEABLES = ModOreFeatures.registerPlacedOreFeature("overworld_brimstone_ore", new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)overworld_brimstone_ore), new PlacementModifier[]{CountPlacement.m_191628_((int)30), InSquarePlacement.m_191715_(), BiomeFilter.m_191561_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)64))});
        OreConfiguration dripstone_brimstone_ore = new OreConfiguration(ORE_DRIPSTONE_BRIMSTONE_TARGET_LIST, 9, 0.0f);
        BRIMSTONE_ORE_DRIPSTONE_REPLACEABLES = ModOreFeatures.registerPlacedOreFeature("dripstone_brimstone_ore", new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)dripstone_brimstone_ore), new PlacementModifier[]{CountPlacement.m_191628_((int)100), InSquarePlacement.m_191715_(), BiomeFilter.m_191561_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)64))});
        OreConfiguration nether_brimstone_ore = new OreConfiguration(ORE_NETHER_BRIMSTONE_TARGET_LIST, 12, 0.0f);
        BRIMSTONE_ORE_NETHER_REPLACEABLES = ModOreFeatures.registerPlacedOreFeature("nether_brimstone_ore", new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)nether_brimstone_ore), new PlacementModifier[]{CountPlacement.m_191628_((int)30), InSquarePlacement.m_191715_(), BiomeFilter.m_191561_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)128))});
    }

    private static <C extends FeatureConfiguration, F extends Feature<C>> Holder<PlacedFeature> registerPlacedOreFeature(String registryName, ConfiguredFeature<C, F> feature, PlacementModifier ... placementModifiers) {
        return PlacementUtils.m_206513_((String)registryName, (Holder)Holder.m_205709_(feature), (PlacementModifier[])placementModifiers);
    }

    public static void onBiomeLoadingEvent(BiomeLoadingEvent event) {
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)event.getName());
        Set types = BiomeDictionary.getTypes((ResourceKey)key);
        if (event.getCategory() == Biome.BiomeCategory.NETHER) {
            event.getGeneration().m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, BRIMSTONE_ORE_NETHER_REPLACEABLES);
        } else if (event.getCategory() != Biome.BiomeCategory.THEEND) {
            event.getGeneration().m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, SCRAP_ORE_REPLACEABLES);
            event.getGeneration().m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, BRIMSTONE_ORE_DRIPSTONE_REPLACEABLES);
            if (types.contains(BiomeDictionary.Type.MESA)) {
                event.getGeneration().m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, BRIMSTONE_ORE_REPLACEABLES);
            }
        }
    }

    static {
        STONE = new BlockMatchTest(Blocks.f_50069_);
        DEEPSLATE = new BlockMatchTest(Blocks.f_152550_);
        DRIPSTONE_BLOCK = new BlockMatchTest(Blocks.f_152537_);
        BLACKSTONE = new BlockMatchTest(Blocks.f_50730_);
        BASALT = new BlockMatchTest(Blocks.f_50137_);
        ORE_SCRAP_TARGET_LIST = List.of(OreConfiguration.m_161021_((RuleTest)STONE, (BlockState)((Block)ModBlocks.SCRAP_ORE.get()).m_49966_()), OreConfiguration.m_161021_((RuleTest)DEEPSLATE, (BlockState)((Block)ModBlocks.DEEPSLATE_SCRAP_ORE.get()).m_49966_()));
        ORE_BRIMSTONE_TARGET_LIST = List.of(OreConfiguration.m_161021_((RuleTest)STONE, (BlockState)((Block)ModBlocks.BRIMSTONE_ORE.get()).m_49966_()), OreConfiguration.m_161021_((RuleTest)DEEPSLATE, (BlockState)((Block)ModBlocks.BRIMSTONE_ORE.get()).m_49966_()));
        ORE_DRIPSTONE_BRIMSTONE_TARGET_LIST = List.of(OreConfiguration.m_161021_((RuleTest)DRIPSTONE_BLOCK, (BlockState)((Block)ModBlocks.BRIMSTONE_ORE.get()).m_49966_()));
        ORE_NETHER_BRIMSTONE_TARGET_LIST = List.of(OreConfiguration.m_161021_((RuleTest)BLACKSTONE, (BlockState)((Block)ModBlocks.BLACKSTONE_BRIMSTONE_ORE.get()).m_49966_()), OreConfiguration.m_161021_((RuleTest)BASALT, (BlockState)((Block)ModBlocks.BASALT_BRIMSTONE_ORE.get()).m_49966_()));
    }
}

