/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.client;

import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.framework.api.data.login.ILoginData;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.Validate;
import ttv.migami.jeg.common.CustomGun;
import ttv.migami.jeg.common.CustomGunLoader;
import ttv.migami.jeg.init.ModItems;
import ttv.migami.jeg.network.message.S2CMessageUpdateGuns;

@Mod.EventBusSubscriber(modid="jeg", value={Dist.CLIENT})
public class CustomGunManager {
    private static Map<ResourceLocation, CustomGun> customGunMap;

    public static boolean updateCustomGuns(S2CMessageUpdateGuns message) {
        return CustomGunManager.updateCustomGuns(message.getCustomGuns());
    }

    private static boolean updateCustomGuns(Map<ResourceLocation, CustomGun> customGunMap) {
        CustomGunManager.customGunMap = customGunMap;
        return true;
    }

    public static void fill(NonNullList<ItemStack> items) {
        if (customGunMap != null) {
            customGunMap.forEach((id, gun) -> {
                ItemStack stack = new ItemStack((ItemLike)ModItems.ASSAULT_RIFLE.get());
                stack.m_41714_((Component)new TranslatableComponent("item." + id.m_135827_() + "." + id.m_135815_() + ".name"));
                CompoundTag tag = stack.m_41784_();
                tag.m_128365_("Model", (Tag)gun.getModel().m_41739_(new CompoundTag()));
                tag.m_128365_("Gun", (Tag)gun.getGun().serializeNBT());
                tag.m_128379_("Custom", true);
                tag.m_128405_("AmmoCount", gun.getGun().getReloads().getMaxAmmo());
                items.add((Object)stack);
            });
        }
    }

    @SubscribeEvent
    public static void onClientDisconnect(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        customGunMap = null;
    }

    public static class LoginData
    implements ILoginData {
        public void writeData(FriendlyByteBuf buffer) {
            Validate.notNull((Object)((Object)CustomGunLoader.get()));
            CustomGunLoader.get().writeCustomGuns(buffer);
        }

        public Optional<String> readData(FriendlyByteBuf buffer) {
            ImmutableMap<ResourceLocation, CustomGun> customGuns = CustomGunLoader.readCustomGuns(buffer);
            CustomGunManager.updateCustomGuns(customGuns);
            return Optional.empty();
        }
    }
}

