/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.client.handler;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import ttv.migami.jeg.Config;
import ttv.migami.jeg.client.GunModel;
import ttv.migami.jeg.client.GunRenderType;
import ttv.migami.jeg.client.SwayType;
import ttv.migami.jeg.client.handler.AimingHandler;
import ttv.migami.jeg.client.handler.RecoilHandler;
import ttv.migami.jeg.client.handler.ReloadHandler;
import ttv.migami.jeg.client.render.gun.IOverrideModel;
import ttv.migami.jeg.client.render.gun.ModelOverrides;
import ttv.migami.jeg.client.util.PropertyHelper;
import ttv.migami.jeg.client.util.RenderUtil;
import ttv.migami.jeg.common.FireMode;
import ttv.migami.jeg.common.GripType;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.common.properties.SightAnimation;
import ttv.migami.jeg.event.GunFireEvent;
import ttv.migami.jeg.init.ModSyncedDataKeys;
import ttv.migami.jeg.item.GrenadeItem;
import ttv.migami.jeg.item.GunItem;
import ttv.migami.jeg.item.attachment.IAttachment;
import ttv.migami.jeg.item.attachment.IBarrel;
import ttv.migami.jeg.item.attachment.impl.Barrel;
import ttv.migami.jeg.item.attachment.impl.Scope;
import ttv.migami.jeg.util.GunEnchantmentHelper;
import ttv.migami.jeg.util.GunModifierHelper;

public class GunRenderingHandler {
    private static GunRenderingHandler instance;
    public static final ResourceLocation MUZZLE_FLASH_TEXTURE;
    private final Random random = new Random();
    private final Set<Integer> entityIdForMuzzleFlash = new HashSet<Integer>();
    private final Set<Integer> entityIdForDrawnMuzzleFlash = new HashSet<Integer>();
    private final Map<Integer, Float> entityIdToRandomValue = new HashMap<Integer, Float>();
    private int sprintTransition;
    private int prevSprintTransition;
    private int sprintCooldown;
    private float sprintIntensity;
    private float offhandTranslate;
    private float prevOffhandTranslate;
    private Field equippedProgressMainHandField;
    private Field prevEquippedProgressMainHandField;
    private float immersiveRoll;
    private float prevImmersiveRoll;
    private float fallSway;
    private float prevFallSway;
    private boolean usedConfiguredFov;
    @Nullable
    private ItemStack renderingWeapon;

    public static GunRenderingHandler get() {
        if (instance == null) {
            instance = new GunRenderingHandler();
        }
        return instance;
    }

    private GunRenderingHandler() {
    }

    @Nullable
    public ItemStack getRenderingWeapon() {
        return this.renderingWeapon;
    }

    public void setUsedConfiguredFov(boolean value) {
        this.usedConfiguredFov = value;
    }

    public boolean getUsedConfiguredFov() {
        return this.usedConfiguredFov;
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        this.updateSprinting();
        this.updateMuzzleFlash();
        this.updateOffhandTranslate();
        this.updateImmersiveCamera();
    }

    private void updateSprinting() {
        this.prevSprintTransition = this.sprintTransition;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && mc.f_91074_.m_20142_() && !((Boolean)ModSyncedDataKeys.SHOOTING.getValue((Entity)mc.f_91074_)).booleanValue() && !((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)mc.f_91074_)).booleanValue() && !AimingHandler.get().isAiming() && this.sprintCooldown == 0) {
            if (this.sprintTransition < 5) {
                ++this.sprintTransition;
            }
        } else if (this.sprintTransition > 0) {
            --this.sprintTransition;
        }
        if (this.sprintCooldown > 0) {
            --this.sprintCooldown;
        }
    }

    private void updateMuzzleFlash() {
        this.entityIdForMuzzleFlash.removeAll(this.entityIdForDrawnMuzzleFlash);
        this.entityIdToRandomValue.keySet().removeAll(this.entityIdForDrawnMuzzleFlash);
        this.entityIdForDrawnMuzzleFlash.clear();
        this.entityIdForDrawnMuzzleFlash.addAll(this.entityIdForMuzzleFlash);
    }

    private void updateOffhandTranslate() {
        this.prevOffhandTranslate = this.offhandTranslate;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        boolean down = false;
        ItemStack heldItem = mc.f_91074_.m_21205_();
        if (heldItem.m_41720_() instanceof GunItem) {
            Gun modifiedGun = ((GunItem)heldItem.m_41720_()).getModifiedGun(heldItem);
            down = !modifiedGun.getGeneral().getGripType().getHeldAnimation().canRenderOffhandItem();
        }
        float direction = down ? -0.3f : 0.3f;
        this.offhandTranslate = Mth.m_14036_((float)(this.offhandTranslate + direction), (float)0.0f, (float)1.0f);
    }

    @SubscribeEvent
    public void onGunFire(GunFireEvent.Post event) {
        if (!event.isClient()) {
            return;
        }
        this.sprintTransition = 0;
        this.sprintCooldown = 20;
        ItemStack heldItem = event.getStack();
        GunItem gunItem = (GunItem)heldItem.m_41720_();
        Gun modifiedGun = gunItem.getModifiedGun(heldItem);
        if (modifiedGun.getDisplay().getFlash() != null) {
            this.showMuzzleFlashForPlayer(Minecraft.m_91087_().f_91074_.m_142049_());
        }
    }

    public void showMuzzleFlashForPlayer(int entityId) {
        this.entityIdForMuzzleFlash.add(entityId);
        this.entityIdToRandomValue.put(entityId, Float.valueOf(this.random.nextFloat()));
    }

    @SubscribeEvent
    public void onComputeFov(EntityViewRenderEvent.FieldOfView event) {
        if (this.usedConfiguredFov) {
            return;
        }
        LocalPlayer player = Objects.requireNonNull(Minecraft.m_91087_().f_91074_);
        ItemStack heldItem = player.m_21205_();
        Item item = heldItem.m_41720_();
        if (!(item instanceof GunItem)) {
            return;
        }
        GunItem gunItem = (GunItem)item;
        Gun modifiedGun = gunItem.getModifiedGun(heldItem);
        if (!modifiedGun.canAimDownSight()) {
            return;
        }
        if (AimingHandler.get().getNormalisedAdsProgress() <= 0.0) {
            return;
        }
        double time = AimingHandler.get().getNormalisedAdsProgress();
        SightAnimation sightAnimation = PropertyHelper.getSightAnimations(heldItem, modifiedGun);
        time = sightAnimation.getViewportCurve().apply(time);
        double viewportFov = PropertyHelper.getViewportFov(heldItem, modifiedGun);
        double newFov = viewportFov > 0.0 ? viewportFov : event.getFOV();
        event.setFOV(Mth.m_14139_((double)time, (double)event.getFOV(), (double)newFov));
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderHandEvent event) {
        Item player;
        PoseStack poseStack = event.getPoseStack();
        boolean right = Minecraft.m_91087_().f_91066_.f_92127_ == HumanoidArm.RIGHT ? event.getHand() == InteractionHand.MAIN_HAND : event.getHand() == InteractionHand.OFF_HAND;
        HumanoidArm hand = right ? HumanoidArm.RIGHT : HumanoidArm.LEFT;
        ItemStack heldItem = event.getItemStack();
        if (event.getHand() == InteractionHand.OFF_HAND) {
            Gun modifiedGun;
            if (heldItem.m_41720_() instanceof GunItem) {
                event.setCanceled(true);
                return;
            }
            float offhand = 1.0f - Mth.m_14179_((float)event.getPartialTicks(), (float)this.prevOffhandTranslate, (float)this.offhandTranslate);
            poseStack.m_85837_(0.0, (double)(offhand * -0.6f), 0.0);
            player = Minecraft.m_91087_().f_91074_;
            if (player != null && player.m_21205_().m_41720_() instanceof GunItem && !(modifiedGun = ((GunItem)player.m_21205_().m_41720_()).getModifiedGun(player.m_21205_())).getGeneral().getGripType().getHeldAnimation().canRenderOffhandItem()) {
                return;
            }
            poseStack.m_85837_(0.0, -1.0 * AimingHandler.get().getNormalisedAdsProgress(), 0.0);
        }
        if (!((player = heldItem.m_41720_()) instanceof GunItem)) {
            return;
        }
        GunItem gunItem = (GunItem)player;
        event.setCanceled(true);
        ItemStack overrideModel = ItemStack.f_41583_;
        if (heldItem.m_41783_() != null && heldItem.m_41783_().m_128425_("Model", 10)) {
            overrideModel = ItemStack.m_41712_((CompoundTag)heldItem.m_41783_().m_128469_("Model"));
        }
        LocalPlayer player2 = Objects.requireNonNull(Minecraft.m_91087_().f_91074_);
        BakedModel model = Minecraft.m_91087_().m_91291_().m_174264_(overrideModel.m_41619_() ? heldItem : overrideModel, player2.f_19853_, (LivingEntity)player2, 0);
        float scaleX = model.m_7442_().f_111790_.f_111757_.m_122239_();
        float scaleY = model.m_7442_().f_111790_.f_111757_.m_122260_();
        float scaleZ = model.m_7442_().f_111790_.f_111757_.m_122269_();
        float translateX = model.m_7442_().f_111790_.f_111756_.m_122239_();
        float translateY = model.m_7442_().f_111790_.f_111756_.m_122260_();
        float translateZ = model.m_7442_().f_111790_.f_111756_.m_122269_();
        poseStack.m_85836_();
        Gun modifiedGun = gunItem.getModifiedGun(heldItem);
        if (AimingHandler.get().getNormalisedAdsProgress() > 0.0 && modifiedGun.canAimDownSight() && event.getHand() == InteractionHand.MAIN_HAND) {
            double xOffset = translateX;
            double yOffset = translateY;
            double zOffset = translateZ;
            xOffset -= 0.5 * (double)scaleX;
            yOffset -= 0.5 * (double)scaleY;
            zOffset -= 0.5 * (double)scaleZ;
            Vec3 gunOrigin = PropertyHelper.getModelOrigin(heldItem, PropertyHelper.GUN_DEFAULT_ORIGIN);
            xOffset += gunOrigin.f_82479_ * 0.0625 * (double)scaleX;
            yOffset += gunOrigin.f_82480_ * 0.0625 * (double)scaleY;
            zOffset += gunOrigin.f_82481_ * 0.0625 * (double)scaleZ;
            Scope scope = Gun.getScope(heldItem);
            if (modifiedGun.canAttachType(IAttachment.Type.SCOPE) && scope != null) {
                Vec3 scopePosition = PropertyHelper.getAttachmentPosition(heldItem, modifiedGun, IAttachment.Type.SCOPE).m_82546_(gunOrigin);
                xOffset += scopePosition.f_82479_ * 0.0625 * (double)scaleX;
                yOffset += scopePosition.f_82480_ * 0.0625 * (double)scaleY;
                zOffset += scopePosition.f_82481_ * 0.0625 * (double)scaleZ;
                ItemStack scopeStack = Gun.getScopeStack(heldItem);
                Vec3 scopeOrigin = PropertyHelper.getModelOrigin(scopeStack, PropertyHelper.ATTACHMENT_DEFAULT_ORIGIN);
                Vec3 scopeCamera = PropertyHelper.getScopeCamera(scopeStack).m_82546_(scopeOrigin);
                Vec3 scopeScale = PropertyHelper.getAttachmentScale(heldItem, modifiedGun, IAttachment.Type.SCOPE);
                xOffset += scopeCamera.f_82479_ * 0.0625 * (double)scaleX * scopeScale.f_82479_;
                yOffset += scopeCamera.f_82480_ * 0.0625 * (double)scaleY * scopeScale.f_82480_;
                zOffset += scopeCamera.f_82481_ * 0.0625 * (double)scaleZ * scopeScale.f_82481_;
            } else {
                Vec3 ironSightCamera = PropertyHelper.getIronSightCamera(heldItem, modifiedGun, gunOrigin).m_82546_(gunOrigin);
                xOffset += ironSightCamera.f_82479_ * 0.0625 * (double)scaleX;
                yOffset += ironSightCamera.f_82480_ * 0.0625 * (double)scaleY;
                zOffset += ironSightCamera.f_82481_ * 0.0625 * (double)scaleZ;
                if (PropertyHelper.isLegacyIronSight(heldItem)) {
                    zOffset += 0.72;
                }
            }
            float side = right ? 1.0f : -1.0f;
            double time = AimingHandler.get().getNormalisedAdsProgress();
            double transition = PropertyHelper.getSightAnimations(heldItem, modifiedGun).getSightCurve().apply(time);
            poseStack.m_85837_(-0.56 * (double)side * transition, 0.52 * transition, 0.72 * transition);
            poseStack.m_85837_(-xOffset * (double)side * transition, -yOffset * transition, -zOffset * transition);
        }
        this.applyBobbingTransforms(poseStack, event.getPartialTicks());
        float equipProgress = this.getEquipProgress(event.getPartialTicks());
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(equipProgress * -50.0f));
        this.renderReloadArm(poseStack, event.getMultiBufferSource(), event.getPackedLight(), modifiedGun, heldItem, hand, translateX);
        int offset = right ? 1 : -1;
        poseStack.m_85837_(0.56 * (double)offset, -0.52, -0.72);
        this.applyAimingTransforms(poseStack, heldItem, modifiedGun, translateX, translateY, translateZ, offset);
        this.applySwayTransforms(poseStack, modifiedGun, player2, translateX, translateY, translateZ, event.getPartialTicks());
        this.applySprintingTransforms(modifiedGun, hand, poseStack, event.getPartialTicks());
        this.applyRecoilTransforms(poseStack, heldItem, modifiedGun);
        this.applyReloadTransforms(poseStack, event.getPartialTicks());
        this.applyShieldTransforms(poseStack, player2, modifiedGun, event.getPartialTicks());
        int blockLight = player2.m_6060_() ? 15 : player2.f_19853_.m_45517_(LightLayer.BLOCK, new BlockPos(player2.m_20299_(event.getPartialTicks())));
        blockLight += this.entityIdForMuzzleFlash.contains(player2.m_142049_()) ? 3 : 0;
        blockLight = Math.min(blockLight, 15);
        int packedLight = LightTexture.m_109885_((int)blockLight, (int)player2.f_19853_.m_45517_(LightLayer.SKY, new BlockPos(player2.m_20299_(event.getPartialTicks()))));
        poseStack.m_85836_();
        modifiedGun.getGeneral().getGripType().getHeldAnimation().renderFirstPersonArms((Player)Minecraft.m_91087_().f_91074_, hand, heldItem, poseStack, event.getMultiBufferSource(), packedLight, event.getPartialTicks());
        poseStack.m_85849_();
        ItemTransforms.TransformType transformType = right ? ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND : ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND;
        this.renderWeapon((LivingEntity)Minecraft.m_91087_().f_91074_, heldItem, transformType, event.getPoseStack(), event.getMultiBufferSource(), packedLight, event.getPartialTicks());
        poseStack.m_85849_();
    }

    private void applyBobbingTransforms(PoseStack poseStack, float partialTicks) {
        Entity entity;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92080_ && (entity = mc.m_91288_()) instanceof Player) {
            Player player = (Player)entity;
            float deltaDistanceWalked = player.f_19787_ - player.f_19867_;
            float distanceWalked = -(player.f_19787_ + deltaDistanceWalked * partialTicks);
            float bobbing = Mth.m_14179_((float)partialTicks, (float)player.f_36099_, (float)player.f_36100_);
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(-(Math.abs(Mth.m_14089_((float)(distanceWalked * (float)Math.PI - 0.2f)) * bobbing) * 5.0f)));
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(-(Mth.m_14031_((float)(distanceWalked * (float)Math.PI)) * bobbing * 3.0f)));
            poseStack.m_85837_((double)(-(Mth.m_14031_((float)(distanceWalked * (float)Math.PI)) * bobbing * 0.5f)), (double)(-(-Math.abs(Mth.m_14089_((float)(distanceWalked * (float)Math.PI)) * bobbing))), 0.0);
            bobbing = (float)((double)bobbing * (player.m_20142_() ? 8.0 : 4.0));
            bobbing = (float)((double)bobbing * (Double)Config.CLIENT.display.bobbingIntensity.get());
            double invertZoomProgress = 1.0 - AimingHandler.get().getNormalisedAdsProgress() * (double)this.sprintIntensity;
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(Mth.m_14031_((float)(distanceWalked * (float)Math.PI)) * bobbing * 3.0f * (float)invertZoomProgress));
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(Math.abs(Mth.m_14089_((float)(distanceWalked * (float)Math.PI - 0.2f)) * bobbing) * 5.0f * (float)invertZoomProgress));
        }
    }

    private void applyAimingTransforms(PoseStack poseStack, ItemStack heldItem, Gun modifiedGun, float x, float y, float z, int offset) {
        if (!((Boolean)Config.CLIENT.display.oldAnimations.get()).booleanValue()) {
            poseStack.m_85837_((double)(x * (float)offset), (double)y, (double)z);
            poseStack.m_85837_(0.0, -0.25, 0.25);
            float aiming = (float)Math.sin(Math.toRadians(AimingHandler.get().getNormalisedAdsProgress() * 180.0));
            aiming = PropertyHelper.getSightAnimations(heldItem, modifiedGun).getAimTransformCurve().apply(aiming);
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(aiming * 10.0f * (float)offset));
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(aiming * 5.0f));
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(aiming * 5.0f * (float)offset));
            poseStack.m_85837_(0.0, 0.25, -0.25);
            poseStack.m_85837_((double)(-x * (float)offset), (double)(-y), (double)(-z));
        }
    }

    private void applySwayTransforms(PoseStack poseStack, Gun modifiedGun, LocalPlayer player, float x, float y, float z, float partialTicks) {
        if (((Boolean)Config.CLIENT.display.weaponSway.get()).booleanValue() && player != null) {
            poseStack.m_85837_((double)x, (double)y, (double)z);
            double zOffset = modifiedGun.getGeneral().getGripType().getHeldAnimation().getFallSwayZOffset();
            poseStack.m_85837_(0.0, -0.25, zOffset);
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14179_((float)partialTicks, (float)this.prevFallSway, (float)this.fallSway)));
            poseStack.m_85837_(0.0, 0.25, -zOffset);
            float bobPitch = Mth.m_14189_((float)partialTicks, (float)player.f_108588_, (float)player.f_108586_);
            float headPitch = Mth.m_14189_((float)partialTicks, (float)player.f_19860_, (float)player.m_146909_());
            float swayPitch = headPitch - bobPitch;
            swayPitch = (float)((double)swayPitch * (1.0 - 0.5 * AimingHandler.get().getNormalisedAdsProgress()));
            poseStack.m_85845_(((SwayType)((Object)Config.CLIENT.display.swayType.get())).getPitchRotation().m_122240_(swayPitch * ((Double)Config.CLIENT.display.swaySensitivity.get()).floatValue()));
            float bobYaw = Mth.m_14189_((float)partialTicks, (float)player.f_108587_, (float)player.f_108585_);
            float headYaw = Mth.m_14189_((float)partialTicks, (float)player.f_20886_, (float)player.f_20885_);
            float swayYaw = headYaw - bobYaw;
            swayYaw = (float)((double)swayYaw * (1.0 - 0.5 * AimingHandler.get().getNormalisedAdsProgress()));
            poseStack.m_85845_(((SwayType)((Object)Config.CLIENT.display.swayType.get())).getYawRotation().m_122240_(swayYaw * ((Double)Config.CLIENT.display.swaySensitivity.get()).floatValue()));
            poseStack.m_85837_((double)(-x), (double)(-y), (double)(-z));
        }
    }

    private void applySprintingTransforms(Gun modifiedGun, HumanoidArm hand, PoseStack poseStack, float partialTicks) {
        if (((Boolean)Config.CLIENT.display.sprintAnimation.get()).booleanValue() && modifiedGun.getGeneral().getGripType().getHeldAnimation().canApplySprintingAnimation()) {
            float leftHanded = hand == HumanoidArm.LEFT ? -1.0f : 1.0f;
            float transition = ((float)this.prevSprintTransition + (float)(this.sprintTransition - this.prevSprintTransition) * partialTicks) / 5.0f;
            transition = (float)Math.sin((double)transition * Math.PI / 2.0);
            poseStack.m_85837_(-0.25 * (double)leftHanded * (double)transition, -0.1 * (double)transition, 0.0);
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(45.0f * leftHanded * transition));
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(-25.0f * transition));
        }
    }

    private void applyReloadTransforms(PoseStack poseStack, float partialTicks) {
        float reloadProgress = ReloadHandler.get().getReloadProgress(partialTicks);
        poseStack.m_85837_(0.0, 0.35 * (double)reloadProgress, 0.0);
        poseStack.m_85837_(0.0, 0.0, -0.1 * (double)reloadProgress);
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(45.0f * reloadProgress));
    }

    private void applyRecoilTransforms(PoseStack poseStack, ItemStack item, Gun gun) {
        double recoilNormal = RecoilHandler.get().getGunRecoilNormal();
        if (Gun.hasAttachmentEquipped(item, gun, IAttachment.Type.SCOPE)) {
            recoilNormal -= recoilNormal * (0.5 * AimingHandler.get().getNormalisedAdsProgress());
        }
        float kickReduction = 1.0f - GunModifierHelper.getKickReduction(item);
        float recoilReduction = 1.0f - GunModifierHelper.getRecoilModifier(item);
        double kick = (double)gun.getGeneral().getRecoilKick() * 0.0625 * recoilNormal * RecoilHandler.get().getAdsRecoilReduction(gun);
        float recoilLift = (float)((double)gun.getGeneral().getRecoilAngle() * recoilNormal) * (float)RecoilHandler.get().getAdsRecoilReduction(gun);
        float recoilSwayAmount = (float)(2.0 + 1.0 * (1.0 - AimingHandler.get().getNormalisedAdsProgress()));
        float recoilSway = (float)((double)(RecoilHandler.get().getGunRecoilRandom() * recoilSwayAmount - recoilSwayAmount / 2.0f) * recoilNormal);
        poseStack.m_85837_(0.0, 0.0, kick * (double)kickReduction);
        poseStack.m_85837_(0.0, 0.0, 0.15);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(recoilSway * recoilReduction));
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(recoilSway * recoilReduction));
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(recoilLift * recoilReduction));
        poseStack.m_85837_(0.0, 0.0, -0.15);
    }

    private void applyShieldTransforms(PoseStack poseStack, LocalPlayer player, Gun modifiedGun, float partialTick) {
        if (player.m_6117_() && player.m_21206_().m_41720_() == Items.f_42740_ && modifiedGun.getGeneral().getGripType() == GripType.ONE_HANDED) {
            double time = Mth.m_14008_((double)((float)player.m_21252_() + partialTick), (double)0.0, (double)4.0) / 4.0;
            poseStack.m_85837_(0.0, 0.35 * time, 0.0);
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(45.0f * (float)time));
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.RenderTickEvent event) {
        float coolDown;
        Gun gun;
        if (event.phase.equals((Object)TickEvent.Phase.START)) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (!mc.m_91302_()) {
            return;
        }
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        if (Minecraft.m_91087_().f_91066_.m_92176_() != CameraType.FIRST_PERSON) {
            return;
        }
        ItemStack heldItem = player.m_21120_(InteractionHand.MAIN_HAND);
        if (heldItem.m_41619_()) {
            return;
        }
        if (player.m_6117_() && player.m_7655_() == InteractionHand.MAIN_HAND && heldItem.m_41720_() instanceof GrenadeItem) {
            float cookTime;
            if (!((GrenadeItem)heldItem.m_41720_()).canCook()) {
                return;
            }
            int duration = player.m_21252_();
            if (duration >= 10 && (cookTime = 1.0f - (float)(duration - 10) / (float)(player.m_21211_().m_41779_() - 10)) > 0.0f) {
                float scale = 3.0f;
                Window window = mc.m_91268_();
                int i = (int)((float)(window.m_85446_() / 2 - 7 - 60) / scale);
                int j = (int)Math.ceil(((float)(window.m_85445_() / 2) - 8.0f * scale) / scale);
                RenderSystem.m_69478_();
                RenderSystem.m_69453_();
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
                PoseStack stack = new PoseStack();
                stack.m_85841_(scale, scale, scale);
                int progress = (int)Math.ceil(cookTime * 17.0f) - 1;
                Screen.m_93133_((PoseStack)stack, (int)j, (int)i, (float)36.0f, (float)94.0f, (int)16, (int)4, (int)256, (int)256);
                Screen.m_93133_((PoseStack)stack, (int)j, (int)i, (float)52.0f, (float)94.0f, (int)progress, (int)4, (int)256, (int)256);
                RenderSystem.m_69461_();
            }
            return;
        }
        if (((Boolean)Config.CLIENT.display.cooldownIndicator.get()).booleanValue() && heldItem.m_41720_() instanceof GunItem && (gun = ((GunItem)heldItem.m_41720_()).getGun()).getGeneral().getFireMode() != FireMode.AUTOMATIC && (coolDown = player.m_36335_().m_41521_(heldItem.m_41720_(), event.renderTickTime)) > 0.0f) {
            float scale = 3.0f;
            Window window = mc.m_91268_();
            int i = (int)((float)(window.m_85446_() / 2 - 7 - 60) / scale);
            int j = (int)Math.ceil(((float)(window.m_85445_() / 2) - 8.0f * scale) / scale);
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
            PoseStack stack = new PoseStack();
            stack.m_85841_(scale, scale, scale);
            int progress = (int)Math.ceil(((double)coolDown + 0.05) * 17.0) - 1;
            Screen.m_93133_((PoseStack)stack, (int)j, (int)i, (float)36.0f, (float)94.0f, (int)16, (int)4, (int)256, (int)256);
            Screen.m_93133_((PoseStack)stack, (int)j, (int)i, (float)52.0f, (float)94.0f, (int)progress, (int)4, (int)256, (int)256);
            RenderSystem.m_69461_();
        }
    }

    public void applyWeaponScale(ItemStack heldItem, PoseStack stack) {
        CompoundTag compound;
        if (heldItem.m_41783_() != null && (compound = heldItem.m_41783_()).m_128425_("Scale", 5)) {
            float scale = compound.m_128457_("Scale");
            stack.m_85841_(scale, scale, scale);
        }
    }

    public boolean renderWeapon(@Nullable LivingEntity entity, ItemStack stack, ItemTransforms.TransformType transformType, PoseStack poseStack, MultiBufferSource renderTypeBuffer, int light, float partialTicks) {
        if (stack.m_41720_() instanceof GunItem) {
            poseStack.m_85836_();
            ItemStack model = ItemStack.f_41583_;
            if (stack.m_41783_() != null && stack.m_41783_().m_128425_("Model", 10)) {
                model = ItemStack.m_41712_((CompoundTag)stack.m_41783_().m_128469_("Model"));
            }
            RenderUtil.applyTransformType(stack, poseStack, transformType, entity);
            this.renderingWeapon = stack;
            this.renderGun(entity, transformType, model.m_41619_() ? stack : model, poseStack, renderTypeBuffer, light, partialTicks);
            this.renderAttachments(entity, transformType, stack, poseStack, renderTypeBuffer, light, partialTicks);
            this.renderMuzzleFlash(entity, poseStack, renderTypeBuffer, stack, transformType, partialTicks);
            this.renderingWeapon = null;
            poseStack.m_85849_();
            return true;
        }
        return false;
    }

    private void renderGun(@Nullable LivingEntity entity, ItemTransforms.TransformType transformType, ItemStack stack, PoseStack poseStack, MultiBufferSource renderTypeBuffer, int light, float partialTicks) {
        if (ModelOverrides.hasModel(stack)) {
            IOverrideModel model = ModelOverrides.getModel(stack);
            if (model != null) {
                model.render(partialTicks, transformType, stack, ItemStack.f_41583_, entity, poseStack, renderTypeBuffer, light, OverlayTexture.f_118083_);
            }
        } else {
            BakedModel bakedModel = Minecraft.m_91087_().m_91291_().m_115103_().m_109406_(stack);
            Minecraft.m_91087_().m_91291_().m_115143_(stack, ItemTransforms.TransformType.NONE, false, poseStack, renderTypeBuffer, light, OverlayTexture.f_118083_, bakedModel);
        }
    }

    private void renderAttachments(@Nullable LivingEntity entity, ItemTransforms.TransformType transformType, ItemStack stack, PoseStack poseStack, MultiBufferSource renderTypeBuffer, int light, float partialTicks) {
        if (stack.m_41720_() instanceof GunItem) {
            Gun modifiedGun = ((GunItem)stack.m_41720_()).getModifiedGun(stack);
            CompoundTag gunTag = stack.m_41784_();
            CompoundTag attachments = gunTag.m_128469_("Attachments");
            for (String tagKey : attachments.m_128431_()) {
                ItemStack attachmentStack;
                IAttachment.Type type = IAttachment.Type.byTagKey(tagKey);
                if (type == null || !modifiedGun.canAttachType(type) || (attachmentStack = Gun.getAttachment(type, stack)).m_41619_()) continue;
                poseStack.m_85836_();
                Vec3 origin = PropertyHelper.getModelOrigin(attachmentStack, PropertyHelper.ATTACHMENT_DEFAULT_ORIGIN);
                poseStack.m_85837_(-origin.f_82479_ * 0.0625, -origin.f_82480_ * 0.0625, -origin.f_82481_ * 0.0625);
                Vec3 gunOrigin = PropertyHelper.getModelOrigin(stack, PropertyHelper.GUN_DEFAULT_ORIGIN);
                poseStack.m_85837_(gunOrigin.f_82479_ * 0.0625, gunOrigin.f_82480_ * 0.0625, gunOrigin.f_82481_ * 0.0625);
                Vec3 translation = PropertyHelper.getAttachmentPosition(stack, modifiedGun, type).m_82546_(gunOrigin);
                poseStack.m_85837_(translation.f_82479_ * 0.0625, translation.f_82480_ * 0.0625, translation.f_82481_ * 0.0625);
                Vec3 scale = PropertyHelper.getAttachmentScale(stack, modifiedGun, type);
                Vec3 center = origin.m_82492_(8.0, 8.0, 8.0).m_82490_(0.0625);
                poseStack.m_85837_(center.f_82479_, center.f_82480_, center.f_82481_);
                poseStack.m_85841_((float)scale.f_82479_, (float)scale.f_82480_, (float)scale.f_82481_);
                poseStack.m_85837_(-center.f_82479_, -center.f_82480_, -center.f_82481_);
                IOverrideModel model = ModelOverrides.getModel(attachmentStack);
                if (model != null) {
                    model.render(partialTicks, transformType, attachmentStack, stack, entity, poseStack, renderTypeBuffer, light, OverlayTexture.f_118083_);
                } else {
                    BakedModel bakedModel = Minecraft.m_91087_().m_91291_().m_115103_().m_109406_(attachmentStack);
                    Minecraft.m_91087_().m_91291_().m_115143_(attachmentStack, ItemTransforms.TransformType.NONE, false, poseStack, renderTypeBuffer, light, OverlayTexture.f_118083_, GunModel.wrap(bakedModel));
                }
                poseStack.m_85849_();
            }
        }
    }

    private void renderMuzzleFlash(@Nullable LivingEntity entity, PoseStack poseStack, MultiBufferSource buffer, ItemStack weapon, ItemTransforms.TransformType transformType, float partialTicks) {
        float randomValue;
        Gun modifiedGun = ((GunItem)weapon.m_41720_()).getModifiedGun(weapon);
        if (modifiedGun.getDisplay().getFlash() == null) {
            return;
        }
        if (transformType != ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND && transformType != ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND && transformType != ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND && transformType != ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND) {
            return;
        }
        if (entity == null || !this.entityIdForMuzzleFlash.contains(entity.m_142049_())) {
            return;
        }
        this.drawMuzzleFlash(weapon, modifiedGun, randomValue, (randomValue = this.entityIdToRandomValue.get(entity.m_142049_()).floatValue()) >= 0.5f, poseStack, buffer, partialTicks);
    }

    private void drawMuzzleFlash(ItemStack weapon, Gun modifiedGun, float random, boolean flip, PoseStack poseStack, MultiBufferSource buffer, float partialTicks) {
        Item item;
        if (!PropertyHelper.hasMuzzleFlash(weapon, modifiedGun)) {
            return;
        }
        poseStack.m_85836_();
        Vec3 weaponOrigin = PropertyHelper.getModelOrigin(weapon, PropertyHelper.GUN_DEFAULT_ORIGIN);
        Vec3 flashPosition = PropertyHelper.getMuzzleFlashPosition(weapon, modifiedGun).m_82546_(weaponOrigin);
        poseStack.m_85837_(weaponOrigin.f_82479_ * 0.0625, weaponOrigin.f_82480_ * 0.0625, weaponOrigin.f_82481_ * 0.0625);
        poseStack.m_85837_(flashPosition.f_82479_ * 0.0625, flashPosition.f_82480_ * 0.0625, flashPosition.f_82481_ * 0.0625);
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        ItemStack barrelStack = Gun.getAttachment(IAttachment.Type.BARREL, weapon);
        if (!barrelStack.m_41619_() && (item = barrelStack.m_41720_()) instanceof IBarrel) {
            IBarrel barrel = (IBarrel)item;
            if (!PropertyHelper.isUsingBarrelMuzzleFlash(barrelStack)) {
                Vec3 scale = PropertyHelper.getAttachmentScale(weapon, modifiedGun, IAttachment.Type.BARREL);
                double length = ((Barrel)barrel.getProperties()).getLength();
                poseStack.m_85837_(0.0, 0.0, -length * 0.0625 * scale.f_82481_);
            }
        }
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(360.0f * random));
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(flip ? 180.0f : 0.0f));
        Vec3 flashScale = PropertyHelper.getMuzzleFlashScale(weapon, modifiedGun);
        float scaleX = (float)flashScale.f_82479_ / 2.0f - (float)flashScale.f_82479_ / 2.0f * (1.0f - partialTicks);
        float scaleY = (float)flashScale.f_82480_ / 2.0f - (float)flashScale.f_82480_ / 2.0f * (1.0f - partialTicks);
        poseStack.m_85841_(scaleX, scaleY, 1.0f);
        float scaleModifier = (float)GunModifierHelper.getMuzzleFlashScale(weapon, 1.0);
        poseStack.m_85841_(scaleModifier, scaleModifier, 1.0f);
        poseStack.m_85837_(-0.5, -0.5, 0.0);
        float minU = weapon.m_41793_() ? 0.5f : 0.0f;
        float maxU = weapon.m_41793_() ? 1.0f : 0.5f;
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        VertexConsumer builder = buffer.m_6299_(GunRenderType.getMuzzleFlash());
        builder.m_85982_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(maxU, 1.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_85982_(matrix, 1.0f, 0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU, 1.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_85982_(matrix, 1.0f, 1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU, 0.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_85982_(matrix, 0.0f, 1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(maxU, 0.0f).m_85969_(0xF000F0).m_5752_();
        poseStack.m_85849_();
    }

    private void renderReloadArm(PoseStack poseStack, MultiBufferSource buffer, int light, Gun modifiedGun, ItemStack stack, HumanoidArm hand, float translateX) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91074_.f_19797_ < ReloadHandler.get().getStartReloadTick() || ReloadHandler.get().getReloadTimer() != 5) {
            return;
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(modifiedGun.getProjectile().getItem());
        if (item == null) {
            return;
        }
        poseStack.m_85836_();
        int side = hand.m_20828_() == HumanoidArm.RIGHT ? 1 : -1;
        poseStack.m_85837_((double)(translateX * (float)side), 0.0, 0.0);
        float interval = GunEnchantmentHelper.getReloadInterval(stack);
        float reload = ((float)(mc.f_91074_.f_19797_ - ReloadHandler.get().getStartReloadTick()) + mc.m_91296_()) % interval / interval;
        float percent = 1.0f - reload;
        if (percent >= 0.5f) {
            percent = 1.0f - percent;
        }
        percent = (double)(percent *= 2.0f) < 0.5 ? 2.0f * percent * percent : -1.0f + (4.0f - 2.0f * percent) * percent;
        poseStack.m_85837_(3.5 * (double)side * 0.0625, -0.5625, -0.5625);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        poseStack.m_85837_(0.0, -0.35 * (1.0 - (double)percent), 0.0);
        poseStack.m_85837_((double)side * 0.0625, 0.0, 0.0);
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(35.0f * (float)(-side)));
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(-75.0f * percent));
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        RenderUtil.renderFirstPersonArm(mc.f_91074_, hand.m_20828_(), poseStack, buffer, light);
        if (reload < 0.5f) {
            poseStack.m_85836_();
            poseStack.m_85837_((double)(-side * 5) * 0.0625, 0.9375, -0.0625);
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
            poseStack.m_85841_(0.75f, 0.75f, 0.75f);
            ItemStack ammo = new ItemStack((ItemLike)item, modifiedGun.getReloads().getReloadAmount());
            BakedModel model = RenderUtil.getModel(ammo);
            boolean isModel = model.m_7539_();
            this.random.setSeed(Item.m_41393_((Item)item));
            int count = Math.min(modifiedGun.getReloads().getReloadAmount(), 5);
            for (int i = 0; i < count; ++i) {
                poseStack.m_85836_();
                if (i > 0) {
                    if (isModel) {
                        x = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                        y = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                        float z = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                        poseStack.m_85837_((double)x, (double)y, (double)z);
                    } else {
                        x = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f * 0.5f;
                        y = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f * 0.5f;
                        poseStack.m_85837_((double)x, (double)y, 0.0);
                    }
                }
                RenderUtil.renderModel(ammo, ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND, poseStack, buffer, light, OverlayTexture.f_118083_, null);
                poseStack.m_85849_();
                if (isModel) continue;
                poseStack.m_85837_(0.0, 0.0, 0.09375);
            }
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    private float getEquipProgress(float partialTicks) {
        if (this.equippedProgressMainHandField == null) {
            this.equippedProgressMainHandField = ObfuscationReflectionHelper.findField(ItemInHandRenderer.class, (String)"f_109302_");
            this.equippedProgressMainHandField.setAccessible(true);
        }
        if (this.prevEquippedProgressMainHandField == null) {
            this.prevEquippedProgressMainHandField = ObfuscationReflectionHelper.findField(ItemInHandRenderer.class, (String)"f_109303_");
            this.prevEquippedProgressMainHandField.setAccessible(true);
        }
        ItemInHandRenderer firstPersonRenderer = Minecraft.m_91087_().m_91292_();
        try {
            float equippedProgressMainHand = ((Float)this.equippedProgressMainHandField.get(firstPersonRenderer)).floatValue();
            float prevEquippedProgressMainHand = ((Float)this.prevEquippedProgressMainHandField.get(firstPersonRenderer)).floatValue();
            return 1.0f - Mth.m_14179_((float)partialTicks, (float)prevEquippedProgressMainHand, (float)equippedProgressMainHand);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    private void updateImmersiveCamera() {
        this.prevImmersiveRoll = this.immersiveRoll;
        this.prevFallSway = this.fallSway;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        ItemStack heldItem = mc.f_91074_.m_21205_();
        float targetAngle = heldItem.m_41720_() instanceof GunItem || (Boolean)Config.CLIENT.display.restrictCameraRollToWeapons.get() == false ? mc.f_91074_.f_108618_.f_108566_ : 0.0f;
        float speed = mc.f_91074_.f_108618_.f_108566_ != 0.0f ? 0.1f : 0.15f;
        this.immersiveRoll = Mth.m_14179_((float)speed, (float)this.immersiveRoll, (float)targetAngle);
        float deltaY = (float)Mth.m_14008_((double)(mc.f_91074_.f_19855_ - mc.f_91074_.m_20186_()), (double)-1.0, (double)1.0);
        deltaY = (float)((double)deltaY * (1.0 - AimingHandler.get().getNormalisedAdsProgress()));
        deltaY = (float)((double)deltaY * (1.0 - (double)(Mth.m_14154_((float)mc.f_91074_.m_146909_()) / 90.0f)));
        this.fallSway = Mth.m_14121_((float)this.fallSway, (float)(deltaY * 60.0f * ((Double)Config.CLIENT.display.swaySensitivity.get()).floatValue()), (float)10.0f);
        float intensity = mc.f_91074_.m_20142_() ? 0.75f : 1.0f;
        this.sprintIntensity = Mth.m_14121_((float)this.sprintIntensity, (float)intensity, (float)0.1f);
    }

    @SubscribeEvent
    public void onCameraSetup(EntityViewRenderEvent.CameraSetup event) {
        if (((Boolean)Config.CLIENT.display.cameraRollEffect.get()).booleanValue()) {
            float roll = (float)Mth.m_14139_((double)event.getPartialTicks(), (double)this.prevImmersiveRoll, (double)this.immersiveRoll);
            roll = (float)Math.sin((double)roll * Math.PI / 2.0);
            event.setRoll(-(roll *= ((Double)Config.CLIENT.display.cameraRollAngle.get()).floatValue()));
        }
    }

    static {
        MUZZLE_FLASH_TEXTURE = new ResourceLocation("jeg", "textures/effect/muzzle_flash.png");
    }
}

