/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.RenderProperties;
import org.lwjgl.opengl.GL11;

public class RenderUtil {
    public static void scissor(int x, int y, int width, int height) {
        Minecraft mc = Minecraft.m_91087_();
        int scale = (int)mc.m_91268_().m_85449_();
        GL11.glScissor((int)(x * scale), (int)(mc.m_91268_().m_85444_() - y * scale - height * scale), (int)Math.max(0, width * scale), (int)Math.max(0, height * scale));
    }

    public static BakedModel getModel(Item item) {
        return Minecraft.m_91087_().m_91291_().m_115103_().m_109406_(new ItemStack((ItemLike)item));
    }

    public static BakedModel getModel(ItemStack item) {
        return Minecraft.m_91087_().m_91291_().m_115103_().m_109406_(item);
    }

    public static void rotateZ(PoseStack poseStack, float xOffset, float yOffset, float rotation) {
        poseStack.m_85837_((double)xOffset, (double)yOffset, 0.0);
        poseStack.m_85845_(Vector3f.f_122226_.m_122240_(rotation));
        poseStack.m_85837_((double)(-xOffset), (double)(-yOffset), 0.0);
    }

    public static void renderGun(ItemStack stack, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, @Nullable LivingEntity entity) {
        RenderUtil.renderModel(stack, ItemTransforms.TransformType.NONE, poseStack, buffer, light, overlay, entity);
    }

    public static void renderModel(ItemStack child, ItemStack parent, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        BakedModel model = Minecraft.m_91087_().m_91291_().m_115103_().m_109406_(child);
        RenderUtil.renderModel(model, ItemTransforms.TransformType.NONE, null, child, parent, poseStack, buffer, light, overlay);
    }

    public static void renderModel(ItemStack stack, ItemTransforms.TransformType transformType, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, @Nullable LivingEntity entity) {
        BakedModel model = Minecraft.m_91087_().m_91291_().m_115103_().m_109406_(stack);
        if (entity != null) {
            model = Minecraft.m_91087_().m_91291_().m_174264_(stack, entity.f_19853_, entity, 0);
        }
        RenderUtil.renderModel(model, transformType, stack, poseStack, buffer, light, overlay);
    }

    public static void renderModel(ItemStack stack, ItemTransforms.TransformType transformType, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, @Nullable Level world, @Nullable LivingEntity entity) {
        BakedModel model = Minecraft.m_91087_().m_91291_().m_174264_(stack, world, entity, 0);
        RenderUtil.renderModel(model, transformType, stack, poseStack, buffer, light, overlay);
    }

    public static void renderModel(BakedModel model, ItemStack stack, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        RenderUtil.renderModel(model, ItemTransforms.TransformType.NONE, stack, poseStack, buffer, light, overlay);
    }

    public static void renderModel(BakedModel model, ItemTransforms.TransformType transformType, ItemStack stack, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        RenderUtil.renderModel(model, transformType, null, stack, ItemStack.f_41583_, poseStack, buffer, light, overlay);
    }

    public static void renderModel(BakedModel model, ItemTransforms.TransformType transformType, @Nullable Transform transform, ItemStack stack, ItemStack parent, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        if (!stack.m_41619_()) {
            boolean flag;
            poseStack.m_85836_();
            boolean bl = flag = transformType == ItemTransforms.TransformType.GUI || transformType == ItemTransforms.TransformType.GROUND || transformType == ItemTransforms.TransformType.FIXED;
            if (stack.m_41720_() == Items.f_42713_ && flag) {
                model = Minecraft.m_91087_().m_91304_().m_119422_(new ModelResourceLocation("minecraft:trident#inventory"));
            }
            model = ForgeHooksClient.handleCameraTransforms((PoseStack)poseStack, (BakedModel)model, (ItemTransforms.TransformType)transformType, (boolean)false);
            poseStack.m_85837_(-0.5, -0.5, -0.5);
            if (!model.m_7521_() && (stack.m_41720_() != Items.f_42713_ || flag)) {
                boolean entity = true;
                if (transformType != ItemTransforms.TransformType.GUI && !transformType.m_111841_() && stack.m_41720_() instanceof BlockItem) {
                    Block block = ((BlockItem)stack.m_41720_()).m_40614_();
                    boolean bl2 = entity = !(block instanceof HalfTransparentBlock) && !(block instanceof StainedGlassPaneBlock);
                }
                if (model.isLayered()) {
                    ForgeHooksClient.drawItemLayered((ItemRenderer)Minecraft.m_91087_().m_91291_(), (BakedModel)model, (ItemStack)stack, (PoseStack)poseStack, (MultiBufferSource)buffer, (int)light, (int)overlay, (boolean)entity);
                } else {
                    VertexConsumer builder;
                    RenderType renderType = RenderUtil.getRenderType(stack, entity);
                    if (stack.m_41720_() == Items.f_42522_ && stack.m_41790_()) {
                        poseStack.m_85836_();
                        PoseStack.Pose entry = poseStack.m_85850_();
                        if (transformType == ItemTransforms.TransformType.GUI) {
                            entry.m_85861_().m_27630_(0.5f);
                        } else if (transformType.m_111841_()) {
                            entry.m_85861_().m_27630_(0.75f);
                        }
                        builder = entity ? ItemRenderer.m_115207_((MultiBufferSource)buffer, (RenderType)renderType, (PoseStack.Pose)entry) : ItemRenderer.m_115180_((MultiBufferSource)buffer, (RenderType)renderType, (PoseStack.Pose)entry);
                        poseStack.m_85849_();
                    } else {
                        builder = entity ? ItemRenderer.m_115222_((MultiBufferSource)buffer, (RenderType)renderType, (boolean)true, (stack.m_41790_() || parent.m_41790_() ? 1 : 0) != 0) : ItemRenderer.m_115211_((MultiBufferSource)buffer, (RenderType)renderType, (boolean)true, (stack.m_41790_() || parent.m_41790_() ? 1 : 0) != 0);
                    }
                    RenderUtil.renderModel(model, stack, parent, transform, poseStack, builder, light, overlay);
                }
            } else {
                RenderProperties.get((ItemStack)stack).getItemStackRenderer().m_108829_(stack, transformType, poseStack, buffer, light, overlay);
            }
            poseStack.m_85849_();
        }
    }

    public static void renderModelWithTransforms(ItemStack child, ItemStack parent, ItemTransforms.TransformType transformType, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        poseStack.m_85836_();
        BakedModel model = Minecraft.m_91087_().m_91291_().m_115103_().m_109406_(child);
        model = ForgeHooksClient.handleCameraTransforms((PoseStack)poseStack, (BakedModel)model, (ItemTransforms.TransformType)transformType, (boolean)false);
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        RenderUtil.renderItemWithoutTransforms(model, child, parent, poseStack, buffer, light, overlay);
        poseStack.m_85849_();
    }

    public static void renderItemWithoutTransforms(BakedModel model, ItemStack stack, ItemStack parent, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        RenderType renderType = RenderUtil.getRenderType(stack, false);
        VertexConsumer builder = ItemRenderer.m_115211_((MultiBufferSource)buffer, (RenderType)renderType, (boolean)true, (stack.m_41790_() || parent.m_41790_() ? 1 : 0) != 0);
        RenderUtil.renderModel(model, stack, parent, null, poseStack, builder, light, overlay);
    }

    public static void renderItemWithoutTransforms(BakedModel model, ItemStack stack, ItemStack parent, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, @Nullable Transform transform) {
        RenderType renderType = RenderUtil.getRenderType(stack, false);
        VertexConsumer builder = ItemRenderer.m_115211_((MultiBufferSource)buffer, (RenderType)renderType, (boolean)true, (stack.m_41790_() || parent.m_41790_() ? 1 : 0) != 0);
        RenderUtil.renderModel(model, stack, parent, transform, poseStack, builder, light, overlay);
    }

    public static void renderModel(BakedModel model, ItemStack stack, ItemStack parent, @Nullable Transform transform, PoseStack poseStack, VertexConsumer buffer, int light, int overlay) {
        if (transform != null) {
            transform.apply();
        }
        Random random = new Random();
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            RenderUtil.renderQuads(poseStack, buffer, model.m_6840_(null, direction, random), stack, parent, light, overlay);
        }
        random.setSeed(42L);
        RenderUtil.renderQuads(poseStack, buffer, model.m_6840_(null, null, random), stack, parent, light, overlay);
    }

    private static void renderQuads(PoseStack poseStack, VertexConsumer buffer, List<BakedQuad> quads, ItemStack stack, ItemStack parent, int light, int overlay) {
        PoseStack.Pose entry = poseStack.m_85850_();
        for (BakedQuad quad : quads) {
            int color = -1;
            if (quad.m_111304_()) {
                color = RenderUtil.getItemStackColor(stack, parent, quad.m_111305_());
            }
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            buffer.putBulkData(entry, quad, red, green, blue, light, overlay, true);
        }
    }

    public static int getItemStackColor(ItemStack stack, ItemStack parent, int tintIndex) {
        int color = Minecraft.m_91087_().getItemColors().m_92676_(stack, tintIndex);
        if (color == -1 && !parent.m_41619_()) {
            return RenderUtil.getItemStackColor(parent, ItemStack.f_41583_, tintIndex);
        }
        return color;
    }

    public static void applyTransformType(ItemStack stack, PoseStack poseStack, ItemTransforms.TransformType transformType, @Nullable LivingEntity entity) {
        BakedModel model = Minecraft.m_91087_().m_91291_().m_174264_(stack, entity != null ? entity.f_19853_ : null, entity, 0);
        boolean leftHanded = transformType == ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND || transformType == ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND;
        ForgeHooksClient.handleCameraTransforms((PoseStack)poseStack, (BakedModel)model, (ItemTransforms.TransformType)transformType, (boolean)leftHanded);
        if (leftHanded) {
            Matrix4f scale = Matrix4f.m_27632_((float)-1.0f, (float)1.0f, (float)1.0f);
            Matrix3f normal = new Matrix3f(scale);
            poseStack.m_85850_().m_85861_().m_27644_(scale);
            poseStack.m_85850_().m_85864_().m_8178_(normal);
        }
    }

    public static boolean isMouseWithin(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    public static void renderFirstPersonArm(LocalPlayer player, HumanoidArm hand, PoseStack poseStack, MultiBufferSource buffer, int combinedLight) {
        Minecraft mc = Minecraft.m_91087_();
        EntityRenderDispatcher renderManager = mc.m_91290_();
        PlayerRenderer renderer = (PlayerRenderer)renderManager.m_114382_((Entity)player);
        RenderSystem.m_157456_((int)0, (ResourceLocation)player.m_108560_());
        if (hand == HumanoidArm.RIGHT) {
            renderer.m_117770_(poseStack, buffer, combinedLight, (AbstractClientPlayer)player);
        } else {
            renderer.m_117813_(poseStack, buffer, combinedLight, (AbstractClientPlayer)player);
        }
    }

    public static RenderType getRenderType(ItemStack stack, boolean entity) {
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            Block block = ((BlockItem)item).m_40614_();
            return ItemBlockRenderTypes.m_109284_((BlockState)block.m_49966_(), (!entity ? 1 : 0) != 0);
        }
        return RenderType.m_110473_((ResourceLocation)InventoryMenu.f_39692_);
    }

    public static interface Transform {
        public void apply();
    }
}

