/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.common;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import ttv.migami.jeg.entity.projectile.ProjectileEntity;
import ttv.migami.jeg.entity.projectile.SpectreProjectileEntity;
import ttv.migami.jeg.entity.projectile.WaterProjectileEntity;
import ttv.migami.jeg.init.ModEntities;
import ttv.migami.jeg.interfaces.IProjectileFactory;

public class ProjectileManager {
    private static ProjectileManager instance = null;
    private final IProjectileFactory DEFAULT_FACTORY = (worldIn, entity, weapon, item, modifiedGun) -> new ProjectileEntity((EntityType<? extends Entity>)((EntityType)ModEntities.PROJECTILE.get()), worldIn, entity, weapon, item, modifiedGun);
    private final IProjectileFactory SPECTRE_FACTORY = (worldIn, entity, weapon, item, modifiedGun) -> new SpectreProjectileEntity((EntityType<? extends Entity>)((EntityType)ModEntities.SPECTRE_PROJECTILE.get()), worldIn, entity, weapon, item, modifiedGun);
    private final IProjectileFactory WATER_FACTORY = (worldIn, entity, weapon, item, modifiedGun) -> new WaterProjectileEntity((EntityType<? extends Entity>)((EntityType)ModEntities.WATER_PROJECTILE.get()), worldIn, entity, weapon, item, modifiedGun);
    private final Map<ResourceLocation, IProjectileFactory> projectileFactoryMap = new HashMap<ResourceLocation, IProjectileFactory>();

    public static ProjectileManager getInstance() {
        if (instance == null) {
            instance = new ProjectileManager();
        }
        return instance;
    }

    public void registerFactory(Item ammo, IProjectileFactory factory) {
        this.projectileFactoryMap.put(ammo.getRegistryName(), factory);
    }

    public IProjectileFactory getFactory(ResourceLocation id) {
        return this.projectileFactoryMap.getOrDefault(id, this.DEFAULT_FACTORY);
    }
}

