/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Stream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class ScrapWorkbenchIngredient
extends Ingredient {
    private final Ingredient.Value itemList;
    private final int count;

    protected ScrapWorkbenchIngredient(Stream<? extends Ingredient.Value> itemList, int count) {
        super(itemList);
        this.itemList = null;
        this.count = count;
    }

    private ScrapWorkbenchIngredient(Ingredient.Value itemList, int count) {
        super(Stream.of(itemList));
        this.itemList = itemList;
        this.count = count;
    }

    public int getCount() {
        return this.count;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static ScrapWorkbenchIngredient fromJson(JsonObject object) {
        Ingredient.Value value = ScrapWorkbenchIngredient.m_43919_((JsonObject)object);
        int count = GsonHelper.m_13824_((JsonObject)object, (String)"count", (int)1);
        return new ScrapWorkbenchIngredient(Stream.of(value), count);
    }

    public JsonElement m_43942_() {
        JsonObject object = this.itemList.m_6544_();
        object.addProperty("count", (Number)this.count);
        return object;
    }

    public static ScrapWorkbenchIngredient of(ItemLike provider, int count) {
        return new ScrapWorkbenchIngredient((Ingredient.Value)new Ingredient.ItemValue(new ItemStack(provider)), count);
    }

    public static ScrapWorkbenchIngredient of(ItemStack stack, int count) {
        return new ScrapWorkbenchIngredient((Ingredient.Value)new Ingredient.ItemValue(stack), count);
    }

    public static ScrapWorkbenchIngredient of(TagKey<Item> tag, int count) {
        return new ScrapWorkbenchIngredient((Ingredient.Value)new Ingredient.TagValue(tag), count);
    }

    public static ScrapWorkbenchIngredient of(ResourceLocation id, int count) {
        return new ScrapWorkbenchIngredient(new UnknownValue(id), count);
    }

    public static class Serializer
    implements IIngredientSerializer<ScrapWorkbenchIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        public ScrapWorkbenchIngredient parse(FriendlyByteBuf buffer) {
            int itemCount = buffer.m_130242_();
            int count = buffer.m_130242_();
            Stream<Ingredient.ItemValue> values = Stream.generate(() -> new Ingredient.ItemValue(buffer.m_130267_())).limit(itemCount);
            return new ScrapWorkbenchIngredient(values, count);
        }

        public ScrapWorkbenchIngredient parse(JsonObject object) {
            return ScrapWorkbenchIngredient.fromJson(object);
        }

        public void write(FriendlyByteBuf buffer, ScrapWorkbenchIngredient ingredient) {
            buffer.m_130130_(ingredient.m_43908_().length);
            buffer.m_130130_(ingredient.count);
            for (ItemStack stack : ingredient.m_43908_()) {
                buffer.m_130055_(stack);
            }
        }
    }

    public static class UnknownValue
    implements Ingredient.Value {
        private final ResourceLocation id;

        public UnknownValue(ResourceLocation id) {
            this.id = id;
        }

        public Collection<ItemStack> m_6223_() {
            return Collections.emptyList();
        }

        public JsonObject m_6544_() {
            JsonObject object = new JsonObject();
            object.addProperty("item", this.id.toString());
            return object;
        }
    }
}

