/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ttv.migami.jeg.common.Gun;

public abstract class GunProvider
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    private final Map<ResourceLocation, Gun> gunMap = new HashMap<ResourceLocation, Gun>();

    protected GunProvider(DataGenerator generator) {
        this.generator = generator;
    }

    protected abstract void registerGuns();

    protected final void addGun(ResourceLocation id, Gun gun) {
        this.gunMap.put(id, gun);
    }

    public void m_6865_(HashCache cache) {
        this.gunMap.clear();
        this.registerGuns();
        this.gunMap.forEach((id, gun) -> {
            Path path = this.generator.m_123916_().resolve("data/" + id.m_135827_() + "/guns/" + id.m_135815_() + ".json");
            try {
                JsonObject object = gun.toJsonObject();
                String rawJson = GSON.toJson((JsonElement)object);
                String hash = f_123918_.hashUnencodedChars((CharSequence)rawJson).toString();
                if (!Objects.equals(cache.m_123938_(path), hash) || !Files.exists(path, new LinkOption[0])) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                        writer.write(rawJson);
                    }
                }
                cache.m_123940_(path, hash);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save trades to {}", (Object)path, (Object)e);
            }
        });
    }

    public String m_6055_() {
        return "Guns: jeg";
    }
}

